/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.batch.DefaultEarmarkedFundsDocumentServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the earmarked fund master data from SAP S/4HANA Cloud
 * system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1e/1ab89beffa432ab0ff9f1f836f624c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_EARMARKEDFUNDSDOCUMENT_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_EARMARKEDFUNDSDOCUMENT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Manage Earmarked Fund Document Integration(SAP_COM_0934)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4GY'>Earmarked Funds(4GY)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Earmarked Funds</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultEarmarkedFundsDocumentService" )
@Deprecated
public class DefaultEarmarkedFundsDocumentService implements EarmarkedFundsDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link EarmarkedFundsDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultEarmarkedFundsDocumentService()
    {
        servicePath = EarmarkedFundsDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultEarmarkedFundsDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultEarmarkedFundsDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultEarmarkedFundsDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultEarmarkedFundsDocumentServiceBatch batch()
    {
        return new DefaultEarmarkedFundsDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentFluentHelper getAllEarmarkedFundsDocument()
    {
        return new EarmarkedFundsDocumentFluentHelper(servicePath, "EarmarkedFundsDocument");
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentByKeyFluentHelper getEarmarkedFundsDocumentByKey( final String earmarkedFundsDocument )
    {
        return new EarmarkedFundsDocumentByKeyFluentHelper(
            servicePath,
            "EarmarkedFundsDocument",
            earmarkedFundsDocument);
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentCreateFluentHelper createEarmarkedFundsDocument(
        @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument )
    {
        return new EarmarkedFundsDocumentCreateFluentHelper(
            servicePath,
            earmarkedFundsDocument,
            "EarmarkedFundsDocument");
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentUpdateFluentHelper updateEarmarkedFundsDocument(
        @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument )
    {
        return new EarmarkedFundsDocumentUpdateFluentHelper(
            servicePath,
            earmarkedFundsDocument,
            "EarmarkedFundsDocument");
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentItemFluentHelper getAllEarmarkedFundsDocumentItem()
    {
        return new EarmarkedFundsDocumentItemFluentHelper(servicePath, "EarmarkedFundsDocumentItem");
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentItemByKeyFluentHelper getEarmarkedFundsDocumentItemByKey(
        final String earmarkedFundsDocument,
        final String earmarkedFundsDocumentItem )
    {
        return new EarmarkedFundsDocumentItemByKeyFluentHelper(
            servicePath,
            "EarmarkedFundsDocumentItem",
            earmarkedFundsDocument,
            earmarkedFundsDocumentItem);
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentItemUpdateFluentHelper updateEarmarkedFundsDocumentItem(
        @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem )
    {
        return new EarmarkedFundsDocumentItemUpdateFluentHelper(
            servicePath,
            earmarkedFundsDocumentItem,
            "EarmarkedFundsDocumentItem");
    }

    @Override
    @Nonnull
    public EarmarkedFundsDocumentItemDeleteFluentHelper deleteEarmarkedFundsDocumentItem(
        @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem )
    {
        return new EarmarkedFundsDocumentItemDeleteFluentHelper(
            servicePath,
            earmarkedFundsDocumentItem,
            "EarmarkedFundsDocumentItem");
    }

}
