/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.SetProcessingStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.SetProjElemProcessingStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.batch.DefaultEnterpriseProjectServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update or delete the project definition or the project elements of
 * enterprise projects. The service is based on the OData protocol and can be consumed by apps and other user
 * interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/a2/02054eb04a432bbd89bb89da638256/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_ENTERPRISE_PROJECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_ENTERPRISE_PROJECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Project Integration (SAP_COM_0308)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NT'>Project Financial Control (1NT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1YF'>Project Review (1YF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONT'>Project Financial Control (ONT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>EnterpriseProject</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2102 (Feb 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultEnterpriseProjectService" )
@Deprecated
public class DefaultEnterpriseProjectService implements EnterpriseProjectService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link EnterpriseProjectService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultEnterpriseProjectService()
    {
        servicePath = EnterpriseProjectService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultEnterpriseProjectService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultEnterpriseProjectService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultEnterpriseProjectService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultEnterpriseProjectServiceBatch batch()
    {
        return new DefaultEnterpriseProjectServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncFluentHelper getAllEnterpriseProjBlkFunc()
    {
        return new EnterpriseProjBlkFuncFluentHelper(servicePath, "A_EnterpriseProjBlkFunc");
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncByKeyFluentHelper getEnterpriseProjBlkFuncByKey( final UUID projectUUID )
    {
        return new EnterpriseProjBlkFuncByKeyFluentHelper(servicePath, "A_EnterpriseProjBlkFunc", projectUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncCreateFluentHelper createEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return new EnterpriseProjBlkFuncCreateFluentHelper(
            servicePath,
            enterpriseProjBlkFunc,
            "A_EnterpriseProjBlkFunc");
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncUpdateFluentHelper updateEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return new EnterpriseProjBlkFuncUpdateFluentHelper(
            servicePath,
            enterpriseProjBlkFunc,
            "A_EnterpriseProjBlkFunc");
    }

    @Override
    @Nonnull
    public EnterpriseProjectFluentHelper getAllEnterpriseProject()
    {
        return new EnterpriseProjectFluentHelper(servicePath, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EnterpriseProjectByKeyFluentHelper getEnterpriseProjectByKey( final UUID projectUUID )
    {
        return new EnterpriseProjectByKeyFluentHelper(servicePath, "A_EnterpriseProject", projectUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjectCreateFluentHelper createEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return new EnterpriseProjectCreateFluentHelper(servicePath, enterpriseProject, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EnterpriseProjectUpdateFluentHelper updateEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return new EnterpriseProjectUpdateFluentHelper(servicePath, enterpriseProject, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EnterpriseProjectDeleteFluentHelper deleteEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return new EnterpriseProjectDeleteFluentHelper(servicePath, enterpriseProject, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementFluentHelper getAllEnterpriseProjectElement()
    {
        return new EnterpriseProjectElementFluentHelper(servicePath, "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementByKeyFluentHelper getEnterpriseProjectElementByKey( final UUID projectElementUUID )
    {
        return new EnterpriseProjectElementByKeyFluentHelper(
            servicePath,
            "A_EnterpriseProjectElement",
            projectElementUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementCreateFluentHelper createEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return new EnterpriseProjectElementCreateFluentHelper(
            servicePath,
            enterpriseProjectElement,
            "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementUpdateFluentHelper updateEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return new EnterpriseProjectElementUpdateFluentHelper(
            servicePath,
            enterpriseProjectElement,
            "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementDeleteFluentHelper deleteEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return new EnterpriseProjectElementDeleteFluentHelper(
            servicePath,
            enterpriseProjectElement,
            "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EntProjectElmntPublicSectorFluentHelper getAllEntProjectElmntPublicSector()
    {
        return new EntProjectElmntPublicSectorFluentHelper(servicePath, "A_EntProjectElmntPublicSector");
    }

    @Override
    @Nonnull
    public EntProjectElmntPublicSectorByKeyFluentHelper getEntProjectElmntPublicSectorByKey(
        final UUID projectElementUUID )
    {
        return new EntProjectElmntPublicSectorByKeyFluentHelper(
            servicePath,
            "A_EntProjectElmntPublicSector",
            projectElementUUID);
    }

    @Override
    @Nonnull
    public EntProjectElmntPublicSectorUpdateFluentHelper updateEntProjectElmntPublicSector(
        @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector )
    {
        return new EntProjectElmntPublicSectorUpdateFluentHelper(
            servicePath,
            entProjectElmntPublicSector,
            "A_EntProjectElmntPublicSector");
    }

    @Override
    @Nonnull
    public EntProjectPublicSectorFluentHelper getAllEntProjectPublicSector()
    {
        return new EntProjectPublicSectorFluentHelper(servicePath, "A_EntProjectPublicSector");
    }

    @Override
    @Nonnull
    public EntProjectPublicSectorByKeyFluentHelper getEntProjectPublicSectorByKey( final UUID projectUUID )
    {
        return new EntProjectPublicSectorByKeyFluentHelper(servicePath, "A_EntProjectPublicSector", projectUUID);
    }

    @Override
    @Nonnull
    public EntProjectPublicSectorUpdateFluentHelper updateEntProjectPublicSector(
        @Nonnull final EntProjectPublicSector entProjectPublicSector )
    {
        return new EntProjectPublicSectorUpdateFluentHelper(
            servicePath,
            entProjectPublicSector,
            "A_EntProjectPublicSector");
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncFluentHelper getAllEntProjElmntBlockFunc()
    {
        return new EntProjElmntBlockFuncFluentHelper(servicePath, "A_EntProjElmntBlockFunc");
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncByKeyFluentHelper getEntProjElmntBlockFuncByKey( final UUID projectElementUUID )
    {
        return new EntProjElmntBlockFuncByKeyFluentHelper(servicePath, "A_EntProjElmntBlockFunc", projectElementUUID);
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncCreateFluentHelper createEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return new EntProjElmntBlockFuncCreateFluentHelper(
            servicePath,
            entProjElmntBlockFunc,
            "A_EntProjElmntBlockFunc");
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncUpdateFluentHelper updateEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return new EntProjElmntBlockFuncUpdateFluentHelper(
            servicePath,
            entProjElmntBlockFunc,
            "A_EntProjElmntBlockFunc");
    }

    @Override
    @Nonnull
    public
        SetProcessingStatusFluentHelper
        setProcessingStatus( @Nonnull final UUID projectUUID, @Nullable final String processingStatus )
    {
        return new SetProcessingStatusFluentHelper(servicePath, projectUUID, processingStatus);
    }

    @Override
    @Nonnull
    public
        SetProjElemProcessingStatusFluentHelper
        setProjElemProcessingStatus( @Nonnull final UUID projectElementUUID, @Nullable final String processingStatus )
    {
        return new SetProjElemProcessingStatusFluentHelper(servicePath, projectElementUUID, processingStatus);
    }

}
