/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjElmntPositionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjElmntProcgStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjProcgStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.batch.DefaultEnterpriseProjectV2ServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, update or delete the project definition or the project elements of
 * enterprise projects or professional services projects. The service is based on the OData protocol and can be consumed
 * by apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b4/67d86283be4a56869f1e6784e47b64/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_ENTERPRISE_PROJECT_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_ENTERPRISE_PROJECT_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Project Integration(SAP_COM_0308)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NT'>Project Control - Finance(1NT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1YF'>Project Review(1YF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONT'>Project Control - Finance(ONT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OYF'>Project Review(OYF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Enterprise Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultEnterpriseProjectV2Service" )
@Deprecated
public class DefaultEnterpriseProjectV2Service implements EnterpriseProjectV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link EnterpriseProjectV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultEnterpriseProjectV2Service()
    {
        servicePath = EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultEnterpriseProjectV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultEnterpriseProjectV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultEnterpriseProjectV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultEnterpriseProjectV2ServiceBatch batch()
    {
        return new DefaultEnterpriseProjectV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncFluentHelper getAllEnterpriseProjBlkFunc()
    {
        return new EnterpriseProjBlkFuncFluentHelper(servicePath, "A_EnterpriseProjBlkFunc");
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncByKeyFluentHelper getEnterpriseProjBlkFuncByKey( final UUID projectUUID )
    {
        return new EnterpriseProjBlkFuncByKeyFluentHelper(servicePath, "A_EnterpriseProjBlkFunc", projectUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncCreateFluentHelper createEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return new EnterpriseProjBlkFuncCreateFluentHelper(
            servicePath,
            enterpriseProjBlkFunc,
            "A_EnterpriseProjBlkFunc");
    }

    @Override
    @Nonnull
    public EnterpriseProjBlkFuncUpdateFluentHelper updateEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return new EnterpriseProjBlkFuncUpdateFluentHelper(
            servicePath,
            enterpriseProjBlkFunc,
            "A_EnterpriseProjBlkFunc");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementFluentHelper getAllEnterpriseProjectElement()
    {
        return new EnterpriseProjectElementFluentHelper(servicePath, "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementByKeyFluentHelper getEnterpriseProjectElementByKey( final UUID projectElementUUID )
    {
        return new EnterpriseProjectElementByKeyFluentHelper(
            servicePath,
            "A_EnterpriseProjectElement",
            projectElementUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementCreateFluentHelper createEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return new EnterpriseProjectElementCreateFluentHelper(
            servicePath,
            enterpriseProjectElement,
            "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementUpdateFluentHelper updateEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return new EnterpriseProjectElementUpdateFluentHelper(
            servicePath,
            enterpriseProjectElement,
            "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EnterpriseProjectElementDeleteFluentHelper deleteEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return new EnterpriseProjectElementDeleteFluentHelper(
            servicePath,
            enterpriseProjectElement,
            "A_EnterpriseProjectElement");
    }

    @Override
    @Nonnull
    public EnterpriseProjectJVAFluentHelper getAllEnterpriseProjectJVA()
    {
        return new EnterpriseProjectJVAFluentHelper(servicePath, "A_EnterpriseProjectJVA");
    }

    @Override
    @Nonnull
    public EnterpriseProjectJVAByKeyFluentHelper getEnterpriseProjectJVAByKey( final UUID projectUUID )
    {
        return new EnterpriseProjectJVAByKeyFluentHelper(servicePath, "A_EnterpriseProjectJVA", projectUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjectJVAUpdateFluentHelper updateEnterpriseProjectJVA(
        @Nonnull final EnterpriseProjectJVA enterpriseProjectJVA )
    {
        return new EnterpriseProjectJVAUpdateFluentHelper(servicePath, enterpriseProjectJVA, "A_EnterpriseProjectJVA");
    }

    @Override
    @Nonnull
    public EnterpriseProjectRoleFluentHelper getAllEnterpriseProjectRole()
    {
        return new EnterpriseProjectRoleFluentHelper(servicePath, "A_EnterpriseProjectRole");
    }

    @Override
    @Nonnull
    public EnterpriseProjectRoleByKeyFluentHelper getEnterpriseProjectRoleByKey( final UUID projectRoleUUID )
    {
        return new EnterpriseProjectRoleByKeyFluentHelper(servicePath, "A_EnterpriseProjectRole", projectRoleUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjectRoleCreateFluentHelper createEnterpriseProjectRole(
        @Nonnull final EnterpriseProjectRole enterpriseProjectRole )
    {
        return new EnterpriseProjectRoleCreateFluentHelper(
            servicePath,
            enterpriseProjectRole,
            "A_EnterpriseProjectRole");
    }

    @Override
    @Nonnull
    public EnterpriseProjectTeamMemberFluentHelper getAllEnterpriseProjectTeamMember()
    {
        return new EnterpriseProjectTeamMemberFluentHelper(servicePath, "A_EnterpriseProjectTeamMember");
    }

    @Override
    @Nonnull
    public EnterpriseProjectTeamMemberByKeyFluentHelper getEnterpriseProjectTeamMemberByKey( final UUID teamMemberUUID )
    {
        return new EnterpriseProjectTeamMemberByKeyFluentHelper(
            servicePath,
            "A_EnterpriseProjectTeamMember",
            teamMemberUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjectTeamMemberCreateFluentHelper createEnterpriseProjectTeamMember(
        @Nonnull final EnterpriseProjectTeamMember enterpriseProjectTeamMember )
    {
        return new EnterpriseProjectTeamMemberCreateFluentHelper(
            servicePath,
            enterpriseProjectTeamMember,
            "A_EnterpriseProjectTeamMember");
    }

    @Override
    @Nonnull
    public EnterpriseProjectFluentHelper getAllEnterpriseProject()
    {
        return new EnterpriseProjectFluentHelper(servicePath, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EnterpriseProjectByKeyFluentHelper getEnterpriseProjectByKey( final UUID projectUUID )
    {
        return new EnterpriseProjectByKeyFluentHelper(servicePath, "A_EnterpriseProject", projectUUID);
    }

    @Override
    @Nonnull
    public EnterpriseProjectCreateFluentHelper createEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return new EnterpriseProjectCreateFluentHelper(servicePath, enterpriseProject, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EnterpriseProjectUpdateFluentHelper updateEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return new EnterpriseProjectUpdateFluentHelper(servicePath, enterpriseProject, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EnterpriseProjectDeleteFluentHelper deleteEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return new EnterpriseProjectDeleteFluentHelper(servicePath, enterpriseProject, "A_EnterpriseProject");
    }

    @Override
    @Nonnull
    public EntProjectElementJVAFluentHelper getAllEntProjectElementJVA()
    {
        return new EntProjectElementJVAFluentHelper(servicePath, "A_EntProjectElementJVA");
    }

    @Override
    @Nonnull
    public EntProjectElementJVAByKeyFluentHelper getEntProjectElementJVAByKey( final UUID projectElementUUID )
    {
        return new EntProjectElementJVAByKeyFluentHelper(servicePath, "A_EntProjectElementJVA", projectElementUUID);
    }

    @Override
    @Nonnull
    public EntProjectElementJVAUpdateFluentHelper updateEntProjectElementJVA(
        @Nonnull final EntProjectElementJVA entProjectElementJVA )
    {
        return new EntProjectElementJVAUpdateFluentHelper(servicePath, entProjectElementJVA, "A_EntProjectElementJVA");
    }

    @Override
    @Nonnull
    public EntProjectPublicSectorFluentHelper getAllEntProjectPublicSector()
    {
        return new EntProjectPublicSectorFluentHelper(servicePath, "A_EntProjectPublicSector");
    }

    @Override
    @Nonnull
    public EntProjectPublicSectorByKeyFluentHelper getEntProjectPublicSectorByKey( final UUID projectUUID )
    {
        return new EntProjectPublicSectorByKeyFluentHelper(servicePath, "A_EntProjectPublicSector", projectUUID);
    }

    @Override
    @Nonnull
    public EntProjectPublicSectorUpdateFluentHelper updateEntProjectPublicSector(
        @Nonnull final EntProjectPublicSector entProjectPublicSector )
    {
        return new EntProjectPublicSectorUpdateFluentHelper(
            servicePath,
            entProjectPublicSector,
            "A_EntProjectPublicSector");
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncFluentHelper getAllEntProjElmntBlockFunc()
    {
        return new EntProjElmntBlockFuncFluentHelper(servicePath, "A_EntProjElmntBlockFunc");
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncByKeyFluentHelper getEntProjElmntBlockFuncByKey( final UUID projectElementUUID )
    {
        return new EntProjElmntBlockFuncByKeyFluentHelper(servicePath, "A_EntProjElmntBlockFunc", projectElementUUID);
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncCreateFluentHelper createEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return new EntProjElmntBlockFuncCreateFluentHelper(
            servicePath,
            entProjElmntBlockFunc,
            "A_EntProjElmntBlockFunc");
    }

    @Override
    @Nonnull
    public EntProjElmntBlockFuncUpdateFluentHelper updateEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return new EntProjElmntBlockFuncUpdateFluentHelper(
            servicePath,
            entProjElmntBlockFunc,
            "A_EntProjElmntBlockFunc");
    }

    @Override
    @Nonnull
    public EntProjElmntDlvbrlFluentHelper getAllEntProjElmntDlvbrl()
    {
        return new EntProjElmntDlvbrlFluentHelper(servicePath, "A_EntProjElmntDlvbrl");
    }

    @Override
    @Nonnull
    public EntProjElmntDlvbrlByKeyFluentHelper getEntProjElmntDlvbrlByKey( final UUID entProjElmntDeliverableUUID )
    {
        return new EntProjElmntDlvbrlByKeyFluentHelper(
            servicePath,
            "A_EntProjElmntDlvbrl",
            entProjElmntDeliverableUUID);
    }

    @Override
    @Nonnull
    public EntProjElmntDlvbrlCreateFluentHelper createEntProjElmntDlvbrl(
        @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl )
    {
        return new EntProjElmntDlvbrlCreateFluentHelper(servicePath, entProjElmntDlvbrl, "A_EntProjElmntDlvbrl");
    }

    @Override
    @Nonnull
    public EntProjElmntDlvbrlUpdateFluentHelper updateEntProjElmntDlvbrl(
        @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl )
    {
        return new EntProjElmntDlvbrlUpdateFluentHelper(servicePath, entProjElmntDlvbrl, "A_EntProjElmntDlvbrl");
    }

    @Override
    @Nonnull
    public EntProjElmntDlvbrlDistrFluentHelper getAllEntProjElmntDlvbrlDistr()
    {
        return new EntProjElmntDlvbrlDistrFluentHelper(servicePath, "A_EntProjElmntDlvbrlDistr");
    }

    @Override
    @Nonnull
    public EntProjElmntDlvbrlDistrByKeyFluentHelper getEntProjElmntDlvbrlDistrByKey(
        final UUID entProjElmntDlvbrlDistrUUID )
    {
        return new EntProjElmntDlvbrlDistrByKeyFluentHelper(
            servicePath,
            "A_EntProjElmntDlvbrlDistr",
            entProjElmntDlvbrlDistrUUID);
    }

    @Override
    @Nonnull
    public EntProjElmntDlvbrlDistrUpdateFluentHelper updateEntProjElmntDlvbrlDistr(
        @Nonnull final EntProjElmntDlvbrlDistr entProjElmntDlvbrlDistr )
    {
        return new EntProjElmntDlvbrlDistrUpdateFluentHelper(
            servicePath,
            entProjElmntDlvbrlDistr,
            "A_EntProjElmntDlvbrlDistr");
    }

    @Override
    @Nonnull
    public EntProjectElmntPublicSectorFluentHelper getAllEntProjectElmntPublicSector()
    {
        return new EntProjectElmntPublicSectorFluentHelper(servicePath, "A_EntProjectElmntPublicSector");
    }

    @Override
    @Nonnull
    public EntProjectElmntPublicSectorByKeyFluentHelper getEntProjectElmntPublicSectorByKey(
        final UUID projectElementUUID )
    {
        return new EntProjectElmntPublicSectorByKeyFluentHelper(
            servicePath,
            "A_EntProjectElmntPublicSector",
            projectElementUUID);
    }

    @Override
    @Nonnull
    public EntProjectElmntPublicSectorUpdateFluentHelper updateEntProjectElmntPublicSector(
        @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector )
    {
        return new EntProjectElmntPublicSectorUpdateFluentHelper(
            servicePath,
            entProjectElmntPublicSector,
            "A_EntProjectElmntPublicSector");
    }

    @Override
    @Nonnull
    public EntProjElmntWorkItemFluentHelper getAllEntProjElmntWorkItem()
    {
        return new EntProjElmntWorkItemFluentHelper(servicePath, "A_EntProjElmntWorkItem");
    }

    @Override
    @Nonnull
    public EntProjElmntWorkItemByKeyFluentHelper getEntProjElmntWorkItemByKey( final UUID entProjElmntWorkItemUUID )
    {
        return new EntProjElmntWorkItemByKeyFluentHelper(
            servicePath,
            "A_EntProjElmntWorkItem",
            entProjElmntWorkItemUUID);
    }

    @Override
    @Nonnull
    public EntProjElmntWorkItemUpdateFluentHelper updateEntProjElmntWorkItem(
        @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem )
    {
        return new EntProjElmntWorkItemUpdateFluentHelper(servicePath, entProjElmntWorkItem, "A_EntProjElmntWorkItem");
    }

    @Override
    @Nonnull
    public EntProjElmntWorkItemDeleteFluentHelper deleteEntProjElmntWorkItem(
        @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem )
    {
        return new EntProjElmntWorkItemDeleteFluentHelper(servicePath, entProjElmntWorkItem, "A_EntProjElmntWorkItem");
    }

    @Override
    @Nonnull
    public EntTeamMemberEntitlementFluentHelper getAllEntTeamMemberEntitlement()
    {
        return new EntTeamMemberEntitlementFluentHelper(servicePath, "A_EntTeamMemberEntitlement");
    }

    @Override
    @Nonnull
    public EntTeamMemberEntitlementByKeyFluentHelper getEntTeamMemberEntitlementByKey(
        final UUID projectEntitlementUUID )
    {
        return new EntTeamMemberEntitlementByKeyFluentHelper(
            servicePath,
            "A_EntTeamMemberEntitlement",
            projectEntitlementUUID);
    }

    @Override
    @Nonnull
    public EntTeamMemberEntitlementCreateFluentHelper createEntTeamMemberEntitlement(
        @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement )
    {
        return new EntTeamMemberEntitlementCreateFluentHelper(
            servicePath,
            entTeamMemberEntitlement,
            "A_EntTeamMemberEntitlement");
    }

    @Override
    @Nonnull
    public EntTeamMemberEntitlementUpdateFluentHelper updateEntTeamMemberEntitlement(
        @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement )
    {
        return new EntTeamMemberEntitlementUpdateFluentHelper(
            servicePath,
            entTeamMemberEntitlement,
            "A_EntTeamMemberEntitlement");
    }

    @Override
    @Nonnull
    public EntTeamMemberEntitlementDeleteFluentHelper deleteEntTeamMemberEntitlement(
        @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement )
    {
        return new EntTeamMemberEntitlementDeleteFluentHelper(
            servicePath,
            entTeamMemberEntitlement,
            "A_EntTeamMemberEntitlement");
    }

    @Override
    @Nonnull
    public ChangeEntProjElmntPositionFluentHelper changeEntProjElmntPosition(
        @Nonnull final UUID projectElementUUID,
        @Nullable final UUID parentObjectUUID,
        @Nullable final UUID leftSiblingUUID )
    {
        return new ChangeEntProjElmntPositionFluentHelper(
            servicePath,
            projectElementUUID,
            parentObjectUUID,
            leftSiblingUUID);
    }

    @Override
    @Nonnull
    public
        ChangeEntProjElmntProcgStatusFluentHelper
        changeEntProjElmntProcgStatus( @Nonnull final UUID projectElementUUID, @Nullable final String processingStatus )
    {
        return new ChangeEntProjElmntProcgStatusFluentHelper(servicePath, projectElementUUID, processingStatus);
    }

    @Override
    @Nonnull
    public
        ChangeEntProjProcgStatusFluentHelper
        changeEntProjProcgStatus( @Nonnull final UUID projectUUID, @Nullable final String processingStatus )
    {
        return new ChangeEntProjProcgStatusFluentHelper(servicePath, projectUUID, processingStatus);
    }

}
