/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.DismantleEquipWithDataTransferFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.DismantleEquipmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.InstallEquipWithDataTransferFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.InstallEquipmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.ResetEquipmentFromInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.RsetEquipFromMarkedForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.SetEquipToMarkedForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.SetEquipmentToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.batch.DefaultEquipmentServiceBatch;

/**
 * <p>
 *
 * This service contains equipment, long text, partner function, warranty, class, characteristic, and characteristic
 * value nodes. The information is sent in the request as a payload.
 *
 * The request payload contains all information required to create or update an equipment. All the information in the
 * payload is used to create or update an equipment including appropriate checks for restricted values and
 * authorizations. Once the equipment has been created, the equipment number is sent in the response with the data
 * included in the equipment.
 *
 * If the input in the request is not as expected when you create or update an equipment, the system displays
 * appropriate error or warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/13/d40bd35fc74d289e81fc284a928448/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_EQUIPMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_EQUIPMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Asset Management Master Data Integration(SAP_COM_0395)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service
 * Management(49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation(4GA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Equipment</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultEquipmentService" )
@Deprecated
public class DefaultEquipmentService implements EquipmentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link EquipmentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultEquipmentService()
    {
        servicePath = EquipmentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultEquipmentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultEquipmentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultEquipmentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultEquipmentServiceBatch batch()
    {
        return new DefaultEquipmentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public EquipmentFluentHelper getAllEquipment()
    {
        return new EquipmentFluentHelper(servicePath, "Equipment");
    }

    @Override
    @Nonnull
    public EquipmentByKeyFluentHelper getEquipmentByKey( final String equipment, final LocalDateTime validityEndDate )
    {
        return new EquipmentByKeyFluentHelper(servicePath, "Equipment", equipment, validityEndDate);
    }

    @Override
    @Nonnull
    public EquipmentCreateFluentHelper createEquipment( @Nonnull final Equipment equipment )
    {
        return new EquipmentCreateFluentHelper(servicePath, equipment, "Equipment");
    }

    @Override
    @Nonnull
    public EquipmentUpdateFluentHelper updateEquipment( @Nonnull final Equipment equipment )
    {
        return new EquipmentUpdateFluentHelper(servicePath, equipment, "Equipment");
    }

    @Override
    @Nonnull
    public EquipClassCharacteristicValueFluentHelper getAllEquipClassCharacteristicValue()
    {
        return new EquipClassCharacteristicValueFluentHelper(servicePath, "EquipClassCharacteristicValue");
    }

    @Override
    @Nonnull
    public EquipClassCharacteristicValueByKeyFluentHelper getEquipClassCharacteristicValueByKey(
        final String equipment,
        final String classType,
        final String charcValuePositionNumber,
        final String characteristicInternalID )
    {
        return new EquipClassCharacteristicValueByKeyFluentHelper(
            servicePath,
            "EquipClassCharacteristicValue",
            equipment,
            classType,
            charcValuePositionNumber,
            characteristicInternalID);
    }

    @Override
    @Nonnull
    public EquipClassCharacteristicValueCreateFluentHelper createEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue )
    {
        return new EquipClassCharacteristicValueCreateFluentHelper(
            servicePath,
            equipClassCharacteristicValue,
            "EquipClassCharacteristicValue");
    }

    @Override
    @Nonnull
    public EquipClassCharacteristicValueUpdateFluentHelper updateEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue )
    {
        return new EquipClassCharacteristicValueUpdateFluentHelper(
            servicePath,
            equipClassCharacteristicValue,
            "EquipClassCharacteristicValue");
    }

    @Override
    @Nonnull
    public EquipmentClassFluentHelper getAllEquipmentClass()
    {
        return new EquipmentClassFluentHelper(servicePath, "EquipmentClass");
    }

    @Override
    @Nonnull
    public
        EquipmentClassByKeyFluentHelper
        getEquipmentClassByKey( final String equipment, final String classInternalID, final String classType )
    {
        return new EquipmentClassByKeyFluentHelper(
            servicePath,
            "EquipmentClass",
            equipment,
            classInternalID,
            classType);
    }

    @Override
    @Nonnull
    public EquipmentClassCreateFluentHelper createEquipmentClass( @Nonnull final EquipmentClass equipmentClass )
    {
        return new EquipmentClassCreateFluentHelper(servicePath, equipmentClass, "EquipmentClass");
    }

    @Override
    @Nonnull
    public EquipmentClassUpdateFluentHelper updateEquipmentClass( @Nonnull final EquipmentClass equipmentClass )
    {
        return new EquipmentClassUpdateFluentHelper(servicePath, equipmentClass, "EquipmentClass");
    }

    @Override
    @Nonnull
    public EquipmentClassDeleteFluentHelper deleteEquipmentClass( @Nonnull final EquipmentClass equipmentClass )
    {
        return new EquipmentClassDeleteFluentHelper(servicePath, equipmentClass, "EquipmentClass");
    }

    @Override
    @Nonnull
    public EquipmentClassCharacteristicFluentHelper getAllEquipmentClassCharacteristic()
    {
        return new EquipmentClassCharacteristicFluentHelper(servicePath, "EquipmentClassCharacteristic");
    }

    @Override
    @Nonnull
    public EquipmentClassCharacteristicByKeyFluentHelper getEquipmentClassCharacteristicByKey(
        final String equipment,
        final String classInternalID,
        final String characteristicInternalID )
    {
        return new EquipmentClassCharacteristicByKeyFluentHelper(
            servicePath,
            "EquipmentClassCharacteristic",
            equipment,
            classInternalID,
            characteristicInternalID);
    }

    @Override
    @Nonnull
    public EquipmentClassCharacteristicCreateFluentHelper createEquipmentClassCharacteristic(
        @Nonnull final EquipmentClassCharacteristic equipmentClassCharacteristic )
    {
        return new EquipmentClassCharacteristicCreateFluentHelper(
            servicePath,
            equipmentClassCharacteristic,
            "EquipmentClassCharacteristic");
    }

    @Override
    @Nonnull
    public EquipmentLongTextFluentHelper getAllEquipmentLongText()
    {
        return new EquipmentLongTextFluentHelper(servicePath, "EquipmentLongText");
    }

    @Override
    @Nonnull
    public EquipmentLongTextByKeyFluentHelper getEquipmentLongTextByKey( final String equipment )
    {
        return new EquipmentLongTextByKeyFluentHelper(servicePath, "EquipmentLongText", equipment);
    }

    @Override
    @Nonnull
    public EquipmentLongTextCreateFluentHelper createEquipmentLongText(
        @Nonnull final EquipmentLongText equipmentLongText )
    {
        return new EquipmentLongTextCreateFluentHelper(servicePath, equipmentLongText, "EquipmentLongText");
    }

    @Override
    @Nonnull
    public EquipmentLongTextUpdateFluentHelper updateEquipmentLongText(
        @Nonnull final EquipmentLongText equipmentLongText )
    {
        return new EquipmentLongTextUpdateFluentHelper(servicePath, equipmentLongText, "EquipmentLongText");
    }

    @Override
    @Nonnull
    public EquipmentPartnerFluentHelper getAllEquipmentPartner()
    {
        return new EquipmentPartnerFluentHelper(servicePath, "EquipmentPartner");
    }

    @Override
    @Nonnull
    public EquipmentPartnerByKeyFluentHelper getEquipmentPartnerByKey(
        final String equipment,
        final String partnerFunction,
        final String equipmentPartnerObjectNmbr )
    {
        return new EquipmentPartnerByKeyFluentHelper(
            servicePath,
            "EquipmentPartner",
            equipment,
            partnerFunction,
            equipmentPartnerObjectNmbr);
    }

    @Override
    @Nonnull
    public EquipmentPartnerCreateFluentHelper createEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner )
    {
        return new EquipmentPartnerCreateFluentHelper(servicePath, equipmentPartner, "EquipmentPartner");
    }

    @Override
    @Nonnull
    public EquipmentPartnerUpdateFluentHelper updateEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner )
    {
        return new EquipmentPartnerUpdateFluentHelper(servicePath, equipmentPartner, "EquipmentPartner");
    }

    @Override
    @Nonnull
    public EquipmentWarrantyFluentHelper getAllEquipmentWarranty()
    {
        return new EquipmentWarrantyFluentHelper(servicePath, "EquipmentWarranty");
    }

    @Override
    @Nonnull
    public
        EquipmentWarrantyByKeyFluentHelper
        getEquipmentWarrantyByKey( final String equipment, final String warrantyType )
    {
        return new EquipmentWarrantyByKeyFluentHelper(servicePath, "EquipmentWarranty", equipment, warrantyType);
    }

    @Override
    @Nonnull
    public EquipmentWarrantyCreateFluentHelper createEquipmentWarranty(
        @Nonnull final EquipmentWarranty equipmentWarranty )
    {
        return new EquipmentWarrantyCreateFluentHelper(servicePath, equipmentWarranty, "EquipmentWarranty");
    }

    @Override
    @Nonnull
    public EquipmentWarrantyUpdateFluentHelper updateEquipmentWarranty(
        @Nonnull final EquipmentWarranty equipmentWarranty )
    {
        return new EquipmentWarrantyUpdateFluentHelper(servicePath, equipmentWarranty, "EquipmentWarranty");
    }

    @Override
    @Nonnull
    public DismantleEquipmentFluentHelper dismantleEquipment(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final String functionalLocation,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime )
    {
        return new DismantleEquipmentFluentHelper(
            servicePath,
            equipment,
            validityEndDate,
            superordinateEquipment,
            equipInstallationPositionNmbr,
            functionalLocation,
            equipmentInstallationDate,
            equipmentInstallationTime);
    }

    @Override
    @Nonnull
    public DismantleEquipWithDataTransferFluentHelper dismantleEquipWithDataTransfer(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String functionalLocation,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime,
        @Nullable final Boolean locationCopyIsRequested,
        @Nullable final Boolean roomCopyIsRequested,
        @Nullable final Boolean plantSectionCopyIsRequested,
        @Nullable final Boolean workCenterCopyIsRequested,
        @Nullable final Boolean aBCIndicatorCopyIsRequested,
        @Nullable final Boolean sortFieldCopyIsRequested,
        @Nullable final Boolean businessAreaCopyIsRequested,
        @Nullable final Boolean costCenterCopyIsRequested,
        @Nullable final Boolean wBSElementCopyIsRequested,
        @Nullable final Boolean standingOrderCopyIsRequested,
        @Nullable final Boolean settlementOrderCopyIsRequested,
        @Nullable final Boolean maintPlanningPlantCopyIsReqd,
        @Nullable final Boolean maintWorkCenterCopyIsRequested,
        @Nullable final Boolean catalogProfileCopyIsRequested,
        @Nullable final Boolean salesOrganizationCopyIsReqd )
    {
        return new DismantleEquipWithDataTransferFluentHelper(
            servicePath,
            equipment,
            validityEndDate,
            superordinateEquipment,
            functionalLocation,
            equipInstallationPositionNmbr,
            equipmentInstallationDate,
            equipmentInstallationTime,
            locationCopyIsRequested,
            roomCopyIsRequested,
            plantSectionCopyIsRequested,
            workCenterCopyIsRequested,
            aBCIndicatorCopyIsRequested,
            sortFieldCopyIsRequested,
            businessAreaCopyIsRequested,
            costCenterCopyIsRequested,
            wBSElementCopyIsRequested,
            standingOrderCopyIsRequested,
            settlementOrderCopyIsRequested,
            maintPlanningPlantCopyIsReqd,
            maintWorkCenterCopyIsRequested,
            catalogProfileCopyIsRequested,
            salesOrganizationCopyIsReqd);
    }

    @Override
    @Nonnull
    public InstallEquipmentFluentHelper installEquipment(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final String functionalLocation,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime )
    {
        return new InstallEquipmentFluentHelper(
            servicePath,
            equipment,
            validityEndDate,
            superordinateEquipment,
            equipInstallationPositionNmbr,
            functionalLocation,
            equipmentInstallationDate,
            equipmentInstallationTime);
    }

    @Override
    @Nonnull
    public InstallEquipWithDataTransferFluentHelper installEquipWithDataTransfer(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String functionalLocation,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime,
        @Nullable final Boolean locationCopyIsRequested,
        @Nullable final Boolean roomCopyIsRequested,
        @Nullable final Boolean plantSectionCopyIsRequested,
        @Nullable final Boolean workCenterCopyIsRequested,
        @Nullable final Boolean aBCIndicatorCopyIsRequested,
        @Nullable final Boolean sortFieldCopyIsRequested,
        @Nullable final Boolean businessAreaCopyIsRequested,
        @Nullable final Boolean costCenterCopyIsRequested,
        @Nullable final Boolean wBSElementCopyIsRequested,
        @Nullable final Boolean standingOrderCopyIsRequested,
        @Nullable final Boolean settlementOrderCopyIsRequested,
        @Nullable final Boolean maintPlanningPlantCopyIsReqd,
        @Nullable final Boolean maintWorkCenterCopyIsRequested,
        @Nullable final Boolean catalogProfileCopyIsRequested,
        @Nullable final Boolean salesOrganizationCopyIsReqd )
    {
        return new InstallEquipWithDataTransferFluentHelper(
            servicePath,
            equipment,
            validityEndDate,
            superordinateEquipment,
            functionalLocation,
            equipInstallationPositionNmbr,
            equipmentInstallationDate,
            equipmentInstallationTime,
            locationCopyIsRequested,
            roomCopyIsRequested,
            plantSectionCopyIsRequested,
            workCenterCopyIsRequested,
            aBCIndicatorCopyIsRequested,
            sortFieldCopyIsRequested,
            businessAreaCopyIsRequested,
            costCenterCopyIsRequested,
            wBSElementCopyIsRequested,
            standingOrderCopyIsRequested,
            settlementOrderCopyIsRequested,
            maintPlanningPlantCopyIsReqd,
            maintWorkCenterCopyIsRequested,
            catalogProfileCopyIsRequested,
            salesOrganizationCopyIsReqd);
    }

    @Override
    @Nonnull
    public
        ResetEquipmentFromInactiveFluentHelper
        resetEquipmentFromInactive( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate )
    {
        return new ResetEquipmentFromInactiveFluentHelper(servicePath, equipment, validityEndDate);
    }

    @Override
    @Nonnull
    public
        RsetEquipFromMarkedForDeletionFluentHelper
        rsetEquipFromMarkedForDeletion( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate )
    {
        return new RsetEquipFromMarkedForDeletionFluentHelper(servicePath, equipment, validityEndDate);
    }

    @Override
    @Nonnull
    public
        SetEquipmentToInactiveFluentHelper
        setEquipmentToInactive( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate )
    {
        return new SetEquipmentToInactiveFluentHelper(servicePath, equipment, validityEndDate);
    }

    @Override
    @Nonnull
    public
        SetEquipToMarkedForDeletionFluentHelper
        setEquipToMarkedForDeletion( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate )
    {
        return new SetEquipToMarkedForDeletionFluentHelper(servicePath, equipment, validityEndDate);
    }

}
