/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.CallActionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.ChangeRecognitionKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.batch.DefaultEventBasedRevenueRecognitionIntegrationServiceBatch;

/**
 * <p>
 *
 * The service first allows for a clearing of the balance sheet GL accounts, a procedure by which the open items
 * belonging to one or more accounts are indicated as cleared. Second, it allows for using the revalue function, which
 * recalculates the posted revenue recognition values if you have changed, for example, the planned cost. This service
 * also allows changing the revenue recognition key that was originally assigned to a particular WBS element (project)
 * to a new one..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/14/07737644024c36a45388ffe4f593a4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_EVENT_BASED_REVREC_PROJECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_EVENT_BASED_REVREC_PROJECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Event-Based Revenue Recognition Integration(SAP_COM_0312)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1IL'>Event-Based Revenue Recognition - Project-Based
 * Services(1IL)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1P0'>Event-Based Revenue Recognition -
 * Project-Based Services - IFRS(1P0)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/33O'>Event-Based Revenue
 * Recognition - Project-Based Services - US GAAP(33O)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Enterprise Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultEventBasedRevenueRecognitionIntegrationService" )
@Deprecated
public class DefaultEventBasedRevenueRecognitionIntegrationService
    implements
    EventBasedRevenueRecognitionIntegrationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link EventBasedRevenueRecognitionIntegrationService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultEventBasedRevenueRecognitionIntegrationService()
    {
        servicePath = EventBasedRevenueRecognitionIntegrationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultEventBasedRevenueRecognitionIntegrationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultEventBasedRevenueRecognitionIntegrationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultEventBasedRevenueRecognitionIntegrationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultEventBasedRevenueRecognitionIntegrationServiceBatch batch()
    {
        return new DefaultEventBasedRevenueRecognitionIntegrationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CallActionFluentHelper callAction(
        @Nonnull final Short year,
        @Nonnull final Short period,
        @Nonnull final String actionName,
        @Nonnull final String wBSElementExternalID )
    {
        return new CallActionFluentHelper(servicePath, year, period, actionName, wBSElementExternalID);
    }

    @Override
    @Nonnull
    public
        ChangeRecognitionKeyFluentHelper
        changeRecognitionKey( @Nonnull final String wBSElementExternalID, @Nonnull final String recognitionKey )
    {
        return new ChangeRecognitionKeyFluentHelper(servicePath, wBSElementExternalID, recognitionKey);
    }

}
