/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.batch.DefaultExtendedPlannedIndependentRequirementServiceBatch;

/**
 * <p>
 *
 * The PIRs are read, updated and/or created on header and item level. You can also send batch requests.
 *
 * Use this API, if you want to work with the Change PIR or Maintain PIR app. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c8/1d1718b16147b5811acce3f1888054/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PLND_INDEP_RQMT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PLND_INDEP_RQMT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Planned Independent Requirement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultExtendedPlannedIndependentRequirementService" )
@Deprecated
public class DefaultExtendedPlannedIndependentRequirementService implements ExtendedPlannedIndependentRequirementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ExtendedPlannedIndependentRequirementService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultExtendedPlannedIndependentRequirementService()
    {
        servicePath = ExtendedPlannedIndependentRequirementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultExtendedPlannedIndependentRequirementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultExtendedPlannedIndependentRequirementService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultExtendedPlannedIndependentRequirementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultExtendedPlannedIndependentRequirementServiceBatch batch()
    {
        return new DefaultExtendedPlannedIndependentRequirementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtFluentHelper getAllPlannedIndepRqmt()
    {
        return new PlannedIndepRqmtFluentHelper(servicePath, "PlannedIndepRqmt");
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtByKeyFluentHelper getPlannedIndepRqmtByKey(
        final String product,
        final String plant,
        final String mRPArea,
        final String plndIndepRqmtType,
        final String plndIndepRqmtVersion,
        final String requirementPlan,
        final String requirementSegment )
    {
        return new PlannedIndepRqmtByKeyFluentHelper(
            servicePath,
            "PlannedIndepRqmt",
            product,
            plant,
            mRPArea,
            plndIndepRqmtType,
            plndIndepRqmtVersion,
            requirementPlan,
            requirementSegment);
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtCreateFluentHelper createPlannedIndepRqmt( @Nonnull final PlannedIndepRqmt plannedIndepRqmt )
    {
        return new PlannedIndepRqmtCreateFluentHelper(servicePath, plannedIndepRqmt, "PlannedIndepRqmt");
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtUpdateFluentHelper updatePlannedIndepRqmt( @Nonnull final PlannedIndepRqmt plannedIndepRqmt )
    {
        return new PlannedIndepRqmtUpdateFluentHelper(servicePath, plannedIndepRqmt, "PlannedIndepRqmt");
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtItemFluentHelper getAllPlannedIndepRqmtItem()
    {
        return new PlannedIndepRqmtItemFluentHelper(servicePath, "PlannedIndepRqmtItem");
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtItemByKeyFluentHelper getPlannedIndepRqmtItemByKey(
        final String product,
        final String plant,
        final String mRPArea,
        final String plndIndepRqmtType,
        final String plndIndepRqmtVersion,
        final String requirementPlan,
        final String requirementSegment,
        final String plndIndepRqmtPeriod,
        final String periodType )
    {
        return new PlannedIndepRqmtItemByKeyFluentHelper(
            servicePath,
            "PlannedIndepRqmtItem",
            product,
            plant,
            mRPArea,
            plndIndepRqmtType,
            plndIndepRqmtVersion,
            requirementPlan,
            requirementSegment,
            plndIndepRqmtPeriod,
            periodType);
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtItemCreateFluentHelper createPlannedIndepRqmtItem(
        @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem )
    {
        return new PlannedIndepRqmtItemCreateFluentHelper(servicePath, plannedIndepRqmtItem, "PlannedIndepRqmtItem");
    }

    @Override
    @Nonnull
    public PlannedIndepRqmtItemUpdateFluentHelper updatePlannedIndepRqmtItem(
        @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem )
    {
        return new PlannedIndepRqmtItemUpdateFluentHelper(servicePath, plannedIndepRqmtItem, "PlannedIndepRqmtItem");
    }

}
