/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobAbortFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobCancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobStatusGetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.batch.DefaultExternalJobSchedulerIntegrationServiceBatch;

/**
 * <p>
 * This service enables you to schedule application jobs for a specified business user, to read the status and other
 * data of an application job, and to cancel an application job.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/aa/dfe07526c547c784c2258a9d145e6f/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/BC_EXT_APPJOB_MANAGEMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>BC_EXT_APPJOB_MANAGEMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>External Scheduler Integration (SAP_COM_0064)</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultExternalJobSchedulerIntegrationService" )
@Deprecated
public class DefaultExternalJobSchedulerIntegrationService implements ExternalJobSchedulerIntegrationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ExternalJobSchedulerIntegrationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultExternalJobSchedulerIntegrationService()
    {
        servicePath = ExternalJobSchedulerIntegrationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultExternalJobSchedulerIntegrationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultExternalJobSchedulerIntegrationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultExternalJobSchedulerIntegrationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultExternalJobSchedulerIntegrationServiceBatch batch()
    {
        return new DefaultExternalJobSchedulerIntegrationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public JobTemplateFluentHelper getAllJobTemplate()
    {
        return new JobTemplateFluentHelper(servicePath, "JobTemplateSet");
    }

    @Override
    @Nonnull
    public
        JobTemplateByKeyFluentHelper
        getJobTemplateByKey( final String jobTemplateName, final String jobTemplateVersion )
    {
        return new JobTemplateByKeyFluentHelper(servicePath, "JobTemplateSet", jobTemplateName, jobTemplateVersion);
    }

    @Override
    @Nonnull
    public JobScheduleFluentHelper jobSchedule(
        @Nullable final String jobUserID,
        @Nullable final String jobUserName,
        @Nonnull final String jobText,
        @Nonnull final String jobTemplateName,
        @Nullable final String jobParameterValues,
        @Nullable final Boolean testModeInd,
        @Nullable final String jobUser )
    {
        return new JobScheduleFluentHelper(
            servicePath,
            jobUserID,
            jobUserName,
            jobText,
            jobTemplateName,
            jobParameterValues,
            testModeInd,
            jobUser);
    }

    @Override
    @Nonnull
    public JobCancelFluentHelper jobCancel( @Nonnull final String jobRunCount, @Nonnull final String jobName )
    {
        return new JobCancelFluentHelper(servicePath, jobRunCount, jobName);
    }

    @Override
    @Nonnull
    public JobAbortFluentHelper jobAbort( @Nonnull final String jobRunCount, @Nonnull final String jobName )
    {
        return new JobAbortFluentHelper(servicePath, jobRunCount, jobName);
    }

    @Override
    @Nonnull
    public JobStatusGetFluentHelper jobStatusGet( @Nonnull final String jobName, @Nonnull final String jobRunCount )
    {
        return new JobStatusGetFluentHelper(servicePath, jobName, jobRunCount);
    }

}
