/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanDataCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.batch.DefaultFinancialPlanningDataServiceBatch;

/**
 * <p>
 *
 * The service exports financial plan data between systems. This API call is based on the OData protocol, and can be
 * consumed in Fiori apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d5/d7064aaedb4028aad85cab986053e7/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FINPLANNINGDATA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FINPLANNINGDATA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>FinancialPlanningEntryItem</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultFinancialPlanningDataService" )
@Deprecated
public class DefaultFinancialPlanningDataService implements FinancialPlanningDataService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link FinancialPlanningDataService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultFinancialPlanningDataService()
    {
        servicePath = FinancialPlanningDataService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultFinancialPlanningDataService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultFinancialPlanningDataService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultFinancialPlanningDataService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultFinancialPlanningDataServiceBatch batch()
    {
        return new DefaultFinancialPlanningDataServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public FinancialPlanDataByKeyFluentHelper getFinancialPlanDataByKey( final String planDataAggrgnLvlFieldsString )
    {
        return new FinancialPlanDataByKeyFluentHelper(servicePath, "FinancialPlanData", planDataAggrgnLvlFieldsString);
    }

    @Override
    @Nonnull
    public FinancialPlanDataCreateFluentHelper createFinancialPlanData(
        @Nonnull final FinancialPlanData financialPlanData )
    {
        return new FinancialPlanDataCreateFluentHelper(servicePath, financialPlanData, "FinancialPlanData");
    }

}
