/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFixByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFixFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.batch.DefaultFinancialPlanningEntryItemServiceBatch;

/**
 * <p>
 *
 * The service contains financial planning entry items and master data of the referenced company code, cost center,
 * profit center. This API call is based on the OData protocol, and can be consumed in Fiori apps and on other user
 * interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/29/698caa770b4d29b30e6e84f033edd8/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FINPLANNINGENTRYITEM_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FINPLANNINGENTRYITEM_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>FinancialPlanningEntryItem</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultFinancialPlanningEntryItemService" )
@Deprecated
public class DefaultFinancialPlanningEntryItemService implements FinancialPlanningEntryItemService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link FinancialPlanningEntryItemService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultFinancialPlanningEntryItemService()
    {
        servicePath = FinancialPlanningEntryItemService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultFinancialPlanningEntryItemService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultFinancialPlanningEntryItemService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultFinancialPlanningEntryItemService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultFinancialPlanningEntryItemServiceBatch batch()
    {
        return new DefaultFinancialPlanningEntryItemServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CompanyCodeFluentHelper getAllCompanyCode()
    {
        return new CompanyCodeFluentHelper(servicePath, "A_CompanyCode");
    }

    @Override
    @Nonnull
    public CompanyCodeByKeyFluentHelper getCompanyCodeByKey( final String companyCode )
    {
        return new CompanyCodeByKeyFluentHelper(servicePath, "A_CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    public CostCenterFluentHelper getAllCostCenter()
    {
        return new CostCenterFluentHelper(servicePath, "A_CostCenter");
    }

    @Override
    @Nonnull
    public
        CostCenterByKeyFluentHelper
        getCostCenterByKey( final String controllingArea, final String costCenter, final LocalDateTime validityEndDate )
    {
        return new CostCenterByKeyFluentHelper(
            servicePath,
            "A_CostCenter",
            controllingArea,
            costCenter,
            validityEndDate);
    }

    @Override
    @Nonnull
    public FinPlanEntryItemVariableFixFluentHelper getAllFinPlanEntryItemVariableFix()
    {
        return new FinPlanEntryItemVariableFixFluentHelper(servicePath, "A_FinPlanEntryItemVariableFix");
    }

    @Override
    @Nonnull
    public FinPlanEntryItemVariableFixByKeyFluentHelper getFinPlanEntryItemVariableFixByKey( final String iD )
    {
        return new FinPlanEntryItemVariableFixByKeyFluentHelper(servicePath, "A_FinPlanEntryItemVariableFix", iD);
    }

    @Override
    @Nonnull
    public FinPlanningEntryItemFluentHelper getAllFinPlanningEntryItem()
    {
        return new FinPlanningEntryItemFluentHelper(servicePath, "A_FinPlanningEntryItem");
    }

    @Override
    @Nonnull
    public FinPlanningEntryItemByKeyFluentHelper getFinPlanningEntryItemByKey( final String iD )
    {
        return new FinPlanningEntryItemByKeyFluentHelper(servicePath, "A_FinPlanningEntryItem", iD);
    }

    @Override
    @Nonnull
    public GLAccountInChartOfAccountsFluentHelper getAllGLAccountInChartOfAccounts()
    {
        return new GLAccountInChartOfAccountsFluentHelper(servicePath, "A_GLAccountInChartOfAccounts");
    }

    @Override
    @Nonnull
    public
        GLAccountInChartOfAccountsByKeyFluentHelper
        getGLAccountInChartOfAccountsByKey( final String chartOfAccounts, final String gLAccount )
    {
        return new GLAccountInChartOfAccountsByKeyFluentHelper(
            servicePath,
            "A_GLAccountInChartOfAccounts",
            chartOfAccounts,
            gLAccount);
    }

    @Override
    @Nonnull
    public ProfitCenterFluentHelper getAllProfitCenter()
    {
        return new ProfitCenterFluentHelper(servicePath, "A_ProfitCenter");
    }

    @Override
    @Nonnull
    public ProfitCenterByKeyFluentHelper getProfitCenterByKey(
        final String controllingArea,
        final String profitCenter,
        final LocalDateTime validityEndDate )
    {
        return new ProfitCenterByKeyFluentHelper(
            servicePath,
            "A_ProfitCenter",
            controllingArea,
            profitCenter,
            validityEndDate);
    }

}
