/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.batch.DefaultFunctionalAreaServiceBatch;

/**
 * <p>
 * The service contains functional area and functional area text nodes.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/9d/779144409d43f4b41a6bbcceac86fb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FUNCTIONALAREA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FUNCTIONALAREA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Functional Area</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultFunctionalAreaService" )
@Deprecated
public class DefaultFunctionalAreaService implements FunctionalAreaService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link FunctionalAreaService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultFunctionalAreaService()
    {
        servicePath = FunctionalAreaService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultFunctionalAreaService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultFunctionalAreaService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultFunctionalAreaService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultFunctionalAreaServiceBatch batch()
    {
        return new DefaultFunctionalAreaServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public FunctionalAreaFluentHelper getAllFunctionalArea()
    {
        return new FunctionalAreaFluentHelper(servicePath, "A_FunctionalArea");
    }

    @Override
    @Nonnull
    public FunctionalAreaByKeyFluentHelper getFunctionalAreaByKey( final String functionalArea )
    {
        return new FunctionalAreaByKeyFluentHelper(servicePath, "A_FunctionalArea", functionalArea);
    }

    @Override
    @Nonnull
    public FunctionalAreaTextFluentHelper getAllFunctionalAreaText()
    {
        return new FunctionalAreaTextFluentHelper(servicePath, "A_FunctionalAreaText");
    }

    @Override
    @Nonnull
    public
        FunctionalAreaTextByKeyFluentHelper
        getFunctionalAreaTextByKey( final String language, final String functionalArea )
    {
        return new FunctionalAreaTextByKeyFluentHelper(servicePath, "A_FunctionalAreaText", language, functionalArea);
    }

}
