/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.DismantleFunctionalLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.InstallFunctionalLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.RsetFuncLocFromMrkdForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.RsetFuncnlLocationFromInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.SetFuncLocToMarkedForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.SetFuncnlLocationToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.batch.DefaultFunctionalLocationServiceBatch;

/**
 * <p>
 *
 * This service contains functional location, long text, partner function, warranty, class, characteristic, and
 * characteristic value nodes. The information is sent in the request as a payload.
 *
 * The request payload contains all information required to create or update functional location. All the information in
 * the payload is used to create or update functional location including appropriate checks for restricted values and
 * authorizations. Once the functional location has been created, the functional location label is sent in the response
 * with the data included in the functional location.
 *
 * If the input in the request is not as expected when you create or update a functional location, the system displays
 * appropriate error or warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b6/a1e644059f4d53b11201b9c0aaefd7/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FUNCTIONALLOCATION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FUNCTIONALLOCATION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Asset Management Master Data Integration(SAP_COM_0395)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service
 * Management(49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation(4GA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Functional Location</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultFunctionalLocationService" )
@Deprecated
public class DefaultFunctionalLocationService implements FunctionalLocationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link FunctionalLocationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultFunctionalLocationService()
    {
        servicePath = FunctionalLocationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultFunctionalLocationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultFunctionalLocationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultFunctionalLocationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultFunctionalLocationServiceBatch batch()
    {
        return new DefaultFunctionalLocationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ValueFluentHelper getAllValue()
    {
        return new ValueFluentHelper(servicePath, "Value");
    }

    @Override
    @Nonnull
    public ValueByKeyFluentHelper getValueByKey(
        final String functionalLocation,
        final String classType,
        final String charcValuePositionNumber,
        final String charcInternalID )
    {
        return new ValueByKeyFluentHelper(
            servicePath,
            "Value",
            functionalLocation,
            classType,
            charcValuePositionNumber,
            charcInternalID);
    }

    @Override
    @Nonnull
    public ValueCreateFluentHelper createValue( @Nonnull final Value value )
    {
        return new ValueCreateFluentHelper(servicePath, value, "Value");
    }

    @Override
    @Nonnull
    public ValueUpdateFluentHelper updateValue( @Nonnull final Value value )
    {
        return new ValueUpdateFluentHelper(servicePath, value, "Value");
    }

    @Override
    @Nonnull
    public FunctionalLocationClassFluentHelper getAllFunctionalLocationClass()
    {
        return new FunctionalLocationClassFluentHelper(servicePath, "FunctionalLocationClass");
    }

    @Override
    @Nonnull
    public FunctionalLocationClassByKeyFluentHelper getFunctionalLocationClassByKey(
        final String functionalLocation,
        final String classInternalID,
        final String classType )
    {
        return new FunctionalLocationClassByKeyFluentHelper(
            servicePath,
            "FunctionalLocationClass",
            functionalLocation,
            classInternalID,
            classType);
    }

    @Override
    @Nonnull
    public FunctionalLocationClassCreateFluentHelper createFunctionalLocationClass(
        @Nonnull final FunctionalLocationClass functionalLocationClass )
    {
        return new FunctionalLocationClassCreateFluentHelper(
            servicePath,
            functionalLocationClass,
            "FunctionalLocationClass");
    }

    @Override
    @Nonnull
    public FunctionalLocationClassUpdateFluentHelper updateFunctionalLocationClass(
        @Nonnull final FunctionalLocationClass functionalLocationClass )
    {
        return new FunctionalLocationClassUpdateFluentHelper(
            servicePath,
            functionalLocationClass,
            "FunctionalLocationClass");
    }

    @Override
    @Nonnull
    public FunctionalLocationClassDeleteFluentHelper deleteFunctionalLocationClass(
        @Nonnull final FunctionalLocationClass functionalLocationClass )
    {
        return new FunctionalLocationClassDeleteFluentHelper(
            servicePath,
            functionalLocationClass,
            "FunctionalLocationClass");
    }

    @Override
    @Nonnull
    public CharacteristicFluentHelper getAllCharacteristic()
    {
        return new CharacteristicFluentHelper(servicePath, "Characteristic");
    }

    @Override
    @Nonnull
    public CharacteristicByKeyFluentHelper getCharacteristicByKey(
        final String functionalLocation,
        final String classInternalID,
        final String charcInternalID )
    {
        return new CharacteristicByKeyFluentHelper(
            servicePath,
            "Characteristic",
            functionalLocation,
            classInternalID,
            charcInternalID);
    }

    @Override
    @Nonnull
    public CharacteristicCreateFluentHelper createCharacteristic( @Nonnull final Characteristic characteristic )
    {
        return new CharacteristicCreateFluentHelper(servicePath, characteristic, "Characteristic");
    }

    @Override
    @Nonnull
    public FunctionalLocationWarrantyFluentHelper getAllFunctionalLocationWarranty()
    {
        return new FunctionalLocationWarrantyFluentHelper(servicePath, "FunctionalLocationWarranty");
    }

    @Override
    @Nonnull
    public
        FunctionalLocationWarrantyByKeyFluentHelper
        getFunctionalLocationWarrantyByKey( final String functionalLocation, final String warrantyType )
    {
        return new FunctionalLocationWarrantyByKeyFluentHelper(
            servicePath,
            "FunctionalLocationWarranty",
            functionalLocation,
            warrantyType);
    }

    @Override
    @Nonnull
    public FunctionalLocationWarrantyCreateFluentHelper createFunctionalLocationWarranty(
        @Nonnull final FunctionalLocationWarranty functionalLocationWarranty )
    {
        return new FunctionalLocationWarrantyCreateFluentHelper(
            servicePath,
            functionalLocationWarranty,
            "FunctionalLocationWarranty");
    }

    @Override
    @Nonnull
    public FunctionalLocationWarrantyUpdateFluentHelper updateFunctionalLocationWarranty(
        @Nonnull final FunctionalLocationWarranty functionalLocationWarranty )
    {
        return new FunctionalLocationWarrantyUpdateFluentHelper(
            servicePath,
            functionalLocationWarranty,
            "FunctionalLocationWarranty");
    }

    @Override
    @Nonnull
    public FunctionalLocationFluentHelper getAllFunctionalLocation()
    {
        return new FunctionalLocationFluentHelper(servicePath, "FunctionalLocation");
    }

    @Override
    @Nonnull
    public FunctionalLocationByKeyFluentHelper getFunctionalLocationByKey( final String functionalLocation )
    {
        return new FunctionalLocationByKeyFluentHelper(servicePath, "FunctionalLocation", functionalLocation);
    }

    @Override
    @Nonnull
    public FunctionalLocationCreateFluentHelper createFunctionalLocation(
        @Nonnull final FunctionalLocation functionalLocation )
    {
        return new FunctionalLocationCreateFluentHelper(servicePath, functionalLocation, "FunctionalLocation");
    }

    @Override
    @Nonnull
    public FunctionalLocationUpdateFluentHelper updateFunctionalLocation(
        @Nonnull final FunctionalLocation functionalLocation )
    {
        return new FunctionalLocationUpdateFluentHelper(servicePath, functionalLocation, "FunctionalLocation");
    }

    @Override
    @Nonnull
    public FunctionalLocationLongTextFluentHelper getAllFunctionalLocationLongText()
    {
        return new FunctionalLocationLongTextFluentHelper(servicePath, "FunctionalLocationLongText");
    }

    @Override
    @Nonnull
    public FunctionalLocationLongTextByKeyFluentHelper getFunctionalLocationLongTextByKey(
        final String functionalLocation )
    {
        return new FunctionalLocationLongTextByKeyFluentHelper(
            servicePath,
            "FunctionalLocationLongText",
            functionalLocation);
    }

    @Override
    @Nonnull
    public FunctionalLocationLongTextCreateFluentHelper createFunctionalLocationLongText(
        @Nonnull final FunctionalLocationLongText functionalLocationLongText )
    {
        return new FunctionalLocationLongTextCreateFluentHelper(
            servicePath,
            functionalLocationLongText,
            "FunctionalLocationLongText");
    }

    @Override
    @Nonnull
    public FunctionalLocationLongTextUpdateFluentHelper updateFunctionalLocationLongText(
        @Nonnull final FunctionalLocationLongText functionalLocationLongText )
    {
        return new FunctionalLocationLongTextUpdateFluentHelper(
            servicePath,
            functionalLocationLongText,
            "FunctionalLocationLongText");
    }

    @Override
    @Nonnull
    public FunctionalLocationPartnerFluentHelper getAllFunctionalLocationPartner()
    {
        return new FunctionalLocationPartnerFluentHelper(servicePath, "FunctionalLocationPartner");
    }

    @Override
    @Nonnull
    public FunctionalLocationPartnerByKeyFluentHelper getFunctionalLocationPartnerByKey(
        final String functionalLocation,
        final String partnerFunction,
        final String funcnlLocPartnerObjectNmbr )
    {
        return new FunctionalLocationPartnerByKeyFluentHelper(
            servicePath,
            "FunctionalLocationPartner",
            functionalLocation,
            partnerFunction,
            funcnlLocPartnerObjectNmbr);
    }

    @Override
    @Nonnull
    public FunctionalLocationPartnerCreateFluentHelper createFunctionalLocationPartner(
        @Nonnull final FunctionalLocationPartner functionalLocationPartner )
    {
        return new FunctionalLocationPartnerCreateFluentHelper(
            servicePath,
            functionalLocationPartner,
            "FunctionalLocationPartner");
    }

    @Override
    @Nonnull
    public FunctionalLocationPartnerUpdateFluentHelper updateFunctionalLocationPartner(
        @Nonnull final FunctionalLocationPartner functionalLocationPartner )
    {
        return new FunctionalLocationPartnerUpdateFluentHelper(
            servicePath,
            functionalLocationPartner,
            "FunctionalLocationPartner");
    }

    @Override
    @Nonnull
    public DismantleFunctionalLocationFluentHelper dismantleFunctionalLocation(
        @Nonnull final String functionalLocation,
        @Nullable final LocalDateTime funcLocDismantleDate,
        @Nullable final LocalTime funcLocDismantleTime )
    {
        return new DismantleFunctionalLocationFluentHelper(
            servicePath,
            functionalLocation,
            funcLocDismantleDate,
            funcLocDismantleTime);
    }

    @Override
    @Nonnull
    public InstallFunctionalLocationFluentHelper installFunctionalLocation(
        @Nonnull final String functionalLocation,
        @Nullable final String superiorFunctionalLocation,
        @Nullable final String funcLocInstallationPosNmbr,
        @Nullable final LocalDateTime funcLocInstallationDate,
        @Nullable final LocalTime funcLocInstallationTime )
    {
        return new InstallFunctionalLocationFluentHelper(
            servicePath,
            functionalLocation,
            superiorFunctionalLocation,
            funcLocInstallationPosNmbr,
            funcLocInstallationDate,
            funcLocInstallationTime);
    }

    @Override
    @Nonnull
    public RsetFuncLocFromMrkdForDeletionFluentHelper rsetFuncLocFromMrkdForDeletion(
        @Nonnull final String functionalLocation )
    {
        return new RsetFuncLocFromMrkdForDeletionFluentHelper(servicePath, functionalLocation);
    }

    @Override
    @Nonnull
    public RsetFuncnlLocationFromInactiveFluentHelper rsetFuncnlLocationFromInactive(
        @Nonnull final String functionalLocation )
    {
        return new RsetFuncnlLocationFromInactiveFluentHelper(servicePath, functionalLocation);
    }

    @Override
    @Nonnull
    public SetFuncLocToMarkedForDeletionFluentHelper setFuncLocToMarkedForDeletion(
        @Nonnull final String functionalLocation )
    {
        return new SetFuncLocToMarkedForDeletionFluentHelper(servicePath, functionalLocation);
    }

    @Override
    @Nonnull
    public SetFuncnlLocationToInactiveFluentHelper setFuncnlLocationToInactive(
        @Nonnull final String functionalLocation )
    {
        return new SetFuncnlLocationToInactiveFluentHelper(servicePath, functionalLocation);
    }

}
