/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.batch.DefaultFundHierarchyServiceBatch;

/**
 * <p>
 * This service enables you to read the fund hierarchy master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/42/147704838d4a669cb887fcb2ef42f2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FUNDCOREHIERARCHY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FUNDCOREHIERARCHY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Fund</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultFundHierarchyService" )
@Deprecated
public class DefaultFundHierarchyService implements FundHierarchyService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link FundHierarchyService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultFundHierarchyService()
    {
        servicePath = FundHierarchyService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultFundHierarchyService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultFundHierarchyService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultFundHierarchyService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultFundHierarchyServiceBatch batch()
    {
        return new DefaultFundHierarchyServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public FundCoreHierarchyFluentHelper getAllFundCoreHierarchy()
    {
        return new FundCoreHierarchyFluentHelper(servicePath, "FundHierarchy");
    }

    @Override
    @Nonnull
    public
        FundCoreHierarchyByKeyFluentHelper
        getFundCoreHierarchyByKey( final String fundHierarchy, final LocalDateTime validityEndDate )
    {
        return new FundCoreHierarchyByKeyFluentHelper(servicePath, "FundHierarchy", fundHierarchy, validityEndDate);
    }

    @Override
    @Nonnull
    public FundCoreHierarchyNodeTextFluentHelper getAllFundCoreHierarchyNodeText()
    {
        return new FundCoreHierarchyNodeTextFluentHelper(servicePath, "FundHierarchyNodeText");
    }

    @Override
    @Nonnull
    public FundCoreHierarchyNodeTextByKeyFluentHelper getFundCoreHierarchyNodeTextByKey(
        final String fundHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new FundCoreHierarchyNodeTextByKeyFluentHelper(
            servicePath,
            "FundHierarchyNodeText",
            fundHierarchy,
            hierarchyNode,
            validityEndDate,
            language);
    }

    @Override
    @Nonnull
    public FundCoreHierarchyTextFluentHelper getAllFundCoreHierarchyText()
    {
        return new FundCoreHierarchyTextFluentHelper(servicePath, "FundHierarchyText");
    }

    @Override
    @Nonnull
    public FundCoreHierarchyTextByKeyFluentHelper getFundCoreHierarchyTextByKey(
        final String fundHierarchy,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new FundCoreHierarchyTextByKeyFluentHelper(
            servicePath,
            "FundHierarchyText",
            fundHierarchy,
            validityEndDate,
            language);
    }

    @Override
    @Nonnull
    public FundCoreHierNodeFluentHelper getAllFundCoreHierNode()
    {
        return new FundCoreHierNodeFluentHelper(servicePath, "FundHierarchyNode");
    }

    @Override
    @Nonnull
    public FundCoreHierNodeByKeyFluentHelper getFundCoreHierNodeByKey(
        final String fundHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        return new FundCoreHierNodeByKeyFluentHelper(
            servicePath,
            "FundHierarchyNode",
            fundHierarchy,
            hierarchyNode,
            validityEndDate);
    }

}
