/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.batch.DefaultFundServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the fund master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/5f/7fbc217157425b977c151a0731cb3f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FUNDCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FUNDCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Fund</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultFundService" )
@Deprecated
public class DefaultFundService implements FundService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link FundService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultFundService()
    {
        servicePath = FundService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultFundService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultFundService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultFundService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultFundServiceBatch batch()
    {
        return new DefaultFundServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public FundCoreFluentHelper getAllFundCore()
    {
        return new FundCoreFluentHelper(servicePath, "Fund");
    }

    @Override
    @Nonnull
    public FundCoreByKeyFluentHelper getFundCoreByKey( final String financialManagementArea, final String fund )
    {
        return new FundCoreByKeyFluentHelper(servicePath, "Fund", financialManagementArea, fund);
    }

    @Override
    @Nonnull
    public FundCoreCreateFluentHelper createFundCore( @Nonnull final FundCore fundCore )
    {
        return new FundCoreCreateFluentHelper(servicePath, fundCore, "Fund");
    }

    @Override
    @Nonnull
    public FundCoreUpdateFluentHelper updateFundCore( @Nonnull final FundCore fundCore )
    {
        return new FundCoreUpdateFluentHelper(servicePath, fundCore, "Fund");
    }

    @Override
    @Nonnull
    public FundCoreDeleteFluentHelper deleteFundCore( @Nonnull final FundCore fundCore )
    {
        return new FundCoreDeleteFluentHelper(servicePath, fundCore, "Fund");
    }

    @Override
    @Nonnull
    public FundTextFluentHelper getAllFundText()
    {
        return new FundTextFluentHelper(servicePath, "FundText");
    }

    @Override
    @Nonnull
    public
        FundTextByKeyFluentHelper
        getFundTextByKey( final String financialManagementArea, final String fund, final String language )
    {
        return new FundTextByKeyFluentHelper(servicePath, "FundText", financialManagementArea, fund, language);
    }

    @Override
    @Nonnull
    public FundTextUpdateFluentHelper updateFundText( @Nonnull final FundText fundText )
    {
        return new FundTextUpdateFluentHelper(servicePath, fundText, "FundText");
    }

}
