/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.batch.DefaultGeneralLedgerAccountServiceBatch;

/**
 * <p>
 *
 * This service enables you to retrieve G/L accounts in chart of accounts and their names in the respective language..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/5f/4d16d6a031437fbfd1f61937c6b3fd/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GLACCOUNTINCHARTOFACCOUNTS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GLACCOUNTINCHARTOFACCOUNTS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241), Excise Tax Integration(SAP_COM_0568), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax
 * Management(4LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>General Ledger Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultGeneralLedgerAccountService" )
@Deprecated
public class DefaultGeneralLedgerAccountService implements GeneralLedgerAccountService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link GeneralLedgerAccountService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultGeneralLedgerAccountService()
    {
        servicePath = GeneralLedgerAccountService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultGeneralLedgerAccountService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultGeneralLedgerAccountService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultGeneralLedgerAccountService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultGeneralLedgerAccountServiceBatch batch()
    {
        return new DefaultGeneralLedgerAccountServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public GLAccountInChartOfAccountsFluentHelper getAllGLAccountInChartOfAccounts()
    {
        return new GLAccountInChartOfAccountsFluentHelper(servicePath, "A_GLAccountInChartOfAccounts");
    }

    @Override
    @Nonnull
    public
        GLAccountInChartOfAccountsByKeyFluentHelper
        getGLAccountInChartOfAccountsByKey( final String chartOfAccounts, final String gLAccount )
    {
        return new GLAccountInChartOfAccountsByKeyFluentHelper(
            servicePath,
            "A_GLAccountInChartOfAccounts",
            chartOfAccounts,
            gLAccount);
    }

    @Override
    @Nonnull
    public GLAccountTextFluentHelper getAllGLAccountText()
    {
        return new GLAccountTextFluentHelper(servicePath, "A_GLAccountText");
    }

    @Override
    @Nonnull
    public
        GLAccountTextByKeyFluentHelper
        getGLAccountTextByKey( final String chartOfAccounts, final String gLAccount, final String language )
    {
        return new GLAccountTextByKeyFluentHelper(servicePath, "A_GLAccountText", chartOfAccounts, gLAccount, language);
    }

}
