/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.batch.DefaultGrantHierarchyServiceBatch;

/**
 * <p>
 * This service enables you to read the grant hierarchy master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/88/51bd5b1afb49f89cb6b4096515b792/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GRANTCOREHIERARCHY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GRANTCOREHIERARCHY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Grant</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultGrantHierarchyService" )
@Deprecated
public class DefaultGrantHierarchyService implements GrantHierarchyService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link GrantHierarchyService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultGrantHierarchyService()
    {
        servicePath = GrantHierarchyService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultGrantHierarchyService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultGrantHierarchyService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultGrantHierarchyService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultGrantHierarchyServiceBatch batch()
    {
        return new DefaultGrantHierarchyServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public GrantCoreHierarchyFluentHelper getAllGrantCoreHierarchy()
    {
        return new GrantCoreHierarchyFluentHelper(servicePath, "GrantHierarchy");
    }

    @Override
    @Nonnull
    public
        GrantCoreHierarchyByKeyFluentHelper
        getGrantCoreHierarchyByKey( final String grantHierarchy, final LocalDateTime validityEndDate )
    {
        return new GrantCoreHierarchyByKeyFluentHelper(servicePath, "GrantHierarchy", grantHierarchy, validityEndDate);
    }

    @Override
    @Nonnull
    public GrantCoreHierarchyNodeTextFluentHelper getAllGrantCoreHierarchyNodeText()
    {
        return new GrantCoreHierarchyNodeTextFluentHelper(servicePath, "GrantHierarchyNodeText");
    }

    @Override
    @Nonnull
    public GrantCoreHierarchyNodeTextByKeyFluentHelper getGrantCoreHierarchyNodeTextByKey(
        final String grantHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new GrantCoreHierarchyNodeTextByKeyFluentHelper(
            servicePath,
            "GrantHierarchyNodeText",
            grantHierarchy,
            hierarchyNode,
            validityEndDate,
            language);
    }

    @Override
    @Nonnull
    public GrantCoreHierarchyTextFluentHelper getAllGrantCoreHierarchyText()
    {
        return new GrantCoreHierarchyTextFluentHelper(servicePath, "GrantHierarchyText");
    }

    @Override
    @Nonnull
    public GrantCoreHierarchyTextByKeyFluentHelper getGrantCoreHierarchyTextByKey(
        final String grantHierarchy,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new GrantCoreHierarchyTextByKeyFluentHelper(
            servicePath,
            "GrantHierarchyText",
            grantHierarchy,
            validityEndDate,
            language);
    }

    @Override
    @Nonnull
    public GrantCoreHierNodeFluentHelper getAllGrantCoreHierNode()
    {
        return new GrantCoreHierNodeFluentHelper(servicePath, "GrantHierarchyNode");
    }

    @Override
    @Nonnull
    public GrantCoreHierNodeByKeyFluentHelper getGrantCoreHierNodeByKey(
        final String grantHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        return new GrantCoreHierNodeByKeyFluentHelper(
            servicePath,
            "GrantHierarchyNode",
            grantHierarchy,
            hierarchyNode,
            validityEndDate);
    }

}
