/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.ChangeLifecycleStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.batch.DefaultGrantServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, update, and delete the grant master data from SAP S/4HANA Cloud system.
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/51/7981acd97a4f70bc28311b21cf5eea/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GRANTCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GRANTCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Grant</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultGrantService" )
@Deprecated
public class DefaultGrantService implements GrantService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link GrantService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultGrantService()
    {
        servicePath = GrantService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultGrantService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultGrantService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultGrantService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultGrantServiceBatch batch()
    {
        return new DefaultGrantServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public GrantBdgtValidityLinkFluentHelper getAllGrantBdgtValidityLink()
    {
        return new GrantBdgtValidityLinkFluentHelper(servicePath, "GrantBdgtValidityLink");
    }

    @Override
    @Nonnull
    public GrantBdgtValidityLinkByKeyFluentHelper getGrantBdgtValidityLinkByKey(
        final String grantID,
        final String granteeMgmtBdgtPhase,
        final String granteeMgmtBudgetStatus,
        final String gteeMBudgetValidityNumber )
    {
        return new GrantBdgtValidityLinkByKeyFluentHelper(
            servicePath,
            "GrantBdgtValidityLink",
            grantID,
            granteeMgmtBdgtPhase,
            granteeMgmtBudgetStatus,
            gteeMBudgetValidityNumber);
    }

    @Override
    @Nonnull
    public GrantBdgtValidityLinkUpdateFluentHelper updateGrantBdgtValidityLink(
        @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink )
    {
        return new GrantBdgtValidityLinkUpdateFluentHelper(servicePath, grantBdgtValidityLink, "GrantBdgtValidityLink");
    }

    @Override
    @Nonnull
    public GrantBdgtValidityLinkDeleteFluentHelper deleteGrantBdgtValidityLink(
        @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink )
    {
        return new GrantBdgtValidityLinkDeleteFluentHelper(servicePath, grantBdgtValidityLink, "GrantBdgtValidityLink");
    }

    @Override
    @Nonnull
    public GrantCoreFluentHelper getAllGrantCore()
    {
        return new GrantCoreFluentHelper(servicePath, "Grant");
    }

    @Override
    @Nonnull
    public GrantCoreByKeyFluentHelper getGrantCoreByKey( final String grantID )
    {
        return new GrantCoreByKeyFluentHelper(servicePath, "Grant", grantID);
    }

    @Override
    @Nonnull
    public GrantCoreCreateFluentHelper createGrantCore( @Nonnull final GrantCore grantCore )
    {
        return new GrantCoreCreateFluentHelper(servicePath, grantCore, "Grant");
    }

    @Override
    @Nonnull
    public GrantCoreUpdateFluentHelper updateGrantCore( @Nonnull final GrantCore grantCore )
    {
        return new GrantCoreUpdateFluentHelper(servicePath, grantCore, "Grant");
    }

    @Override
    @Nonnull
    public GrantCoreDeleteFluentHelper deleteGrantCore( @Nonnull final GrantCore grantCore )
    {
        return new GrantCoreDeleteFluentHelper(servicePath, grantCore, "Grant");
    }

    @Override
    @Nonnull
    public GrantCoreTextFluentHelper getAllGrantCoreText()
    {
        return new GrantCoreTextFluentHelper(servicePath, "GrantText");
    }

    @Override
    @Nonnull
    public GrantCoreTextByKeyFluentHelper getGrantCoreTextByKey( final String grantID, final String language )
    {
        return new GrantCoreTextByKeyFluentHelper(servicePath, "GrantText", grantID, language);
    }

    @Override
    @Nonnull
    public GrantCoreTextUpdateFluentHelper updateGrantCoreText( @Nonnull final GrantCoreText grantCoreText )
    {
        return new GrantCoreTextUpdateFluentHelper(servicePath, grantCoreText, "GrantText");
    }

    @Override
    @Nonnull
    public GrantCostSharingLinkFluentHelper getAllGrantCostSharingLink()
    {
        return new GrantCostSharingLinkFluentHelper(servicePath, "GrantCostSharingLink");
    }

    @Override
    @Nonnull
    public GrantCostSharingLinkByKeyFluentHelper getGrantCostSharingLinkByKey(
        final String grantID,
        final String financialManagementArea,
        final String fund,
        final String sponsoredProgram,
        final String sponsoredClass,
        final String gteeMCostSharingSource )
    {
        return new GrantCostSharingLinkByKeyFluentHelper(
            servicePath,
            "GrantCostSharingLink",
            grantID,
            financialManagementArea,
            fund,
            sponsoredProgram,
            sponsoredClass,
            gteeMCostSharingSource);
    }

    @Override
    @Nonnull
    public GrantCostSharingLinkUpdateFluentHelper updateGrantCostSharingLink(
        @Nonnull final GrantCostSharingLink grantCostSharingLink )
    {
        return new GrantCostSharingLinkUpdateFluentHelper(servicePath, grantCostSharingLink, "GrantCostSharingLink");
    }

    @Override
    @Nonnull
    public GrantCostSharingLinkDeleteFluentHelper deleteGrantCostSharingLink(
        @Nonnull final GrantCostSharingLink grantCostSharingLink )
    {
        return new GrantCostSharingLinkDeleteFluentHelper(servicePath, grantCostSharingLink, "GrantCostSharingLink");
    }

    @Override
    @Nonnull
    public GrantFundsLinkFluentHelper getAllGrantFundsLink()
    {
        return new GrantFundsLinkFluentHelper(servicePath, "GrantFundsLink");
    }

    @Override
    @Nonnull
    public
        GrantFundsLinkByKeyFluentHelper
        getGrantFundsLinkByKey( final String grantID, final String financialManagementArea, final String fund )
    {
        return new GrantFundsLinkByKeyFluentHelper(
            servicePath,
            "GrantFundsLink",
            grantID,
            financialManagementArea,
            fund);
    }

    @Override
    @Nonnull
    public GrantFundsLinkUpdateFluentHelper updateGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink )
    {
        return new GrantFundsLinkUpdateFluentHelper(servicePath, grantFundsLink, "GrantFundsLink");
    }

    @Override
    @Nonnull
    public GrantFundsLinkDeleteFluentHelper deleteGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink )
    {
        return new GrantFundsLinkDeleteFluentHelper(servicePath, grantFundsLink, "GrantFundsLink");
    }

    @Override
    @Nonnull
    public GrantObjOvrHeadCostCapLinkFluentHelper getAllGrantObjOvrHeadCostCapLink()
    {
        return new GrantObjOvrHeadCostCapLinkFluentHelper(servicePath, "GrantObjOvrHeadCostCapLink");
    }

    @Override
    @Nonnull
    public GrantObjOvrHeadCostCapLinkByKeyFluentHelper getGrantObjOvrHeadCostCapLinkByKey(
        final String grantID,
        final String sponsoredProgram,
        final String sponsoredClass,
        final LocalDateTime validityStartDate )
    {
        return new GrantObjOvrHeadCostCapLinkByKeyFluentHelper(
            servicePath,
            "GrantObjOvrHeadCostCapLink",
            grantID,
            sponsoredProgram,
            sponsoredClass,
            validityStartDate);
    }

    @Override
    @Nonnull
    public GrantObjOvrHeadCostCapLinkUpdateFluentHelper updateGrantObjOvrHeadCostCapLink(
        @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink )
    {
        return new GrantObjOvrHeadCostCapLinkUpdateFluentHelper(
            servicePath,
            grantObjOvrHeadCostCapLink,
            "GrantObjOvrHeadCostCapLink");
    }

    @Override
    @Nonnull
    public GrantObjOvrHeadCostCapLinkDeleteFluentHelper deleteGrantObjOvrHeadCostCapLink(
        @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink )
    {
        return new GrantObjOvrHeadCostCapLinkDeleteFluentHelper(
            servicePath,
            grantObjOvrHeadCostCapLink,
            "GrantObjOvrHeadCostCapLink");
    }

    @Override
    @Nonnull
    public GrantOverHeadCostCapLinkFluentHelper getAllGrantOverHeadCostCapLink()
    {
        return new GrantOverHeadCostCapLinkFluentHelper(servicePath, "GrantOverHeadCostCapLink");
    }

    @Override
    @Nonnull
    public
        GrantOverHeadCostCapLinkByKeyFluentHelper
        getGrantOverHeadCostCapLinkByKey( final String grantID, final LocalDateTime validityStartDate )
    {
        return new GrantOverHeadCostCapLinkByKeyFluentHelper(
            servicePath,
            "GrantOverHeadCostCapLink",
            grantID,
            validityStartDate);
    }

    @Override
    @Nonnull
    public GrantOverHeadCostCapLinkUpdateFluentHelper updateGrantOverHeadCostCapLink(
        @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink )
    {
        return new GrantOverHeadCostCapLinkUpdateFluentHelper(
            servicePath,
            grantOverHeadCostCapLink,
            "GrantOverHeadCostCapLink");
    }

    @Override
    @Nonnull
    public GrantOverHeadCostCapLinkDeleteFluentHelper deleteGrantOverHeadCostCapLink(
        @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink )
    {
        return new GrantOverHeadCostCapLinkDeleteFluentHelper(
            servicePath,
            grantOverHeadCostCapLink,
            "GrantOverHeadCostCapLink");
    }

    @Override
    @Nonnull
    public GrantOverHeadCostLinkFluentHelper getAllGrantOverHeadCostLink()
    {
        return new GrantOverHeadCostLinkFluentHelper(servicePath, "GrantOverHeadCostLink");
    }

    @Override
    @Nonnull
    public GrantOverHeadCostLinkByKeyFluentHelper getGrantOverHeadCostLinkByKey(
        final String grantID,
        final String sponsoredProgram,
        final String sponsoredClass,
        final LocalDateTime validityStartDate )
    {
        return new GrantOverHeadCostLinkByKeyFluentHelper(
            servicePath,
            "GrantOverHeadCostLink",
            grantID,
            sponsoredProgram,
            sponsoredClass,
            validityStartDate);
    }

    @Override
    @Nonnull
    public GrantOverHeadCostLinkUpdateFluentHelper updateGrantOverHeadCostLink(
        @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink )
    {
        return new GrantOverHeadCostLinkUpdateFluentHelper(servicePath, grantOverHeadCostLink, "GrantOverHeadCostLink");
    }

    @Override
    @Nonnull
    public GrantOverHeadCostLinkDeleteFluentHelper deleteGrantOverHeadCostLink(
        @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink )
    {
        return new GrantOverHeadCostLinkDeleteFluentHelper(servicePath, grantOverHeadCostLink, "GrantOverHeadCostLink");
    }

    @Override
    @Nonnull
    public GrantSponsoredClassesLinkFluentHelper getAllGrantSponsoredClassesLink()
    {
        return new GrantSponsoredClassesLinkFluentHelper(servicePath, "GrantSponsoredClassesLink");
    }

    @Override
    @Nonnull
    public
        GrantSponsoredClassesLinkByKeyFluentHelper
        getGrantSponsoredClassesLinkByKey( final String grantID, final String sponsoredClass )
    {
        return new GrantSponsoredClassesLinkByKeyFluentHelper(
            servicePath,
            "GrantSponsoredClassesLink",
            grantID,
            sponsoredClass);
    }

    @Override
    @Nonnull
    public GrantSponsoredClassesLinkUpdateFluentHelper updateGrantSponsoredClassesLink(
        @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink )
    {
        return new GrantSponsoredClassesLinkUpdateFluentHelper(
            servicePath,
            grantSponsoredClassesLink,
            "GrantSponsoredClassesLink");
    }

    @Override
    @Nonnull
    public GrantSponsoredClassesLinkDeleteFluentHelper deleteGrantSponsoredClassesLink(
        @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink )
    {
        return new GrantSponsoredClassesLinkDeleteFluentHelper(
            servicePath,
            grantSponsoredClassesLink,
            "GrantSponsoredClassesLink");
    }

    @Override
    @Nonnull
    public GrantSponsoredProgramsLinkFluentHelper getAllGrantSponsoredProgramsLink()
    {
        return new GrantSponsoredProgramsLinkFluentHelper(servicePath, "GrantSponsoredProgramsLink");
    }

    @Override
    @Nonnull
    public
        GrantSponsoredProgramsLinkByKeyFluentHelper
        getGrantSponsoredProgramsLinkByKey( final String grantID, final String sponsoredProgram )
    {
        return new GrantSponsoredProgramsLinkByKeyFluentHelper(
            servicePath,
            "GrantSponsoredProgramsLink",
            grantID,
            sponsoredProgram);
    }

    @Override
    @Nonnull
    public GrantSponsoredProgramsLinkUpdateFluentHelper updateGrantSponsoredProgramsLink(
        @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink )
    {
        return new GrantSponsoredProgramsLinkUpdateFluentHelper(
            servicePath,
            grantSponsoredProgramsLink,
            "GrantSponsoredProgramsLink");
    }

    @Override
    @Nonnull
    public GrantSponsoredProgramsLinkDeleteFluentHelper deleteGrantSponsoredProgramsLink(
        @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink )
    {
        return new GrantSponsoredProgramsLinkDeleteFluentHelper(
            servicePath,
            grantSponsoredProgramsLink,
            "GrantSponsoredProgramsLink");
    }

    @Override
    @Nonnull
    public
        ChangeLifecycleStatusFluentHelper
        changeLifecycleStatus( @Nonnull final String grantID, @Nullable final String grantLifecycleStatus )
    {
        return new ChangeLifecycleStatusFluentHelper(servicePath, grantID, grantLifecycleStatus);
    }

}
