/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.batch.DefaultHandlingUnitServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - Retrieve header information for a handling unit.
 * For handling units processed in warehouse management, warehouse number plus handling unit number must be used as a
 * key. For handling units not relevant for warehouse management, the handling unit number is used as a key. You can use
 * filter criteria to retrieve information based on other selection criteria, for example, delivery reference. -
 * Retrieve item information for a handling unit, which contains information about the products packed in the handling
 * unit.
 *
 * You can apply the filters provided or retrieve all existing data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/35/40bd25c1334dad9782b22c094bd748/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_HANDLING_UNIT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_HANDLING_UNIT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Handling Unit Integration(SAP_COM_0364), Delivery Insights Replication App Integration
 * (Obsolete)(SAP_COM_0571)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BS'>Warehouse Outbound Processing(3BS)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4MM'>Handling Unit Management(4MM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4IH'>Delivery Insights enabled by IoT(4IH)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Handling Unit</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2105 (May 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultHandlingUnitService" )
@Deprecated
public class DefaultHandlingUnitService implements HandlingUnitService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link HandlingUnitService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultHandlingUnitService()
    {
        servicePath = HandlingUnitService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultHandlingUnitService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultHandlingUnitService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultHandlingUnitService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultHandlingUnitServiceBatch batch()
    {
        return new DefaultHandlingUnitServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public HandlingUnitFluentHelper getAllHandlingUnit()
    {
        return new HandlingUnitFluentHelper(servicePath, "HandlingUnit");
    }

    @Override
    @Nonnull
    public
        HandlingUnitByKeyFluentHelper
        getHandlingUnitByKey( final String handlingUnitExternalID, final String warehouse )
    {
        return new HandlingUnitByKeyFluentHelper(servicePath, "HandlingUnit", handlingUnitExternalID, warehouse);
    }

    @Override
    @Nonnull
    public HandlingUnitItemFluentHelper getAllHandlingUnitItem()
    {
        return new HandlingUnitItemFluentHelper(servicePath, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public HandlingUnitItemByKeyFluentHelper getHandlingUnitItemByKey(
        final String handlingUnitExternalID,
        final String warehouse,
        final UUID stockItemUUID )
    {
        return new HandlingUnitItemByKeyFluentHelper(
            servicePath,
            "HandlingUnitItem",
            handlingUnitExternalID,
            warehouse,
            stockItemUUID);
    }

}
