/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.ConfirmPutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.ConfirmPutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliverySerialNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.PutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.PutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.batch.DefaultInboundDeliveryServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete inbound deliveries. It can be consumed in Fiori apps and
 * on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a9/a6d58ffaf841cb99c67d3b0dbbd71b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INBOUND_DELIVERY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INBOUND_DELIVERY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the
 *             <a href="https://api.sap.com/api/API_INBOUND_DELIVERY_SRV_0002"> successor API</a> instead.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultInboundDeliveryService" )
@Deprecated
public class DefaultInboundDeliveryService implements InboundDeliveryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link InboundDeliveryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultInboundDeliveryService()
    {
        servicePath = InboundDeliveryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultInboundDeliveryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultInboundDeliveryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultInboundDeliveryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultInboundDeliveryServiceBatch batch()
    {
        return new DefaultInboundDeliveryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public InbDeliveryDocFlowByKeyFluentHelper getInbDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory )
    {
        return new InbDeliveryDocFlowByKeyFluentHelper(
            servicePath,
            "A_InbDeliveryDocFlow",
            precedingDocument,
            precedingDocumentItem,
            subsequentDocumentCategory);
    }

    @Override
    @Nonnull
    public InbDeliveryDocFlowUpdateFluentHelper updateInbDeliveryDocFlow(
        @Nonnull final InbDeliveryDocFlow inbDeliveryDocFlow )
    {
        return new InbDeliveryDocFlowUpdateFluentHelper(servicePath, inbDeliveryDocFlow, "A_InbDeliveryDocFlow");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderFluentHelper getAllInbDeliveryHeader()
    {
        return new InbDeliveryHeaderFluentHelper(servicePath, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderByKeyFluentHelper getInbDeliveryHeaderByKey( final String deliveryDocument )
    {
        return new InbDeliveryHeaderByKeyFluentHelper(servicePath, "A_InbDeliveryHeader", deliveryDocument);
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderCreateFluentHelper createInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return new InbDeliveryHeaderCreateFluentHelper(servicePath, inbDeliveryHeader, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderUpdateFluentHelper updateInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return new InbDeliveryHeaderUpdateFluentHelper(servicePath, inbDeliveryHeader, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderDeleteFluentHelper deleteInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return new InbDeliveryHeaderDeleteFluentHelper(servicePath, inbDeliveryHeader, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryItemFluentHelper getAllInbDeliveryItem()
    {
        return new InbDeliveryItemFluentHelper(servicePath, "A_InbDeliveryItem");
    }

    @Override
    @Nonnull
    public
        InbDeliveryItemByKeyFluentHelper
        getInbDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem )
    {
        return new InbDeliveryItemByKeyFluentHelper(
            servicePath,
            "A_InbDeliveryItem",
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public InbDeliveryItemUpdateFluentHelper updateInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return new InbDeliveryItemUpdateFluentHelper(servicePath, inbDeliveryItem, "A_InbDeliveryItem");
    }

    @Override
    @Nonnull
    public InbDeliveryItemDeleteFluentHelper deleteInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return new InbDeliveryItemDeleteFluentHelper(servicePath, inbDeliveryItem, "A_InbDeliveryItem");
    }

    @Override
    @Nonnull
    public
        InbDeliveryPartnerByKeyFluentHelper
        getInbDeliveryPartnerByKey( final String partnerFunction, final String sDDocument )
    {
        return new InbDeliveryPartnerByKeyFluentHelper(
            servicePath,
            "A_InbDeliveryPartner",
            partnerFunction,
            sDDocument);
    }

    @Override
    @Nonnull
    public InbDeliverySerialNmbrByKeyFluentHelper getInbDeliverySerialNmbrByKey(
        final Integer maintenanceItemObjectList )
    {
        return new InbDeliverySerialNmbrByKeyFluentHelper(
            servicePath,
            "A_InbDeliverySerialNmbr",
            maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    public ConfirmPutawayAllItemsFluentHelper confirmPutawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new ConfirmPutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        ConfirmPutawayOneItemFluentHelper
        confirmPutawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new ConfirmPutawayOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String deliveryDocument )
    {
        return new PostGoodsReceiptFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public PutawayAllItemsFluentHelper putawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new PutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        PutawayOneItemFluentHelper
        putawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new PutawayOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public ReverseGoodsReceiptFluentHelper reverseGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nonnull final LocalDateTime actualGoodsMovementDate )
    {
        return new ReverseGoodsReceiptFluentHelper(servicePath, deliveryDocument, actualGoodsMovementDate);
    }

}
