/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.AddSerialNumberToDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ConfirmPutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ConfirmPutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.CreateBatchSplitItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.DeleteAllSerialNumbersFromDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.DeleteSerialNumberFromDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliverySerialNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemWithSalesQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.SetPutawayQuantityWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.batch.DefaultInboundDeliveryV2ServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete inbound deliveries. It can be consumed in Fiori apps and
 * on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d1/0ec16c462a44a7be6c6721c9bb0a93/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INBOUND_DELIVERY_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INBOUND_DELIVERY_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultInboundDeliveryV2Service" )
@Deprecated
public class DefaultInboundDeliveryV2Service implements InboundDeliveryV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link InboundDeliveryV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultInboundDeliveryV2Service()
    {
        servicePath = InboundDeliveryV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultInboundDeliveryV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultInboundDeliveryV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultInboundDeliveryV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultInboundDeliveryV2ServiceBatch batch()
    {
        return new DefaultInboundDeliveryV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public InbDeliveryDocFlowByKeyFluentHelper getInbDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory )
    {
        return new InbDeliveryDocFlowByKeyFluentHelper(
            servicePath,
            "A_InbDeliveryDocFlow",
            precedingDocument,
            precedingDocumentItem,
            subsequentDocumentCategory);
    }

    @Override
    @Nonnull
    public InbDeliveryDocFlowUpdateFluentHelper updateInbDeliveryDocFlow(
        @Nonnull final InbDeliveryDocFlow inbDeliveryDocFlow )
    {
        return new InbDeliveryDocFlowUpdateFluentHelper(servicePath, inbDeliveryDocFlow, "A_InbDeliveryDocFlow");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderFluentHelper getAllInbDeliveryHeader()
    {
        return new InbDeliveryHeaderFluentHelper(servicePath, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderByKeyFluentHelper getInbDeliveryHeaderByKey( final String deliveryDocument )
    {
        return new InbDeliveryHeaderByKeyFluentHelper(servicePath, "A_InbDeliveryHeader", deliveryDocument);
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderCreateFluentHelper createInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return new InbDeliveryHeaderCreateFluentHelper(servicePath, inbDeliveryHeader, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderUpdateFluentHelper updateInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return new InbDeliveryHeaderUpdateFluentHelper(servicePath, inbDeliveryHeader, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryHeaderDeleteFluentHelper deleteInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return new InbDeliveryHeaderDeleteFluentHelper(servicePath, inbDeliveryHeader, "A_InbDeliveryHeader");
    }

    @Override
    @Nonnull
    public InbDeliveryItemFluentHelper getAllInbDeliveryItem()
    {
        return new InbDeliveryItemFluentHelper(servicePath, "A_InbDeliveryItem");
    }

    @Override
    @Nonnull
    public
        InbDeliveryItemByKeyFluentHelper
        getInbDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem )
    {
        return new InbDeliveryItemByKeyFluentHelper(
            servicePath,
            "A_InbDeliveryItem",
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public InbDeliveryItemUpdateFluentHelper updateInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return new InbDeliveryItemUpdateFluentHelper(servicePath, inbDeliveryItem, "A_InbDeliveryItem");
    }

    @Override
    @Nonnull
    public InbDeliveryItemDeleteFluentHelper deleteInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return new InbDeliveryItemDeleteFluentHelper(servicePath, inbDeliveryItem, "A_InbDeliveryItem");
    }

    @Override
    @Nonnull
    public
        InbDeliveryPartnerByKeyFluentHelper
        getInbDeliveryPartnerByKey( final String partnerFunction, final String sDDocument )
    {
        return new InbDeliveryPartnerByKeyFluentHelper(
            servicePath,
            "A_InbDeliveryPartner",
            partnerFunction,
            sDDocument);
    }

    @Override
    @Nonnull
    public InbDeliverySerialNmbrByKeyFluentHelper getInbDeliverySerialNmbrByKey( final Long maintenanceItemObjectList )
    {
        return new InbDeliverySerialNmbrByKeyFluentHelper(
            servicePath,
            "A_InbDeliverySerialNmbr",
            maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    public ConfirmPutawayAllItemsFluentHelper confirmPutawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new ConfirmPutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        ConfirmPutawayOneItemFluentHelper
        confirmPutawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new ConfirmPutawayOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String deliveryDocument )
    {
        return new PostGoodsReceiptFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public PostGoodsReceiptFluentHelper postGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nullable final LocalDateTime actualGoodsMovementDate )
    {
        return new PostGoodsReceiptFluentHelper(servicePath, deliveryDocument, actualGoodsMovementDate);
    }

    @Override
    @Nonnull
    public PutawayAllItemsFluentHelper putawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new PutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        PutawayOneItemFluentHelper
        putawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new PutawayOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public ReverseGoodsReceiptFluentHelper reverseGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nonnull final LocalDateTime actualGoodsMovementDate )
    {
        return new ReverseGoodsReceiptFluentHelper(servicePath, deliveryDocument, actualGoodsMovementDate);
    }

    @Override
    @Nonnull
    public CreateBatchSplitItemFluentHelper createBatchSplitItem(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String batch,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryQuantityUnit,
        @Nullable final BigDecimal putawayQuantityInOrderUnit,
        @Nullable final LocalDateTime shelfLifeExpirationDate,
        @Nullable final LocalDateTime manufactureDate,
        @Nullable final String batchBySupplier )
    {
        return new CreateBatchSplitItemFluentHelper(
            servicePath,
            actualDeliveryQuantity,
            batch,
            deliveryDocument,
            deliveryDocumentItem,
            deliveryQuantityUnit,
            putawayQuantityInOrderUnit,
            shelfLifeExpirationDate,
            manufactureDate,
            batchBySupplier);
    }

    @Override
    @Nonnull
    public AddSerialNumberToDeliveryItemFluentHelper addSerialNumberToDeliveryItem(
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String serialNumber )
    {
        return new AddSerialNumberToDeliveryItemFluentHelper(
            servicePath,
            deliveryDocument,
            deliveryDocumentItem,
            serialNumber);
    }

    @Override
    @Nonnull
    public DeleteAllSerialNumbersFromDeliveryItemFluentHelper deleteAllSerialNumbersFromDeliveryItem(
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem )
    {
        return new DeleteAllSerialNumbersFromDeliveryItemFluentHelper(
            servicePath,
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public DeleteSerialNumberFromDeliveryItemFluentHelper deleteSerialNumberFromDeliveryItem(
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String serialNumber )
    {
        return new DeleteSerialNumberFromDeliveryItemFluentHelper(
            servicePath,
            deliveryDocument,
            deliveryDocumentItem,
            serialNumber);
    }

    @Override
    @Nonnull
    public SetPutawayQuantityWithBaseQuantityFluentHelper setPutawayQuantityWithBaseQuantity(
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String baseUnit,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem )
    {
        return new SetPutawayQuantityWithBaseQuantityFluentHelper(
            servicePath,
            actualDeliveredQtyInBaseUnit,
            baseUnit,
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public PutawayOneItemWithBaseQuantityFluentHelper putawayOneItemWithBaseQuantity(
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String baseUnit,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem )
    {
        return new PutawayOneItemWithBaseQuantityFluentHelper(
            servicePath,
            actualDeliveredQtyInBaseUnit,
            baseUnit,
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public PutawayOneItemWithSalesQuantityFluentHelper putawayOneItemWithSalesQuantity(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryQuantityUnit )
    {
        return new PutawayOneItemWithSalesQuantityFluentHelper(
            servicePath,
            actualDeliveryQuantity,
            deliveryDocument,
            deliveryDocumentItem,
            deliveryQuantityUnit);
    }

}
