/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.DeclareInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.ReceiveInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.SignoffInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.batch.DefaultIncomingVATInvoiceChinaServiceBatch;

/**
 * <p>
 *
 * The service is based on the *OData* protocol, and can be consumed by external systems and user interfaces to
 * integrate with incoming VAT invoice management in SAP S/4HANA Cloud. You can create a complete China VAT invoice
 * record including invoice header, item and binding record in one single call. You can also perform the following
 * operations: declare, receive, and sign off the invoice. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/66/70fe5b84bb4be28cf0782f1d60c328/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CN_VAT_INVOICE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CN_VAT_INVOICE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Incoming China VAT Invoice Integration(SAP_COM_0546)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J58'>Accounting and Financial Close(J58)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>China VAT Invoice</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultIncomingVATInvoiceChinaService" )
@Deprecated
public class DefaultIncomingVATInvoiceChinaService implements IncomingVATInvoiceChinaService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link IncomingVATInvoiceChinaService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultIncomingVATInvoiceChinaService()
    {
        servicePath = IncomingVATInvoiceChinaService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultIncomingVATInvoiceChinaService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultIncomingVATInvoiceChinaService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultIncomingVATInvoiceChinaService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultIncomingVATInvoiceChinaServiceBatch batch()
    {
        return new DefaultIncomingVATInvoiceChinaServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CN_TaxInputInvoiceFluentHelper getAllCN_TaxInputInvoice()
    {
        return new CN_TaxInputInvoiceFluentHelper(servicePath, "A_CN_TaxInputInvoice");
    }

    @Override
    @Nonnull
    public CN_TaxInputInvoiceByKeyFluentHelper getCN_TaxInputInvoiceByKey( final UUID cN_TaxInvcUUID )
    {
        return new CN_TaxInputInvoiceByKeyFluentHelper(servicePath, "A_CN_TaxInputInvoice", cN_TaxInvcUUID);
    }

    @Override
    @Nonnull
    public CN_TaxInputInvoiceCreateFluentHelper createCN_TaxInputInvoice(
        @Nonnull final CN_TaxInputInvoice cN_TaxInputInvoice )
    {
        return new CN_TaxInputInvoiceCreateFluentHelper(servicePath, cN_TaxInputInvoice, "A_CN_TaxInputInvoice");
    }

    @Override
    @Nonnull
    public CN_TaxInputInvoiceItemFluentHelper getAllCN_TaxInputInvoiceItem()
    {
        return new CN_TaxInputInvoiceItemFluentHelper(servicePath, "A_CN_TaxInputInvoiceItem");
    }

    @Override
    @Nonnull
    public
        CN_TaxInputInvoiceItemByKeyFluentHelper
        getCN_TaxInputInvoiceItemByKey( final UUID taxInvoiceItemUUID, final UUID cN_TaxInvcUUID )
    {
        return new CN_TaxInputInvoiceItemByKeyFluentHelper(
            servicePath,
            "A_CN_TaxInputInvoiceItem",
            taxInvoiceItemUUID,
            cN_TaxInvcUUID);
    }

    @Override
    @Nonnull
    public CN_TaxInputInvoiceItemCreateFluentHelper createCN_TaxInputInvoiceItem(
        @Nonnull final CN_TaxInputInvoiceItem cN_TaxInputInvoiceItem )
    {
        return new CN_TaxInputInvoiceItemCreateFluentHelper(
            servicePath,
            cN_TaxInputInvoiceItem,
            "A_CN_TaxInputInvoiceItem");
    }

    @Override
    @Nonnull
    public CN_TaxInvoiceBindingRecordFluentHelper getAllCN_TaxInvoiceBindingRecord()
    {
        return new CN_TaxInvoiceBindingRecordFluentHelper(servicePath, "A_CN_TaxInvoiceBindingRecord");
    }

    @Override
    @Nonnull
    public
        CN_TaxInvoiceBindingRecordByKeyFluentHelper
        getCN_TaxInvoiceBindingRecordByKey( final UUID cN_TaxInvcBindgUUID, final UUID cN_TaxInvcBindgItmUUID )
    {
        return new CN_TaxInvoiceBindingRecordByKeyFluentHelper(
            servicePath,
            "A_CN_TaxInvoiceBindingRecord",
            cN_TaxInvcBindgUUID,
            cN_TaxInvcBindgItmUUID);
    }

    @Override
    @Nonnull
    public CN_TaxInvoiceBindingRecordCreateFluentHelper createCN_TaxInvoiceBindingRecord(
        @Nonnull final CN_TaxInvoiceBindingRecord cN_TaxInvoiceBindingRecord )
    {
        return new CN_TaxInvoiceBindingRecordCreateFluentHelper(
            servicePath,
            cN_TaxInvoiceBindingRecord,
            "A_CN_TaxInvoiceBindingRecord");
    }

    @Override
    @Nonnull
    public ReceiveInvoiceFluentHelper receiveInvoice( @Nonnull final UUID cN_TaxInvcUUID )
    {
        return new ReceiveInvoiceFluentHelper(servicePath, cN_TaxInvcUUID);
    }

    @Override
    @Nonnull
    public SignoffInvoiceFluentHelper signoffInvoice( @Nonnull final UUID cN_TaxInvcUUID )
    {
        return new SignoffInvoiceFluentHelper(servicePath, cN_TaxInvcUUID);
    }

    @Override
    @Nonnull
    public DeclareInvoiceFluentHelper declareInvoice(
        @Nonnull final UUID cN_TaxInvcUUID,
        @Nonnull final String declnMonth,
        @Nonnull final String declnYear )
    {
        return new DeclareInvoiceFluentHelper(servicePath, cN_TaxInvcUUID, declnMonth, declnYear);
    }

}
