/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.batch.DefaultIncotermServiceBatch;

/**
 * <p>
 * The OData service enables external systems and other consumers to retrieve Incoterms data in your system. Retrievable
 * details include Incoterms and Incoterms versions.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f6/8abfe593df4415bfc3555f51c1bfd3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SD_INCOTERMS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SD_INCOTERMS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Master Data Integration(SAP_COM_0746), Procurement - Supplier Quotation Management
 * Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Incoterms Classification</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultIncotermService" )
@Deprecated
public class DefaultIncotermService implements IncotermService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link IncotermService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultIncotermService()
    {
        servicePath = IncotermService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultIncotermService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultIncotermService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultIncotermService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultIncotermServiceBatch batch()
    {
        return new DefaultIncotermServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public IncotermsClassificationFluentHelper getAllIncotermsClassification()
    {
        return new IncotermsClassificationFluentHelper(servicePath, "A_IncotermsClassification");
    }

    @Override
    @Nonnull
    public IncotermsClassificationByKeyFluentHelper getIncotermsClassificationByKey(
        final String incotermsClassification )
    {
        return new IncotermsClassificationByKeyFluentHelper(
            servicePath,
            "A_IncotermsClassification",
            incotermsClassification);
    }

    @Override
    @Nonnull
    public IncotermsClassificationTextFluentHelper getAllIncotermsClassificationText()
    {
        return new IncotermsClassificationTextFluentHelper(servicePath, "A_IncotermsClassificationText");
    }

    @Override
    @Nonnull
    public
        IncotermsClassificationTextByKeyFluentHelper
        getIncotermsClassificationTextByKey( final String incotermsClassification, final String language )
    {
        return new IncotermsClassificationTextByKeyFluentHelper(
            servicePath,
            "A_IncotermsClassificationText",
            incotermsClassification,
            language);
    }

    @Override
    @Nonnull
    public IncotermsVersionFluentHelper getAllIncotermsVersion()
    {
        return new IncotermsVersionFluentHelper(servicePath, "A_IncotermsVersion");
    }

    @Override
    @Nonnull
    public IncotermsVersionByKeyFluentHelper getIncotermsVersionByKey( final String incotermsVersion )
    {
        return new IncotermsVersionByKeyFluentHelper(servicePath, "A_IncotermsVersion", incotermsVersion);
    }

    @Override
    @Nonnull
    public IncotermsVersionTextFluentHelper getAllIncotermsVersionText()
    {
        return new IncotermsVersionTextFluentHelper(servicePath, "A_IncotermsVersionText");
    }

    @Override
    @Nonnull
    public
        IncotermsVersionTextByKeyFluentHelper
        getIncotermsVersionTextByKey( final String incotermsVersion, final String language )
    {
        return new IncotermsVersionTextByKeyFluentHelper(
            servicePath,
            "A_IncotermsVersionText",
            incotermsVersion,
            language);
    }

}
