/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.batch.DefaultInspectionMethodServiceBatch;

/**
 * <p>
 *
 * An inspection method is a master data record that describes the procedure for performing the quality inspection of a
 * characteristic. This service enables you to retrieve inspection methods with their settings and administrative data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/93/c446582d6e0a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INSPECTIONMETHOD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INSPECTIONMETHOD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Method</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultInspectionMethodService" )
@Deprecated
public class DefaultInspectionMethodService implements InspectionMethodService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link InspectionMethodService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultInspectionMethodService()
    {
        servicePath = InspectionMethodService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultInspectionMethodService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultInspectionMethodService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultInspectionMethodService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultInspectionMethodServiceBatch batch()
    {
        return new DefaultInspectionMethodServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public InspectionMethodFluentHelper getAllInspectionMethod()
    {
        return new InspectionMethodFluentHelper(servicePath, "A_InspectionMethod");
    }

    @Override
    @Nonnull
    public InspectionMethodByKeyFluentHelper getInspectionMethodByKey(
        final String inspectionMethod,
        final String inspectionMethodVersion,
        final String inspectionMethodPlant )
    {
        return new InspectionMethodByKeyFluentHelper(
            servicePath,
            "A_InspectionMethod",
            inspectionMethod,
            inspectionMethodVersion,
            inspectionMethodPlant);
    }

    @Override
    @Nonnull
    public InspectionMethodTextFluentHelper getAllInspectionMethodText()
    {
        return new InspectionMethodTextFluentHelper(servicePath, "A_InspectionMethodText");
    }

    @Override
    @Nonnull
    public InspectionMethodTextByKeyFluentHelper getInspectionMethodTextByKey(
        final String inspectionMethodPlant,
        final String inspectionMethod,
        final String inspectionMethodVersion,
        final String language )
    {
        return new InspectionMethodTextByKeyFluentHelper(
            servicePath,
            "A_InspectionMethodText",
            inspectionMethodPlant,
            inspectionMethod,
            inspectionMethodVersion,
            language);
    }

}
