/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.batch.DefaultInspectionPlanServiceBatch;

/**
 * <p>
 *
 * Inspection plans help you to describe how a quality inspection of one or several materials is to take place. In the
 * inspection plan, you define the sequence of inspection operations and the range of specifications available for
 * inspecting inspection characteristics..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/df/80a14a344046d99ebd21b59861d131/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INSPECTIONPLAN_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INSPECTIONPLAN_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Plan</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultInspectionPlanService" )
@Deprecated
public class DefaultInspectionPlanService implements InspectionPlanService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link InspectionPlanService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultInspectionPlanService()
    {
        servicePath = InspectionPlanService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultInspectionPlanService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultInspectionPlanService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultInspectionPlanService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultInspectionPlanServiceBatch batch()
    {
        return new DefaultInspectionPlanServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public InspectionPlanFluentHelper getAllInspectionPlan()
    {
        return new InspectionPlanFluentHelper(servicePath, "A_InspectionPlan");
    }

    @Override
    @Nonnull
    public InspectionPlanByKeyFluentHelper getInspectionPlanByKey(
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspectionPlanInternalVersion )
    {
        return new InspectionPlanByKeyFluentHelper(
            servicePath,
            "A_InspectionPlan",
            inspectionPlanGroup,
            inspectionPlan,
            inspectionPlanInternalVersion);
    }

    @Override
    @Nonnull
    public InspectionPlanCreateFluentHelper createInspectionPlan( @Nonnull final InspectionPlan inspectionPlan )
    {
        return new InspectionPlanCreateFluentHelper(servicePath, inspectionPlan, "A_InspectionPlan");
    }

    @Override
    @Nonnull
    public InspectionPlanUpdateFluentHelper updateInspectionPlan( @Nonnull final InspectionPlan inspectionPlan )
    {
        return new InspectionPlanUpdateFluentHelper(servicePath, inspectionPlan, "A_InspectionPlan");
    }

    @Override
    @Nonnull
    public InspectionPlanDeleteFluentHelper deleteInspectionPlan( @Nonnull final InspectionPlan inspectionPlan )
    {
        return new InspectionPlanDeleteFluentHelper(servicePath, inspectionPlan, "A_InspectionPlan");
    }

    @Override
    @Nonnull
    public InspPlanDepdntCharcFluentHelper getAllInspPlanDepdntCharc()
    {
        return new InspPlanDepdntCharcFluentHelper(servicePath, "A_InspPlanDepdntCharc");
    }

    @Override
    @Nonnull
    public InspPlanDepdntCharcByKeyFluentHelper getInspPlanDepdntCharcByKey(
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspectionPlanInternalVersion,
        final String bOOOperationInternalID,
        final String bOOOpInternalVersionCounter,
        final String bOOCharacteristic,
        final String bOOCharacteristicVersion,
        final String bOODpndantCharcSpec,
        final String bOODpndantCharcSpecVers )
    {
        return new InspPlanDepdntCharcByKeyFluentHelper(
            servicePath,
            "A_InspPlanDepdntCharc",
            inspectionPlanGroup,
            inspectionPlan,
            inspectionPlanInternalVersion,
            bOOOperationInternalID,
            bOOOpInternalVersionCounter,
            bOOCharacteristic,
            bOOCharacteristicVersion,
            bOODpndantCharcSpec,
            bOODpndantCharcSpecVers);
    }

    @Override
    @Nonnull
    public InspPlanDepdntCharcCreateFluentHelper createInspPlanDepdntCharc(
        @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc )
    {
        return new InspPlanDepdntCharcCreateFluentHelper(servicePath, inspPlanDepdntCharc, "A_InspPlanDepdntCharc");
    }

    @Override
    @Nonnull
    public InspPlanDepdntCharcUpdateFluentHelper updateInspPlanDepdntCharc(
        @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc )
    {
        return new InspPlanDepdntCharcUpdateFluentHelper(servicePath, inspPlanDepdntCharc, "A_InspPlanDepdntCharc");
    }

    @Override
    @Nonnull
    public InspPlanDepdntCharcDeleteFluentHelper deleteInspPlanDepdntCharc(
        @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc )
    {
        return new InspPlanDepdntCharcDeleteFluentHelper(servicePath, inspPlanDepdntCharc, "A_InspPlanDepdntCharc");
    }

    @Override
    @Nonnull
    public InspPlanMaterialAssgmtFluentHelper getAllInspPlanMaterialAssgmt()
    {
        return new InspPlanMaterialAssgmtFluentHelper(servicePath, "A_InspPlanMaterialAssgmt");
    }

    @Override
    @Nonnull
    public InspPlanMaterialAssgmtByKeyFluentHelper getInspPlanMaterialAssgmtByKey(
        final String material,
        final String plant,
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspPlanMatlAssignment,
        final String inspPlanMatlAssgmtIntVersion )
    {
        return new InspPlanMaterialAssgmtByKeyFluentHelper(
            servicePath,
            "A_InspPlanMaterialAssgmt",
            material,
            plant,
            inspectionPlanGroup,
            inspectionPlan,
            inspPlanMatlAssignment,
            inspPlanMatlAssgmtIntVersion);
    }

    @Override
    @Nonnull
    public InspPlanMaterialAssgmtCreateFluentHelper createInspPlanMaterialAssgmt(
        @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt )
    {
        return new InspPlanMaterialAssgmtCreateFluentHelper(
            servicePath,
            inspPlanMaterialAssgmt,
            "A_InspPlanMaterialAssgmt");
    }

    @Override
    @Nonnull
    public InspPlanMaterialAssgmtUpdateFluentHelper updateInspPlanMaterialAssgmt(
        @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt )
    {
        return new InspPlanMaterialAssgmtUpdateFluentHelper(
            servicePath,
            inspPlanMaterialAssgmt,
            "A_InspPlanMaterialAssgmt");
    }

    @Override
    @Nonnull
    public InspPlanMaterialAssgmtDeleteFluentHelper deleteInspPlanMaterialAssgmt(
        @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt )
    {
        return new InspPlanMaterialAssgmtDeleteFluentHelper(
            servicePath,
            inspPlanMaterialAssgmt,
            "A_InspPlanMaterialAssgmt");
    }

    @Override
    @Nonnull
    public InspPlanOpCharacteristicFluentHelper getAllInspPlanOpCharacteristic()
    {
        return new InspPlanOpCharacteristicFluentHelper(servicePath, "A_InspPlanOpCharacteristic");
    }

    @Override
    @Nonnull
    public InspPlanOpCharacteristicByKeyFluentHelper getInspPlanOpCharacteristicByKey(
        final String inspectionPlanGroup,
        final String bOOOperationInternalID,
        final String bOOCharacteristic,
        final String bOOCharacteristicVersion,
        final String bOOOpInternalVersionCounter,
        final String inspectionPlanInternalVersion,
        final String inspectionPlan )
    {
        return new InspPlanOpCharacteristicByKeyFluentHelper(
            servicePath,
            "A_InspPlanOpCharacteristic",
            inspectionPlanGroup,
            bOOOperationInternalID,
            bOOCharacteristic,
            bOOCharacteristicVersion,
            bOOOpInternalVersionCounter,
            inspectionPlanInternalVersion,
            inspectionPlan);
    }

    @Override
    @Nonnull
    public InspPlanOpCharacteristicCreateFluentHelper createInspPlanOpCharacteristic(
        @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic )
    {
        return new InspPlanOpCharacteristicCreateFluentHelper(
            servicePath,
            inspPlanOpCharacteristic,
            "A_InspPlanOpCharacteristic");
    }

    @Override
    @Nonnull
    public InspPlanOpCharacteristicUpdateFluentHelper updateInspPlanOpCharacteristic(
        @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic )
    {
        return new InspPlanOpCharacteristicUpdateFluentHelper(
            servicePath,
            inspPlanOpCharacteristic,
            "A_InspPlanOpCharacteristic");
    }

    @Override
    @Nonnull
    public InspPlanOpCharacteristicDeleteFluentHelper deleteInspPlanOpCharacteristic(
        @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic )
    {
        return new InspPlanOpCharacteristicDeleteFluentHelper(
            servicePath,
            inspPlanOpCharacteristic,
            "A_InspPlanOpCharacteristic");
    }

    @Override
    @Nonnull
    public InspPlanOperationFluentHelper getAllInspPlanOperation()
    {
        return new InspPlanOperationFluentHelper(servicePath, "A_InspPlanOperation");
    }

    @Override
    @Nonnull
    public InspPlanOperationByKeyFluentHelper getInspPlanOperationByKey(
        final String inspectionPlanGroup,
        final String bOOOperationInternalID,
        final String inspectionPlanInternalVersion,
        final String bOOOpInternalVersionCounter,
        final String inspectionPlan )
    {
        return new InspPlanOperationByKeyFluentHelper(
            servicePath,
            "A_InspPlanOperation",
            inspectionPlanGroup,
            bOOOperationInternalID,
            inspectionPlanInternalVersion,
            bOOOpInternalVersionCounter,
            inspectionPlan);
    }

    @Override
    @Nonnull
    public InspPlanOperationCreateFluentHelper createInspPlanOperation(
        @Nonnull final InspPlanOperation inspPlanOperation )
    {
        return new InspPlanOperationCreateFluentHelper(servicePath, inspPlanOperation, "A_InspPlanOperation");
    }

    @Override
    @Nonnull
    public InspPlanOperationUpdateFluentHelper updateInspPlanOperation(
        @Nonnull final InspPlanOperation inspPlanOperation )
    {
        return new InspPlanOperationUpdateFluentHelper(servicePath, inspPlanOperation, "A_InspPlanOperation");
    }

    @Override
    @Nonnull
    public InspPlanOperationDeleteFluentHelper deleteInspPlanOperation(
        @Nonnull final InspPlanOperation inspPlanOperation )
    {
        return new InspPlanOperationDeleteFluentHelper(servicePath, inspPlanOperation, "A_InspPlanOperation");
    }

    @Override
    @Nonnull
    public InspPlanOpPRTFluentHelper getAllInspPlanOpPRT()
    {
        return new InspPlanOpPRTFluentHelper(servicePath, "A_InspPlanOpPRT");
    }

    @Override
    @Nonnull
    public InspPlanOpPRTByKeyFluentHelper getInspPlanOpPRTByKey(
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspectionPlanInternalVersion,
        final String bOOOpInternalVersionCounter,
        final String bOOOperationInternalID,
        final String bOOOperationPRTInternalID )
    {
        return new InspPlanOpPRTByKeyFluentHelper(
            servicePath,
            "A_InspPlanOpPRT",
            inspectionPlanGroup,
            inspectionPlan,
            inspectionPlanInternalVersion,
            bOOOpInternalVersionCounter,
            bOOOperationInternalID,
            bOOOperationPRTInternalID);
    }

    @Override
    @Nonnull
    public InspPlanOpPRTCreateFluentHelper createInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT )
    {
        return new InspPlanOpPRTCreateFluentHelper(servicePath, inspPlanOpPRT, "A_InspPlanOpPRT");
    }

    @Override
    @Nonnull
    public InspPlanOpPRTUpdateFluentHelper updateInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT )
    {
        return new InspPlanOpPRTUpdateFluentHelper(servicePath, inspPlanOpPRT, "A_InspPlanOpPRT");
    }

    @Override
    @Nonnull
    public InspPlanOpPRTDeleteFluentHelper deleteInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT )
    {
        return new InspPlanOpPRTDeleteFluentHelper(servicePath, inspPlanOpPRT, "A_InspPlanOpPRT");
    }

}
