/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.batch.DefaultIntelligentProductProposalServiceBatch;

/**
 * <p>
 *
 * In this API, you can retrieve product and quantity proposals. Apply any of the filters provided or retrieve all
 * existing data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/73/122fae9acf4206a29b3ce0932d72d2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INTELLIGENTPRODUCTPROPOSAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INTELLIGENTPRODUCTPROPOSAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Intelligent Product Proposal Integration(SAP_COM_0718)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultIntelligentProductProposalService" )
@Deprecated
public class DefaultIntelligentProductProposalService implements IntelligentProductProposalService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link IntelligentProductProposalService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultIntelligentProductProposalService()
    {
        servicePath = IntelligentProductProposalService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultIntelligentProductProposalService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultIntelligentProductProposalService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultIntelligentProductProposalService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultIntelligentProductProposalServiceBatch batch()
    {
        return new DefaultIntelligentProductProposalServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesDocumentProposalItemFluentHelper getAllSalesDocumentProposalItem()
    {
        return new SalesDocumentProposalItemFluentHelper(servicePath, "A_SalesDocumentProposalItem");
    }

    @Override
    @Nonnull
    public SalesDocumentProposalItemByKeyFluentHelper getSalesDocumentProposalItemByKey(
        final String salesOrganization,
        final String distributionChannel,
        final String organizationDivision,
        final String salesGroup,
        final String salesOffice,
        final String soldToParty,
        final String salesDocumentType )
    {
        return new SalesDocumentProposalItemByKeyFluentHelper(
            servicePath,
            "A_SalesDocumentProposalItem",
            salesOrganization,
            distributionChannel,
            organizationDivision,
            salesGroup,
            salesOffice,
            soldToParty,
            salesDocumentType);
    }

}
