/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.GetAttachmentLinksFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.batch.DefaultJointVentureBillingServiceBatch;

/**
 * <p>
 * The service enables you to retrieve list of billing files generated for a Joint Venture Partner. This list would
 * provide details on key attributes which would be required to fetch attachments using the Attachment Reuse Service.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d9/c2f5bdb8e449ac95686f00a9e0f676/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_JVA_BILLING_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_JVA_BILLING_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Joint Venture Partner Billing Files Integration(SAP_COM_0381)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3F7'>Joint Venture Accounting(3F7)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Joint Venture Billing - Read</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultJointVentureBillingService" )
@Deprecated
public class DefaultJointVentureBillingService implements JointVentureBillingService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link JointVentureBillingService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultJointVentureBillingService()
    {
        servicePath = JointVentureBillingService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultJointVentureBillingService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultJointVentureBillingService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultJointVentureBillingService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultJointVentureBillingServiceBatch batch()
    {
        return new DefaultJointVentureBillingServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public GetAttachmentLinksFluentHelper getAttachmentLinks(
        @Nonnull final String companyCode,
        @Nonnull final String fiscalYear,
        @Nonnull final String fiscalPeriod,
        @Nullable final String jointVenturePartner )
    {
        return new GetAttachmentLinksFluentHelper(
            servicePath,
            companyCode,
            fiscalYear,
            fiscalPeriod,
            jointVenturePartner);
    }

}
