/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.GLAccountInChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.GLAccountInChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.ProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.ProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.batch.DefaultJournalEntryItemServiceBatch;

/**
 * <p>
 *
 * The service contains journal entry items and master data of the referenced company code, cost center, profit center.
 * This API call is based on the OData protocol, and can be consumed in Fiori apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c2/e849c5ff5341388dff293e07a4549d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_JOURNALENTRYITEMBASIC_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_JOURNALENTRYITEMBASIC_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Journal Entry</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultJournalEntryItemService" )
@Deprecated
public class DefaultJournalEntryItemService implements JournalEntryItemService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link JournalEntryItemService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultJournalEntryItemService()
    {
        servicePath = JournalEntryItemService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultJournalEntryItemService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultJournalEntryItemService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultJournalEntryItemService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultJournalEntryItemServiceBatch batch()
    {
        return new DefaultJournalEntryItemServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CompanyCodeFluentHelper getAllCompanyCode()
    {
        return new CompanyCodeFluentHelper(servicePath, "A_CompanyCode");
    }

    @Override
    @Nonnull
    public CompanyCodeByKeyFluentHelper getCompanyCodeByKey( final String companyCode )
    {
        return new CompanyCodeByKeyFluentHelper(servicePath, "A_CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    public CostCenterFluentHelper getAllCostCenter()
    {
        return new CostCenterFluentHelper(servicePath, "A_CostCenter");
    }

    @Override
    @Nonnull
    public
        CostCenterByKeyFluentHelper
        getCostCenterByKey( final String controllingArea, final String costCenter, final LocalDateTime validityEndDate )
    {
        return new CostCenterByKeyFluentHelper(
            servicePath,
            "A_CostCenter",
            controllingArea,
            costCenter,
            validityEndDate);
    }

    @Override
    @Nonnull
    public GLAccountInChartOfAccountsFluentHelper getAllGLAccountInChartOfAccounts()
    {
        return new GLAccountInChartOfAccountsFluentHelper(servicePath, "A_GLAccountInChartOfAccounts");
    }

    @Override
    @Nonnull
    public
        GLAccountInChartOfAccountsByKeyFluentHelper
        getGLAccountInChartOfAccountsByKey( final String chartOfAccounts, final String gLAccount )
    {
        return new GLAccountInChartOfAccountsByKeyFluentHelper(
            servicePath,
            "A_GLAccountInChartOfAccounts",
            chartOfAccounts,
            gLAccount);
    }

    @Override
    @Nonnull
    public JournalEntryItemBasicFluentHelper getAllJournalEntryItemBasic()
    {
        return new JournalEntryItemBasicFluentHelper(servicePath, "A_JournalEntryItemBasic");
    }

    @Override
    @Nonnull
    public JournalEntryItemBasicByKeyFluentHelper getJournalEntryItemBasicByKey( final String iD )
    {
        return new JournalEntryItemBasicByKeyFluentHelper(servicePath, "A_JournalEntryItemBasic", iD);
    }

    @Override
    @Nonnull
    public ProfitCenterFluentHelper getAllProfitCenter()
    {
        return new ProfitCenterFluentHelper(servicePath, "A_ProfitCenter");
    }

    @Override
    @Nonnull
    public ProfitCenterByKeyFluentHelper getProfitCenterByKey(
        final String controllingArea,
        final String profitCenter,
        final LocalDateTime validityEndDate )
    {
        return new ProfitCenterByKeyFluentHelper(
            servicePath,
            "A_ProfitCenter",
            controllingArea,
            profitCenter,
            validityEndDate);
    }

}
