/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.batch.DefaultJustInTimeCallServiceBatch;

/**
 * <p>
 *
 * JIT processing is a common practice in manufacturing industries for efficient demand-driven production and logistics
 * across supply chains. Just-In-Time Supply to Customer covers JIT processes from the perspective of a supplier. This
 * service enables you to read, create, and update JIT calls. For example, you can use this service to create a JIT call
 * or to allocate or delete component materials..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e6/26b94c627e4f30b5b64b657dafbee4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_JIT_CALL_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_JIT_CALL_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Just In Time Inbound Integration(SAP_COM_0168)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2EM'>Just-In-Time Supply to Customer(2EM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Just In Time Call</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultJustInTimeCallService" )
@Deprecated
public class DefaultJustInTimeCallService implements JustInTimeCallService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link JustInTimeCallService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultJustInTimeCallService()
    {
        servicePath = JustInTimeCallService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultJustInTimeCallService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultJustInTimeCallService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultJustInTimeCallService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultJustInTimeCallServiceBatch batch()
    {
        return new DefaultJustInTimeCallServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public JITCallCompGrpFluentHelper getAllJITCallCompGrp()
    {
        return new JITCallCompGrpFluentHelper(servicePath, "A_JITCallCompGrp");
    }

    @Override
    @Nonnull
    public
        JITCallCompGrpByKeyFluentHelper
        getJITCallCompGrpByKey( final String internalJITCallNumber, final String compGrpNumber )
    {
        return new JITCallCompGrpByKeyFluentHelper(
            servicePath,
            "A_JITCallCompGrp",
            internalJITCallNumber,
            compGrpNumber);
    }

    @Override
    @Nonnull
    public JITCallCompGrpCreateFluentHelper createJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp )
    {
        return new JITCallCompGrpCreateFluentHelper(servicePath, jITCallCompGrp, "A_JITCallCompGrp");
    }

    @Override
    @Nonnull
    public JITCallCompGrpUpdateFluentHelper updateJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp )
    {
        return new JITCallCompGrpUpdateFluentHelper(servicePath, jITCallCompGrp, "A_JITCallCompGrp");
    }

    @Override
    @Nonnull
    public JITCallCompMatlFluentHelper getAllJITCallCompMatl()
    {
        return new JITCallCompMatlFluentHelper(servicePath, "A_JITCallCompMatl");
    }

    @Override
    @Nonnull
    public JITCallCompMatlByKeyFluentHelper getJITCallCompMatlByKey(
        final String internalJITCallNumber,
        final String compGrpNumber,
        final String jITCallItemNumber )
    {
        return new JITCallCompMatlByKeyFluentHelper(
            servicePath,
            "A_JITCallCompMatl",
            internalJITCallNumber,
            compGrpNumber,
            jITCallItemNumber);
    }

    @Override
    @Nonnull
    public JITCallCompMatlCreateFluentHelper createJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl )
    {
        return new JITCallCompMatlCreateFluentHelper(servicePath, jITCallCompMatl, "A_JITCallCompMatl");
    }

    @Override
    @Nonnull
    public JITCallCompMatlUpdateFluentHelper updateJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl )
    {
        return new JITCallCompMatlUpdateFluentHelper(servicePath, jITCallCompMatl, "A_JITCallCompMatl");
    }

    @Override
    @Nonnull
    public JITCallCompMatlDeleteFluentHelper deleteJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl )
    {
        return new JITCallCompMatlDeleteFluentHelper(servicePath, jITCallCompMatl, "A_JITCallCompMatl");
    }

    @Override
    @Nonnull
    public JITCallHeaderFluentHelper getAllJITCallHeader()
    {
        return new JITCallHeaderFluentHelper(servicePath, "A_JITCallHeader");
    }

    @Override
    @Nonnull
    public JITCallHeaderByKeyFluentHelper getJITCallHeaderByKey( final String internalJITCallNumber )
    {
        return new JITCallHeaderByKeyFluentHelper(servicePath, "A_JITCallHeader", internalJITCallNumber);
    }

    @Override
    @Nonnull
    public JITCallHeaderCreateFluentHelper createJITCallHeader( @Nonnull final JITCallHeader jITCallHeader )
    {
        return new JITCallHeaderCreateFluentHelper(servicePath, jITCallHeader, "A_JITCallHeader");
    }

    @Override
    @Nonnull
    public JITCallHeaderUpdateFluentHelper updateJITCallHeader( @Nonnull final JITCallHeader jITCallHeader )
    {
        return new JITCallHeaderUpdateFluentHelper(servicePath, jITCallHeader, "A_JITCallHeader");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompGrpFluentHelper getAllJITCallRefTextCompGrp()
    {
        return new JITCallRefTextCompGrpFluentHelper(servicePath, "A_JITCallRefTextCompGrp");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompGrpByKeyFluentHelper getJITCallRefTextCompGrpByKey(
        final String internalJITCallNumber,
        final String compGrpNumber,
        final String jITRefType )
    {
        return new JITCallRefTextCompGrpByKeyFluentHelper(
            servicePath,
            "A_JITCallRefTextCompGrp",
            internalJITCallNumber,
            compGrpNumber,
            jITRefType);
    }

    @Override
    @Nonnull
    public JITCallRefTextCompGrpCreateFluentHelper createJITCallRefTextCompGrp(
        @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp )
    {
        return new JITCallRefTextCompGrpCreateFluentHelper(
            servicePath,
            jITCallRefTextCompGrp,
            "A_JITCallRefTextCompGrp");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompGrpUpdateFluentHelper updateJITCallRefTextCompGrp(
        @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp )
    {
        return new JITCallRefTextCompGrpUpdateFluentHelper(
            servicePath,
            jITCallRefTextCompGrp,
            "A_JITCallRefTextCompGrp");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompGrpDeleteFluentHelper deleteJITCallRefTextCompGrp(
        @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp )
    {
        return new JITCallRefTextCompGrpDeleteFluentHelper(
            servicePath,
            jITCallRefTextCompGrp,
            "A_JITCallRefTextCompGrp");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompMatlFluentHelper getAllJITCallRefTextCompMatl()
    {
        return new JITCallRefTextCompMatlFluentHelper(servicePath, "A_JITCallRefTextCompMatl");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompMatlByKeyFluentHelper getJITCallRefTextCompMatlByKey(
        final String internalJITCallNumber,
        final String compGrpNumber,
        final String jITCallItemNumber,
        final String jITRefType )
    {
        return new JITCallRefTextCompMatlByKeyFluentHelper(
            servicePath,
            "A_JITCallRefTextCompMatl",
            internalJITCallNumber,
            compGrpNumber,
            jITCallItemNumber,
            jITRefType);
    }

    @Override
    @Nonnull
    public JITCallRefTextCompMatlCreateFluentHelper createJITCallRefTextCompMatl(
        @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl )
    {
        return new JITCallRefTextCompMatlCreateFluentHelper(
            servicePath,
            jITCallRefTextCompMatl,
            "A_JITCallRefTextCompMatl");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompMatlUpdateFluentHelper updateJITCallRefTextCompMatl(
        @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl )
    {
        return new JITCallRefTextCompMatlUpdateFluentHelper(
            servicePath,
            jITCallRefTextCompMatl,
            "A_JITCallRefTextCompMatl");
    }

    @Override
    @Nonnull
    public JITCallRefTextCompMatlDeleteFluentHelper deleteJITCallRefTextCompMatl(
        @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl )
    {
        return new JITCallRefTextCompMatlDeleteFluentHelper(
            servicePath,
            jITCallRefTextCompMatl,
            "A_JITCallRefTextCompMatl");
    }

    @Override
    @Nonnull
    public JITCallRefTextHdrFluentHelper getAllJITCallRefTextHdr()
    {
        return new JITCallRefTextHdrFluentHelper(servicePath, "A_JITCallRefTextHdr");
    }

    @Override
    @Nonnull
    public
        JITCallRefTextHdrByKeyFluentHelper
        getJITCallRefTextHdrByKey( final String internalJITCallNumber, final String jITRefType )
    {
        return new JITCallRefTextHdrByKeyFluentHelper(
            servicePath,
            "A_JITCallRefTextHdr",
            internalJITCallNumber,
            jITRefType);
    }

    @Override
    @Nonnull
    public JITCallRefTextHdrCreateFluentHelper createJITCallRefTextHdr(
        @Nonnull final JITCallRefTextHdr jITCallRefTextHdr )
    {
        return new JITCallRefTextHdrCreateFluentHelper(servicePath, jITCallRefTextHdr, "A_JITCallRefTextHdr");
    }

    @Override
    @Nonnull
    public JITCallRefTextHdrUpdateFluentHelper updateJITCallRefTextHdr(
        @Nonnull final JITCallRefTextHdr jITCallRefTextHdr )
    {
        return new JITCallRefTextHdrUpdateFluentHelper(servicePath, jITCallRefTextHdr, "A_JITCallRefTextHdr");
    }

    @Override
    @Nonnull
    public JITCallRefTextHdrDeleteFluentHelper deleteJITCallRefTextHdr(
        @Nonnull final JITCallRefTextHdr jITCallRefTextHdr )
    {
        return new JITCallRefTextHdrDeleteFluentHelper(servicePath, jITCallRefTextHdr, "A_JITCallRefTextHdr");
    }

}
