/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.AddEventDrivenKanbanContainerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanContainerLockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanContainerStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanControlCycleLifeCycleStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.WithdrawQuantityFromControlCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.WithdrawQuantityFromKanbanContainerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.batch.DefaultKanbanControlCycleV2ServiceBatch;

/**
 * <p>
 *
 * The kanban OData API enables you to create and retrieve kanban control cycles and their kanban container data.
 * Additionally, it is possible to change control cycles, to set the status both on control cycle and on container
 * level, and to lock/unlock containers. Furthermore, you can add new containers for event-driven kanban control cycles
 * and you can report the withdrawal out of one or more containers.
 *
 * The service is based on the OData protocol and can be consumed by external systems and user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a2/71dc21bc514d2b80701e88409533f9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_KANBAN_CONTROL_CYCLE_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_KANBAN_CONTROL_CYCLE_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Kanban Control Cycle Integration(SAP_COM_0330)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E3'>Material Replenishment with Kanban - External
 * Procurement(1E3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4B3'>Material Replenishment with Kanban -
 * In-House Production(4B3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4B4'>Material Replenishment with Kanban
 * - Stock Transfer(4B4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Kanban Control Cycle</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultKanbanControlCycleV2Service" )
@Deprecated
public class DefaultKanbanControlCycleV2Service implements KanbanControlCycleV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link KanbanControlCycleV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultKanbanControlCycleV2Service()
    {
        servicePath = KanbanControlCycleV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultKanbanControlCycleV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultKanbanControlCycleV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultKanbanControlCycleV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultKanbanControlCycleV2ServiceBatch batch()
    {
        return new DefaultKanbanControlCycleV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public KanbanContainerFluentHelper getAllKanbanContainer()
    {
        return new KanbanContainerFluentHelper(servicePath, "A_KanbanContainer");
    }

    @Override
    @Nonnull
    public KanbanContainerByKeyFluentHelper getKanbanContainerByKey( final String kanbanContainer )
    {
        return new KanbanContainerByKeyFluentHelper(servicePath, "A_KanbanContainer", kanbanContainer);
    }

    @Override
    @Nonnull
    public KanbanContainerDeliveryAddrFluentHelper getAllKanbanContainerDeliveryAddr()
    {
        return new KanbanContainerDeliveryAddrFluentHelper(servicePath, "A_KanbanContainerDeliveryAddr");
    }

    @Override
    @Nonnull
    public KanbanContainerDeliveryAddrByKeyFluentHelper getKanbanContainerDeliveryAddrByKey(
        final String kanbanControlCycle )
    {
        return new KanbanContainerDeliveryAddrByKeyFluentHelper(
            servicePath,
            "A_KanbanContainerDeliveryAddr",
            kanbanControlCycle);
    }

    @Override
    @Nonnull
    public KanbanControlCycleFluentHelper getAllKanbanControlCycle()
    {
        return new KanbanControlCycleFluentHelper(servicePath, "A_KanbanControlCycle");
    }

    @Override
    @Nonnull
    public KanbanControlCycleByKeyFluentHelper getKanbanControlCycleByKey( final String kanbanControlCycle )
    {
        return new KanbanControlCycleByKeyFluentHelper(servicePath, "A_KanbanControlCycle", kanbanControlCycle);
    }

    @Override
    @Nonnull
    public KanbanControlCycleCreateFluentHelper createKanbanControlCycle(
        @Nonnull final KanbanControlCycle kanbanControlCycle )
    {
        return new KanbanControlCycleCreateFluentHelper(servicePath, kanbanControlCycle, "A_KanbanControlCycle");
    }

    @Override
    @Nonnull
    public KanbanControlCycleUpdateFluentHelper updateKanbanControlCycle(
        @Nonnull final KanbanControlCycle kanbanControlCycle )
    {
        return new KanbanControlCycleUpdateFluentHelper(servicePath, kanbanControlCycle, "A_KanbanControlCycle");
    }

    @Override
    @Nonnull
    public KanbanControlCycleDeleteFluentHelper deleteKanbanControlCycle(
        @Nonnull final KanbanControlCycle kanbanControlCycle )
    {
        return new KanbanControlCycleDeleteFluentHelper(servicePath, kanbanControlCycle, "A_KanbanControlCycle");
    }

    @Override
    @Nonnull
    public KanbanCtnDetailedQtyFluentHelper getAllKanbanCtnDetailedQty()
    {
        return new KanbanCtnDetailedQtyFluentHelper(servicePath, "A_KanbanCtnDetailedQty");
    }

    @Override
    @Nonnull
    public
        KanbanCtnDetailedQtyByKeyFluentHelper
        getKanbanCtnDetailedQtyByKey( final String kanbanContainer, final String batch )
    {
        return new KanbanCtnDetailedQtyByKeyFluentHelper(servicePath, "A_KanbanCtnDetailedQty", kanbanContainer, batch);
    }

    @Override
    @Nonnull
    public KanbanDeliveryFluentHelper getAllKanbanDelivery()
    {
        return new KanbanDeliveryFluentHelper(servicePath, "A_KanbanDelivery");
    }

    @Override
    @Nonnull
    public KanbanDeliveryByKeyFluentHelper getKanbanDeliveryByKey( final String kanbanContainer )
    {
        return new KanbanDeliveryByKeyFluentHelper(servicePath, "A_KanbanDelivery", kanbanContainer);
    }

    @Override
    @Nonnull
    public SetKanbanContainerStatusFluentHelper setKanbanContainerStatus(
        @Nonnull final String kanbanContainer,
        @Nullable final String kanbanContainerStatus,
        @Nullable final BigDecimal actualQuantityInUnitOfEntry,
        @Nullable final String unitOfEntry,
        @Nullable final String batch,
        @Nullable final ZonedDateTime kanbanCtnStatusChangeDateTime,
        @Nullable final String deliveryNote )
    {
        return new SetKanbanContainerStatusFluentHelper(
            servicePath,
            kanbanContainer,
            kanbanContainerStatus,
            actualQuantityInUnitOfEntry,
            unitOfEntry,
            batch,
            kanbanCtnStatusChangeDateTime,
            deliveryNote);
    }

    @Override
    @Nonnull
    public
        SetKanbanContainerLockFluentHelper
        setKanbanContainerLock( @Nonnull final String kanbanContainer, @Nonnull final Boolean isLocked )
    {
        return new SetKanbanContainerLockFluentHelper(servicePath, kanbanContainer, isLocked);
    }

    @Override
    @Nonnull
    public SetKanbanControlCycleLifeCycleStatusFluentHelper setKanbanControlCycleLifeCycleStatus(
        @Nonnull final String kanbanControlCycle,
        @Nonnull final String kanbanCtrlCycleLifeCycleStatus )
    {
        return new SetKanbanControlCycleLifeCycleStatusFluentHelper(
            servicePath,
            kanbanControlCycle,
            kanbanCtrlCycleLifeCycleStatus);
    }

    @Override
    @Nonnull
    public AddEventDrivenKanbanContainerFluentHelper addEventDrivenKanbanContainer(
        @Nonnull final String kanbanControlCycle,
        @Nullable final BigDecimal requestedQuantityInBaseUnit,
        @Nullable final ZonedDateTime requestedDeliveryDateTime,
        @Nullable final String packingInstruction,
        @Nullable final Short numberOfLoadCarriers )
    {
        return new AddEventDrivenKanbanContainerFluentHelper(
            servicePath,
            kanbanControlCycle,
            requestedQuantityInBaseUnit,
            requestedDeliveryDateTime,
            packingInstruction,
            numberOfLoadCarriers);
    }

    @Override
    @Nonnull
    public WithdrawQuantityFromControlCycleFluentHelper withdrawQuantityFromControlCycle(
        @Nonnull final String kanbanControlCycle,
        @Nonnull final BigDecimal kanbanCtrlCycWthdrwlQtyInBsUnt )
    {
        return new WithdrawQuantityFromControlCycleFluentHelper(
            servicePath,
            kanbanControlCycle,
            kanbanCtrlCycWthdrwlQtyInBsUnt);
    }

    @Override
    @Nonnull
    public WithdrawQuantityFromKanbanContainerFluentHelper withdrawQuantityFromKanbanContainer(
        @Nonnull final String kanbanContainer,
        @Nonnull final BigDecimal kanbanCtnWithdrawalQtyInBsUnt )
    {
        return new WithdrawQuantityFromKanbanContainerFluentHelper(
            servicePath,
            kanbanContainer,
            kanbanCtnWithdrawalQtyInBsUnt);
    }

}
