/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.batch.DefaultLedgerServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve ledgers, their properties like leading ledger and their names in the respective
 * language..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/61/3fc05ef3cc4505a12a7f1d6b49cc0d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEDGER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEDGER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Ledger</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLedgerService" )
@Deprecated
public class DefaultLedgerService implements LedgerService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LedgerService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultLedgerService()
    {
        servicePath = LedgerService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLedgerService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLedgerService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLedgerService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLedgerServiceBatch batch()
    {
        return new DefaultLedgerServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LedgerFluentHelper getAllLedger()
    {
        return new LedgerFluentHelper(servicePath, "A_Ledger");
    }

    @Override
    @Nonnull
    public LedgerByKeyFluentHelper getLedgerByKey( final String ledger )
    {
        return new LedgerByKeyFluentHelper(servicePath, "A_Ledger", ledger);
    }

    @Override
    @Nonnull
    public LedgerTextFluentHelper getAllLedgerText()
    {
        return new LedgerTextFluentHelper(servicePath, "A_LedgerText");
    }

    @Override
    @Nonnull
    public LedgerTextByKeyFluentHelper getLedgerTextByKey( final String ledger, final String language )
    {
        return new LedgerTextByKeyFluentHelper(servicePath, "A_LedgerText", ledger, language);
    }

}
