/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.batch.DefaultLegalCategorieServiceBatch;

/**
 * <p>
 *
 * Category is one of the objects used to categorize Contexts, Legal Transactions, Templates and Text Blocks. This
 * service contains legal categories and legal category text nodes. Using this service, you can read the legal
 * categories created in the Categories application..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/11/df771f86d34a54b3eb2fb1ce146752/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGAL_CATEGORY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGAL_CATEGORY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Contract Management and Assembly Integration(SAP_COM_0437), Procurement - Supplier Quotation
 * Management Integration(SAP_COM_0760), Enterprise Contract Management - Hub System Integration(SAP_COM_0809)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2OQ'>Integration to SAP Enterprise Contract Assembly(2OQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Category</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLegalCategorieService" )
@Deprecated
public class DefaultLegalCategorieService implements LegalCategorieService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LegalCategorieService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultLegalCategorieService()
    {
        servicePath = LegalCategorieService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLegalCategorieService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLegalCategorieService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLegalCategorieService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLegalCategorieServiceBatch batch()
    {
        return new DefaultLegalCategorieServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LegalCategoryFluentHelper getAllLegalCategory()
    {
        return new LegalCategoryFluentHelper(servicePath, "A_LegalCategory");
    }

    @Override
    @Nonnull
    public LegalCategoryByKeyFluentHelper getLegalCategoryByKey( final String lglCntntMCategory )
    {
        return new LegalCategoryByKeyFluentHelper(servicePath, "A_LegalCategory", lglCntntMCategory);
    }

    @Override
    @Nonnull
    public LegalCategoryTextFluentHelper getAllLegalCategoryText()
    {
        return new LegalCategoryTextFluentHelper(servicePath, "A_LegalCategoryText");
    }

    @Override
    @Nonnull
    public
        LegalCategoryTextByKeyFluentHelper
        getLegalCategoryTextByKey( final String lglCntntMCategory, final String language )
    {
        return new LegalCategoryTextByKeyFluentHelper(servicePath, "A_LegalCategoryText", lglCntntMCategory, language);
    }

}
