/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.batch.DefaultLegalDocumentAccessLevelServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound service is based on the OData protocol and can be consumed in integration scenarios or other
 * user interfaces. Access level is an attribute used for authorization checks in Enterprise Contract Management. This
 * service contains access level and access level text nodes. Using this service, you can read the access levels
 * maintained in its configuration..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/13/d3a2eeb9d9431fac2b6173d0d669b2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/A_LGLCNTNTMACCESSLVL_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>A_LGLCNTNTMACCESSLVL_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Contract Management and Assembly Integration(SAP_COM_0437)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2OQ'>Integration to SAP Enterprise Contract Assembly(2OQ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Access Level</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLegalDocumentAccessLevelService" )
@Deprecated
public class DefaultLegalDocumentAccessLevelService implements LegalDocumentAccessLevelService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LegalDocumentAccessLevelService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultLegalDocumentAccessLevelService()
    {
        servicePath = LegalDocumentAccessLevelService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLegalDocumentAccessLevelService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentAccessLevelService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLegalDocumentAccessLevelService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentAccessLevelServiceBatch batch()
    {
        return new DefaultLegalDocumentAccessLevelServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LglCntntMAccessLvlFluentHelper getAllLglCntntMAccessLvl()
    {
        return new LglCntntMAccessLvlFluentHelper(servicePath, "A_LglCntntMAccessLvl");
    }

    @Override
    @Nonnull
    public LglCntntMAccessLvlByKeyFluentHelper getLglCntntMAccessLvlByKey( final String lglCntntMAccessLvl )
    {
        return new LglCntntMAccessLvlByKeyFluentHelper(servicePath, "A_LglCntntMAccessLvl", lglCntntMAccessLvl);
    }

    @Override
    @Nonnull
    public LglCntntMAccessLvlTextFluentHelper getAllLglCntntMAccessLvlText()
    {
        return new LglCntntMAccessLvlTextFluentHelper(servicePath, "A_LglCntntMAccessLvlText");
    }

    @Override
    @Nonnull
    public
        LglCntntMAccessLvlTextByKeyFluentHelper
        getLglCntntMAccessLvlTextByKey( final String lglCntntMAccessLvl, final String language )
    {
        return new LglCntntMAccessLvlTextByKeyFluentHelper(
            servicePath,
            "A_LglCntntMAccessLvlText",
            lglCntntMAccessLvl,
            language);
    }

}
