/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.batch.DefaultLegalDocumentContentTypeServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound service is based on the OData protocol and helps you to read the content types through an
 * API call. Content types describe the purpose of the document, for example &#39;Amendment&#39; or &#39;Master
 * Agreement&#39;. This service contains legal document content type and content type text nodes. Using this service,
 * you can read the content type maintained in the configuration..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e3/4f03bcc967468cb7e4e7f82ddd2476/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGAL_CONTENT_TYPE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGAL_CONTENT_TYPE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Contract Management and Assembly Integration(SAP_COM_0437), Procurement - Supplier Quotation
 * Management Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2OQ'>Integration to SAP Enterprise Contract Assembly(2OQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Content Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLegalDocumentContentTypeService" )
@Deprecated
public class DefaultLegalDocumentContentTypeService implements LegalDocumentContentTypeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LegalDocumentContentTypeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultLegalDocumentContentTypeService()
    {
        servicePath = LegalDocumentContentTypeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLegalDocumentContentTypeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentContentTypeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLegalDocumentContentTypeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentContentTypeServiceBatch batch()
    {
        return new DefaultLegalDocumentContentTypeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LglCntntMDocContentTypeFluentHelper getAllLglCntntMDocContentType()
    {
        return new LglCntntMDocContentTypeFluentHelper(servicePath, "A_LglCntntMDocContentType");
    }

    @Override
    @Nonnull
    public LglCntntMDocContentTypeByKeyFluentHelper getLglCntntMDocContentTypeByKey(
        final String lglCntntMDocContentType )
    {
        return new LglCntntMDocContentTypeByKeyFluentHelper(
            servicePath,
            "A_LglCntntMDocContentType",
            lglCntntMDocContentType);
    }

    @Override
    @Nonnull
    public LglCntntMDocContentTypeTextFluentHelper getAllLglCntntMDocContentTypeText()
    {
        return new LglCntntMDocContentTypeTextFluentHelper(servicePath, "A_LglCntntMDocContentTypeText");
    }

    @Override
    @Nonnull
    public
        LglCntntMDocContentTypeTextByKeyFluentHelper
        getLglCntntMDocContentTypeTextByKey( final String lglCntntMDocContentType, final String language )
    {
        return new LglCntntMDocContentTypeTextByKeyFluentHelper(
            servicePath,
            "A_LglCntntMDocContentTypeText",
            lglCntntMDocContentType,
            language);
    }

}
