/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.SetLegalDocumentToAcceptedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.batch.DefaultLegalDocumentServiceBatch;

/**
 * <p>
 *
 * Legal documents are instances of legal content which are tailored to a specific legal transaction. The service
 * contains legal document and legal document stamp nodes. The information sent in the request as a payload is used when
 * creating a legal document, including appropriate checks for restricted values and authorizations. Once the legal
 * document is created, the legal document ID is sent in the response with the data included in the legal document. If
 * there are any issues when the legal document is created, the system displays error messages in the response. Note
 * that to create or change the content of the legal document you need to use the Attachment Service that is also
 * published in the SAP API Business Hub. For more information, refer to the business documentation of this API..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/76/617b87de1c40cb876e874ea78981a2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGAL_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGAL_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Legal Document Integration(SAP_COM_0178), Procurement - Supplier Quotation Management
 * Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLegalDocumentService" )
@Deprecated
public class DefaultLegalDocumentService implements LegalDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LegalDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultLegalDocumentService()
    {
        servicePath = LegalDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLegalDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLegalDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentServiceBatch batch()
    {
        return new DefaultLegalDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LegalDocumentFluentHelper getAllLegalDocument()
    {
        return new LegalDocumentFluentHelper(servicePath, "A_LegalDocument");
    }

    @Override
    @Nonnull
    public LegalDocumentByKeyFluentHelper getLegalDocumentByKey( final UUID lglCntntMDocumentUUID )
    {
        return new LegalDocumentByKeyFluentHelper(servicePath, "A_LegalDocument", lglCntntMDocumentUUID);
    }

    @Override
    @Nonnull
    public LegalDocumentCreateFluentHelper createLegalDocument( @Nonnull final LegalDocument legalDocument )
    {
        return new LegalDocumentCreateFluentHelper(servicePath, legalDocument, "A_LegalDocument");
    }

    @Override
    @Nonnull
    public LglCntntMDocCategoryFluentHelper getAllLglCntntMDocCategory()
    {
        return new LglCntntMDocCategoryFluentHelper(servicePath, "A_LglCntntMDocCategory");
    }

    @Override
    @Nonnull
    public LglCntntMDocCategoryByKeyFluentHelper getLglCntntMDocCategoryByKey( final UUID lglCntntMDocCategoryUUID )
    {
        return new LglCntntMDocCategoryByKeyFluentHelper(
            servicePath,
            "A_LglCntntMDocCategory",
            lglCntntMDocCategoryUUID);
    }

    @Override
    @Nonnull
    public LglCntntMDocCategoryCreateFluentHelper createLglCntntMDocCategory(
        @Nonnull final LglCntntMDocCategory lglCntntMDocCategory )
    {
        return new LglCntntMDocCategoryCreateFluentHelper(servicePath, lglCntntMDocCategory, "A_LglCntntMDocCategory");
    }

    @Override
    @Nonnull
    public LglCntntMDocParCategoryFluentHelper getAllLglCntntMDocParCategory()
    {
        return new LglCntntMDocParCategoryFluentHelper(servicePath, "A_LglCntntMDocParCategory");
    }

    @Override
    @Nonnull
    public LglCntntMDocParCategoryByKeyFluentHelper getLglCntntMDocParCategoryByKey( final UUID lglCntntMDocParCatUUID )
    {
        return new LglCntntMDocParCategoryByKeyFluentHelper(
            servicePath,
            "A_LglCntntMDocParCategory",
            lglCntntMDocParCatUUID);
    }

    @Override
    @Nonnull
    public LglCntntMDocParCategoryCreateFluentHelper createLglCntntMDocParCategory(
        @Nonnull final LglCntntMDocParCategory lglCntntMDocParCategory )
    {
        return new LglCntntMDocParCategoryCreateFluentHelper(
            servicePath,
            lglCntntMDocParCategory,
            "A_LglCntntMDocParCategory");
    }

    @Override
    @Nonnull
    public LglDocStampFluentHelper getAllLglDocStamp()
    {
        return new LglDocStampFluentHelper(servicePath, "A_LglDocStamp");
    }

    @Override
    @Nonnull
    public LglDocStampByKeyFluentHelper getLglDocStampByKey( final UUID lglCntntMDocumentStampUUID )
    {
        return new LglDocStampByKeyFluentHelper(servicePath, "A_LglDocStamp", lglCntntMDocumentStampUUID);
    }

    @Override
    @Nonnull
    public LglDocStampCreateFluentHelper createLglDocStamp( @Nonnull final LglDocStamp lglDocStamp )
    {
        return new LglDocStampCreateFluentHelper(servicePath, lglDocStamp, "A_LglDocStamp");
    }

    @Override
    @Nonnull
    public SetLegalDocumentToAcceptedFluentHelper setLegalDocumentToAccepted(
        @Nonnull final UUID lglCntntMDocumentUUID )
    {
        return new SetLegalDocumentToAcceptedFluentHelper(servicePath, lglCntntMDocumentUUID);
    }

}
