/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.batch.DefaultLegalDocumentStatusServiceBatch;

/**
 * <p>
 *
 * This service is based on the OData protocol and helps you to read the possible values of legal document status
 * through an API call. This describes the status of a legal document. For example, &#39;In Process&#39;,
 * &#39;Accepted&#39; and so on are the various statuses assigned to a legal document. This service contains legal
 * document status and legal document status text nodes. Using this service, you can read the legal document status type
 * maintained in the system. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/41/236bdf6d594cdc8c553e68c0a1b617/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGALDOCUMENTSTATUS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGALDOCUMENTSTATUS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Legal Document Integration(SAP_COM_0178)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Document Status</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLegalDocumentStatusService" )
@Deprecated
public class DefaultLegalDocumentStatusService implements LegalDocumentStatusService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LegalDocumentStatusService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultLegalDocumentStatusService()
    {
        servicePath = LegalDocumentStatusService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLegalDocumentStatusService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentStatusService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLegalDocumentStatusService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLegalDocumentStatusServiceBatch batch()
    {
        return new DefaultLegalDocumentStatusServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LegalDocumentStatusFluentHelper getAllLegalDocumentStatus()
    {
        return new LegalDocumentStatusFluentHelper(servicePath, "LegalDocumentStatus");
    }

    @Override
    @Nonnull
    public LegalDocumentStatusByKeyFluentHelper getLegalDocumentStatusByKey( final String internalDocumentStatus )
    {
        return new LegalDocumentStatusByKeyFluentHelper(servicePath, "LegalDocumentStatus", internalDocumentStatus);
    }

    @Override
    @Nonnull
    public LegalDocumentStatusTextFluentHelper getAllLegalDocumentStatusText()
    {
        return new LegalDocumentStatusTextFluentHelper(servicePath, "LegalDocumentStatusText");
    }

    @Override
    @Nonnull
    public
        LegalDocumentStatusTextByKeyFluentHelper
        getLegalDocumentStatusTextByKey( final String internalDocumentStatus, final String language )
    {
        return new LegalDocumentStatusTextByKeyFluentHelper(
            servicePath,
            "LegalDocumentStatusText",
            internalDocumentStatus,
            language);
    }

}
