/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.TerminateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.batch.DefaultLegalTransactionServiceBatch;

/**
 * <p>
 *
 * Legal Transactions are business objects that are used to manage the lifecycle of legal content. The service contains
 * legal transactions, categories, category groups, parent categories, dates, entities, external contacts, internal
 * contacts, linked objects, and relationships nodes. The information sent in the request as a payload, is used when
 * creating a legal transaction, including appropriate checks for restricted values and authorizations. Once the legal
 * transaction has been created, the legal transaction ID is sent in the response with the data included in the legal
 * transaction. If there are any issues when the legal transaction is created, the system displays error messages in the
 * response. Note that we support only deep create for the legal transaction node..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1f/6862d0c8734cc9aacfc2a7746ed6b7/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGAL_TRANSACTION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGAL_TRANSACTION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Legal Transaction Integration(SAP_COM_0140), Procurement - Supplier Quotation Management
 * Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Transaction</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLegalTransactionService" )
@Deprecated
public class DefaultLegalTransactionService implements LegalTransactionService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LegalTransactionService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultLegalTransactionService()
    {
        servicePath = LegalTransactionService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLegalTransactionService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLegalTransactionService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLegalTransactionService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLegalTransactionServiceBatch batch()
    {
        return new DefaultLegalTransactionServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LegalTransactionFluentHelper getAllLegalTransaction()
    {
        return new LegalTransactionFluentHelper(servicePath, "A_LegalTransaction");
    }

    @Override
    @Nonnull
    public LegalTransactionByKeyFluentHelper getLegalTransactionByKey( final UUID legalTransactionUUID )
    {
        return new LegalTransactionByKeyFluentHelper(servicePath, "A_LegalTransaction", legalTransactionUUID);
    }

    @Override
    @Nonnull
    public LegalTransactionCreateFluentHelper createLegalTransaction( @Nonnull final LegalTransaction legalTransaction )
    {
        return new LegalTransactionCreateFluentHelper(servicePath, legalTransaction, "A_LegalTransaction");
    }

    @Override
    @Nonnull
    public LegalTransactionUpdateFluentHelper updateLegalTransaction( @Nonnull final LegalTransaction legalTransaction )
    {
        return new LegalTransactionUpdateFluentHelper(servicePath, legalTransaction, "A_LegalTransaction");
    }

    @Override
    @Nonnull
    public LglTransCategoryFluentHelper getAllLglTransCategory()
    {
        return new LglTransCategoryFluentHelper(servicePath, "A_LglTransCategory");
    }

    @Override
    @Nonnull
    public LglTransCategoryByKeyFluentHelper getLglTransCategoryByKey( final UUID legalTransactionCategoryUUID )
    {
        return new LglTransCategoryByKeyFluentHelper(servicePath, "A_LglTransCategory", legalTransactionCategoryUUID);
    }

    @Override
    @Nonnull
    public LglTransCategoryGroupFluentHelper getAllLglTransCategoryGroup()
    {
        return new LglTransCategoryGroupFluentHelper(servicePath, "A_LglTransCategoryGroup");
    }

    @Override
    @Nonnull
    public LglTransCategoryGroupByKeyFluentHelper getLglTransCategoryGroupByKey(
        final UUID legalTransactionCatGroupUUID )
    {
        return new LglTransCategoryGroupByKeyFluentHelper(
            servicePath,
            "A_LglTransCategoryGroup",
            legalTransactionCatGroupUUID);
    }

    @Override
    @Nonnull
    public LglTransDateFluentHelper getAllLglTransDate()
    {
        return new LglTransDateFluentHelper(servicePath, "A_LglTransDate");
    }

    @Override
    @Nonnull
    public LglTransDateByKeyFluentHelper getLglTransDateByKey( final UUID legalTransactionDateUUID )
    {
        return new LglTransDateByKeyFluentHelper(servicePath, "A_LglTransDate", legalTransactionDateUUID);
    }

    @Override
    @Nonnull
    public LglTransDateCreateFluentHelper createLglTransDate( @Nonnull final LglTransDate lglTransDate )
    {
        return new LglTransDateCreateFluentHelper(servicePath, lglTransDate, "A_LglTransDate");
    }

    @Override
    @Nonnull
    public LglTransDateUpdateFluentHelper updateLglTransDate( @Nonnull final LglTransDate lglTransDate )
    {
        return new LglTransDateUpdateFluentHelper(servicePath, lglTransDate, "A_LglTransDate");
    }

    @Override
    @Nonnull
    public LglTransDateDeleteFluentHelper deleteLglTransDate( @Nonnull final LglTransDate lglTransDate )
    {
        return new LglTransDateDeleteFluentHelper(servicePath, lglTransDate, "A_LglTransDate");
    }

    @Override
    @Nonnull
    public LglTransEntityFluentHelper getAllLglTransEntity()
    {
        return new LglTransEntityFluentHelper(servicePath, "A_LglTransEntity");
    }

    @Override
    @Nonnull
    public LglTransEntityByKeyFluentHelper getLglTransEntityByKey( final UUID legalTransactionEntityUUID )
    {
        return new LglTransEntityByKeyFluentHelper(servicePath, "A_LglTransEntity", legalTransactionEntityUUID);
    }

    @Override
    @Nonnull
    public LglTransEntityCreateFluentHelper createLglTransEntity( @Nonnull final LglTransEntity lglTransEntity )
    {
        return new LglTransEntityCreateFluentHelper(servicePath, lglTransEntity, "A_LglTransEntity");
    }

    @Override
    @Nonnull
    public LglTransEntityUpdateFluentHelper updateLglTransEntity( @Nonnull final LglTransEntity lglTransEntity )
    {
        return new LglTransEntityUpdateFluentHelper(servicePath, lglTransEntity, "A_LglTransEntity");
    }

    @Override
    @Nonnull
    public LglTransEntityDeleteFluentHelper deleteLglTransEntity( @Nonnull final LglTransEntity lglTransEntity )
    {
        return new LglTransEntityDeleteFluentHelper(servicePath, lglTransEntity, "A_LglTransEntity");
    }

    @Override
    @Nonnull
    public LglTransExternalContactFluentHelper getAllLglTransExternalContact()
    {
        return new LglTransExternalContactFluentHelper(servicePath, "A_LglTransExternalContact");
    }

    @Override
    @Nonnull
    public LglTransExternalContactByKeyFluentHelper getLglTransExternalContactByKey(
        final UUID legalTransactionExtCntctUUID )
    {
        return new LglTransExternalContactByKeyFluentHelper(
            servicePath,
            "A_LglTransExternalContact",
            legalTransactionExtCntctUUID);
    }

    @Override
    @Nonnull
    public LglTransExternalContactCreateFluentHelper createLglTransExternalContact(
        @Nonnull final LglTransExternalContact lglTransExternalContact )
    {
        return new LglTransExternalContactCreateFluentHelper(
            servicePath,
            lglTransExternalContact,
            "A_LglTransExternalContact");
    }

    @Override
    @Nonnull
    public LglTransExternalContactUpdateFluentHelper updateLglTransExternalContact(
        @Nonnull final LglTransExternalContact lglTransExternalContact )
    {
        return new LglTransExternalContactUpdateFluentHelper(
            servicePath,
            lglTransExternalContact,
            "A_LglTransExternalContact");
    }

    @Override
    @Nonnull
    public LglTransExternalContactDeleteFluentHelper deleteLglTransExternalContact(
        @Nonnull final LglTransExternalContact lglTransExternalContact )
    {
        return new LglTransExternalContactDeleteFluentHelper(
            servicePath,
            lglTransExternalContact,
            "A_LglTransExternalContact");
    }

    @Override
    @Nonnull
    public LglTransInternalContactFluentHelper getAllLglTransInternalContact()
    {
        return new LglTransInternalContactFluentHelper(servicePath, "A_LglTransInternalContact");
    }

    @Override
    @Nonnull
    public LglTransInternalContactByKeyFluentHelper getLglTransInternalContactByKey(
        final UUID legalTransactionIntCntctUUID )
    {
        return new LglTransInternalContactByKeyFluentHelper(
            servicePath,
            "A_LglTransInternalContact",
            legalTransactionIntCntctUUID);
    }

    @Override
    @Nonnull
    public LglTransInternalContactCreateFluentHelper createLglTransInternalContact(
        @Nonnull final LglTransInternalContact lglTransInternalContact )
    {
        return new LglTransInternalContactCreateFluentHelper(
            servicePath,
            lglTransInternalContact,
            "A_LglTransInternalContact");
    }

    @Override
    @Nonnull
    public LglTransInternalContactUpdateFluentHelper updateLglTransInternalContact(
        @Nonnull final LglTransInternalContact lglTransInternalContact )
    {
        return new LglTransInternalContactUpdateFluentHelper(
            servicePath,
            lglTransInternalContact,
            "A_LglTransInternalContact");
    }

    @Override
    @Nonnull
    public LglTransInternalContactDeleteFluentHelper deleteLglTransInternalContact(
        @Nonnull final LglTransInternalContact lglTransInternalContact )
    {
        return new LglTransInternalContactDeleteFluentHelper(
            servicePath,
            lglTransInternalContact,
            "A_LglTransInternalContact");
    }

    @Override
    @Nonnull
    public LglTransLinkedObjectsFluentHelper getAllLglTransLinkedObjects()
    {
        return new LglTransLinkedObjectsFluentHelper(servicePath, "A_LglTransLinkedObjects");
    }

    @Override
    @Nonnull
    public LglTransLinkedObjectsByKeyFluentHelper getLglTransLinkedObjectsByKey(
        final UUID legalTransactionLinkdObjUUID )
    {
        return new LglTransLinkedObjectsByKeyFluentHelper(
            servicePath,
            "A_LglTransLinkedObjects",
            legalTransactionLinkdObjUUID);
    }

    @Override
    @Nonnull
    public LglTransLinkedObjectsCreateFluentHelper createLglTransLinkedObjects(
        @Nonnull final LglTransLinkedObjects lglTransLinkedObjects )
    {
        return new LglTransLinkedObjectsCreateFluentHelper(
            servicePath,
            lglTransLinkedObjects,
            "A_LglTransLinkedObjects");
    }

    @Override
    @Nonnull
    public LglTransLinkedObjectsUpdateFluentHelper updateLglTransLinkedObjects(
        @Nonnull final LglTransLinkedObjects lglTransLinkedObjects )
    {
        return new LglTransLinkedObjectsUpdateFluentHelper(
            servicePath,
            lglTransLinkedObjects,
            "A_LglTransLinkedObjects");
    }

    @Override
    @Nonnull
    public LglTransLinkedObjectsDeleteFluentHelper deleteLglTransLinkedObjects(
        @Nonnull final LglTransLinkedObjects lglTransLinkedObjects )
    {
        return new LglTransLinkedObjectsDeleteFluentHelper(
            servicePath,
            lglTransLinkedObjects,
            "A_LglTransLinkedObjects");
    }

    @Override
    @Nonnull
    public LglTransParentCategoryFluentHelper getAllLglTransParentCategory()
    {
        return new LglTransParentCategoryFluentHelper(servicePath, "A_LglTransParentCategory");
    }

    @Override
    @Nonnull
    public LglTransParentCategoryByKeyFluentHelper getLglTransParentCategoryByKey(
        final UUID legalTransactionParCatUUID )
    {
        return new LglTransParentCategoryByKeyFluentHelper(
            servicePath,
            "A_LglTransParentCategory",
            legalTransactionParCatUUID);
    }

    @Override
    @Nonnull
    public LglTransRelationshipFluentHelper getAllLglTransRelationship()
    {
        return new LglTransRelationshipFluentHelper(servicePath, "A_LglTransRelationship");
    }

    @Override
    @Nonnull
    public LglTransRelationshipByKeyFluentHelper getLglTransRelationshipByKey( final UUID legalTransactionRelshpUUID )
    {
        return new LglTransRelationshipByKeyFluentHelper(
            servicePath,
            "A_LglTransRelationship",
            legalTransactionRelshpUUID);
    }

    @Override
    @Nonnull
    public LglTransRelationshipCreateFluentHelper createLglTransRelationship(
        @Nonnull final LglTransRelationship lglTransRelationship )
    {
        return new LglTransRelationshipCreateFluentHelper(servicePath, lglTransRelationship, "A_LglTransRelationship");
    }

    @Override
    @Nonnull
    public LglTransRelationshipUpdateFluentHelper updateLglTransRelationship(
        @Nonnull final LglTransRelationship lglTransRelationship )
    {
        return new LglTransRelationshipUpdateFluentHelper(servicePath, lglTransRelationship, "A_LglTransRelationship");
    }

    @Override
    @Nonnull
    public LglTransRelationshipDeleteFluentHelper deleteLglTransRelationship(
        @Nonnull final LglTransRelationship lglTransRelationship )
    {
        return new LglTransRelationshipDeleteFluentHelper(servicePath, lglTransRelationship, "A_LglTransRelationship");
    }

    @Override
    @Nonnull
    public CancelFluentHelper cancel( @Nonnull final UUID legalTransactionUUID )
    {
        return new CancelFluentHelper(servicePath, legalTransactionUUID);
    }

    @Override
    @Nonnull
    public TerminateFluentHelper terminate( @Nonnull final UUID legalTransactionUUID )
    {
        return new TerminateFluentHelper(servicePath, legalTransactionUUID);
    }

}
