/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.batch.DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch;

/**
 * <p>
 * This gives you detailed information about the posted and reversed flows of financial transactions and treasury
 * positions. It is based on the OData protocol and can be consumed in Fiori apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a5/c19312428b4fa7a956fbbf88440f44/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_TRSYPOSTGJRNLENTRITM_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_TRSYPOSTGJRNLENTRITM_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Treasury Posting Journal Integration(SAP_COM_0333)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XN'>Market Rates Management - Manually via Upload(1XN)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXN'>Market Data for Treasury and Risk Management(OXN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>TreasuryPostingJournal</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultLineItemOfTreasuryPostingJournalEntryService" )
@Deprecated
public class DefaultLineItemOfTreasuryPostingJournalEntryService implements LineItemOfTreasuryPostingJournalEntryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link LineItemOfTreasuryPostingJournalEntryService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultLineItemOfTreasuryPostingJournalEntryService()
    {
        servicePath = LineItemOfTreasuryPostingJournalEntryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultLineItemOfTreasuryPostingJournalEntryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultLineItemOfTreasuryPostingJournalEntryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultLineItemOfTreasuryPostingJournalEntryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch batch()
    {
        return new DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public TrsyPostgJrnlEntrItmFluentHelper getAllTrsyPostgJrnlEntrItm()
    {
        return new TrsyPostgJrnlEntrItmFluentHelper(servicePath, "A_TrsyPostgJrnlEntrItm");
    }

    @Override
    @Nonnull
    public TrsyPostgJrnlEntrItmByKeyFluentHelper getTrsyPostgJrnlEntrItmByKey(
        final UUID trsyAccountingDocumentUUID,
        final String accountingDocumentItemRef,
        final UUID trsyPositionContextUUID )
    {
        return new TrsyPostgJrnlEntrItmByKeyFluentHelper(
            servicePath,
            "A_TrsyPostgJrnlEntrItm",
            trsyAccountingDocumentUUID,
            accountingDocumentItemRef,
            trsyPositionContextUUID);
    }

}
