/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.CreateVariantBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.GetMaintBOMItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.batch.DefaultMaintenanceBillOfMaterialServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, update, or delete the bill of material header and item. It is based on the OData
 * protocol and can be consumed in SAP Fiori apps and on other user interfaces. The service contains header and item
 * nodes for the bill of material. When performing an operation, the necessary information is sent in the request as a
 * payload. All information used when creating a maintenance BOM is checked for restricted values and authorizations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/21/317859a54d477b89e43e4501249157/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEBOM?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEBOM</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance BOM API Integration(SAP_COM_0762)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaintenanceBillOfMaterialService" )
@Deprecated
public class DefaultMaintenanceBillOfMaterialService implements MaintenanceBillOfMaterialService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaintenanceBillOfMaterialService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaintenanceBillOfMaterialService()
    {
        servicePath = MaintenanceBillOfMaterialService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaintenanceBillOfMaterialService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaintenanceBillOfMaterialService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaintenanceBillOfMaterialService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaintenanceBillOfMaterialServiceBatch batch()
    {
        return new DefaultMaintenanceBillOfMaterialServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BOMItemFluentHelper getAllBOMItem()
    {
        return new BOMItemFluentHelper(servicePath, "BOMItem");
    }

    @Override
    @Nonnull
    public BOMItemByKeyFluentHelper getBOMItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String technicalObject,
        final String plant,
        final String engineeringChangeDocument,
        final String billOfMaterialVariantUsage,
        final String billOfMaterialItemNodeNumber )
    {
        return new BOMItemByKeyFluentHelper(
            servicePath,
            "BOMItem",
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            technicalObject,
            plant,
            engineeringChangeDocument,
            billOfMaterialVariantUsage,
            billOfMaterialItemNodeNumber);
    }

    @Override
    @Nonnull
    public BOMItemCreateFluentHelper createBOMItem( @Nonnull final BOMItem bOMItem )
    {
        return new BOMItemCreateFluentHelper(servicePath, bOMItem, "BOMItem");
    }

    @Override
    @Nonnull
    public BOMItemUpdateFluentHelper updateBOMItem( @Nonnull final BOMItem bOMItem )
    {
        return new BOMItemUpdateFluentHelper(servicePath, bOMItem, "BOMItem");
    }

    @Override
    @Nonnull
    public BOMItemDeleteFluentHelper deleteBOMItem( @Nonnull final BOMItem bOMItem )
    {
        return new BOMItemDeleteFluentHelper(servicePath, bOMItem, "BOMItem");
    }

    @Override
    @Nonnull
    public MaintBOMHeaderFluentHelper getAllMaintBOMHeader()
    {
        return new MaintBOMHeaderFluentHelper(servicePath, "BOMHeader");
    }

    @Override
    @Nonnull
    public MaintBOMHeaderByKeyFluentHelper getMaintBOMHeaderByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String technicalObject,
        final String plant,
        final String engineeringChangeDocument,
        final String billOfMaterialVariantUsage )
    {
        return new MaintBOMHeaderByKeyFluentHelper(
            servicePath,
            "BOMHeader",
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            technicalObject,
            plant,
            engineeringChangeDocument,
            billOfMaterialVariantUsage);
    }

    @Override
    @Nonnull
    public MaintBOMHeaderCreateFluentHelper createMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader )
    {
        return new MaintBOMHeaderCreateFluentHelper(servicePath, maintBOMHeader, "BOMHeader");
    }

    @Override
    @Nonnull
    public MaintBOMHeaderUpdateFluentHelper updateMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader )
    {
        return new MaintBOMHeaderUpdateFluentHelper(servicePath, maintBOMHeader, "BOMHeader");
    }

    @Override
    @Nonnull
    public MaintBOMHeaderDeleteFluentHelper deleteMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader )
    {
        return new MaintBOMHeaderDeleteFluentHelper(servicePath, maintBOMHeader, "BOMHeader");
    }

    @Override
    @Nonnull
    public CreateVariantBOMFluentHelper createVariantBOM(
        @Nonnull final String technicalObject,
        @Nonnull final String billOfMaterialVariantUsage,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String referenceObjectID,
        @Nullable final LocalDateTime headerValidityStartDate,
        @Nullable final String engineeringChangeDocument )
    {
        return new CreateVariantBOMFluentHelper(
            servicePath,
            technicalObject,
            billOfMaterialVariantUsage,
            plant,
            billOfMaterialCategory,
            referenceObjectID,
            headerValidityStartDate,
            engineeringChangeDocument);
    }

    @Override
    @Nonnull
    public GetMaintBOMItemsFluentHelper getMaintBOMItems(
        @Nonnull final String technicalObject,
        @Nonnull final String billOfMaterialVariantUsage,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion )
    {
        return new GetMaintBOMItemsFluentHelper(
            servicePath,
            technicalObject,
            billOfMaterialVariantUsage,
            plant,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion);
    }

}
