/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.batch.DefaultMaintenanceItemServiceBatch;

/**
 * <p>
 *
 * This API allows you to read, create, and update maintenance items. The request contains all the information that is
 * necessary to read, create, and update maintenance items. If the input in the request is not as expected, the system
 * displays appropriate error or warning messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/31/4f4099993e40d7b8ae0f90174015ea/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEITEM?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEITEM</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Planning Integration(SAP_COM_0396)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4X5'>Recurring Services(4X5)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Item</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaintenanceItemService" )
@Deprecated
public class DefaultMaintenanceItemService implements MaintenanceItemService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaintenanceItemService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaintenanceItemService()
    {
        servicePath = MaintenanceItemService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaintenanceItemService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaintenanceItemService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaintenanceItemService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaintenanceItemServiceBatch batch()
    {
        return new DefaultMaintenanceItemServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaintenanceItemFluentHelper getAllMaintenanceItem()
    {
        return new MaintenanceItemFluentHelper(servicePath, "MaintenanceItem");
    }

    @Override
    @Nonnull
    public MaintenanceItemByKeyFluentHelper getMaintenanceItemByKey( final String maintenanceItem )
    {
        return new MaintenanceItemByKeyFluentHelper(servicePath, "MaintenanceItem", maintenanceItem);
    }

    @Override
    @Nonnull
    public MaintenanceItemCreateFluentHelper createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return new MaintenanceItemCreateFluentHelper(servicePath, maintenanceItem, "MaintenanceItem");
    }

    @Override
    @Nonnull
    public MaintenanceItemUpdateFluentHelper updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return new MaintenanceItemUpdateFluentHelper(servicePath, maintenanceItem, "MaintenanceItem");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseFluentHelper getAllMaintenanceItemCause()
    {
        return new MaintenanceItemCauseFluentHelper(servicePath, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public
        MaintenanceItemCauseByKeyFluentHelper
        getMaintenanceItemCauseByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems )
    {
        return new MaintenanceItemCauseByKeyFluentHelper(
            servicePath,
            "MaintenanceItemCause",
            maintenanceItem,
            nmbrOfMaintComplianceItems);
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseCreateFluentHelper createMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return new MaintenanceItemCauseCreateFluentHelper(servicePath, maintenanceItemCause, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseUpdateFluentHelper updateMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return new MaintenanceItemCauseUpdateFluentHelper(servicePath, maintenanceItemCause, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseDeleteFluentHelper deleteMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return new MaintenanceItemCauseDeleteFluentHelper(servicePath, maintenanceItemCause, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextFluentHelper getAllMaintenanceItemCauseText()
    {
        return new MaintenanceItemCauseTextFluentHelper(servicePath, "MaintenanceItemCauseText");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextByKeyFluentHelper getMaintenanceItemCauseTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language )
    {
        return new MaintenanceItemCauseTextByKeyFluentHelper(
            servicePath,
            "MaintenanceItemCauseText",
            maintenanceItem,
            nmbrOfMaintComplianceItems,
            language);
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextUpdateFluentHelper updateMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return new MaintenanceItemCauseTextUpdateFluentHelper(
            servicePath,
            maintenanceItemCauseText,
            "MaintenanceItemCauseText");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextDeleteFluentHelper deleteMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return new MaintenanceItemCauseTextDeleteFluentHelper(
            servicePath,
            maintenanceItemCauseText,
            "MaintenanceItemCauseText");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonFluentHelper getAllMaintenanceItemReason()
    {
        return new MaintenanceItemReasonFluentHelper(servicePath, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public
        MaintenanceItemReasonByKeyFluentHelper
        getMaintenanceItemReasonByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems )
    {
        return new MaintenanceItemReasonByKeyFluentHelper(
            servicePath,
            "MaintenanceItemReason",
            maintenanceItem,
            nmbrOfMaintComplianceItems);
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonCreateFluentHelper createMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return new MaintenanceItemReasonCreateFluentHelper(servicePath, maintenanceItemReason, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonUpdateFluentHelper updateMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return new MaintenanceItemReasonUpdateFluentHelper(servicePath, maintenanceItemReason, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonDeleteFluentHelper deleteMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return new MaintenanceItemReasonDeleteFluentHelper(servicePath, maintenanceItemReason, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextFluentHelper getAllMaintenanceItemReasonText()
    {
        return new MaintenanceItemReasonTextFluentHelper(servicePath, "MaintenanceItemReasonText");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextByKeyFluentHelper getMaintenanceItemReasonTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language )
    {
        return new MaintenanceItemReasonTextByKeyFluentHelper(
            servicePath,
            "MaintenanceItemReasonText",
            maintenanceItem,
            nmbrOfMaintComplianceItems,
            language);
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextUpdateFluentHelper updateMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return new MaintenanceItemReasonTextUpdateFluentHelper(
            servicePath,
            maintenanceItemReasonText,
            "MaintenanceItemReasonText");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextDeleteFluentHelper deleteMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return new MaintenanceItemReasonTextDeleteFluentHelper(
            servicePath,
            maintenanceItemReasonText,
            "MaintenanceItemReasonText");
    }

    @Override
    @Nonnull
    public MaintenanceItemTextFluentHelper getAllMaintenanceItemText()
    {
        return new MaintenanceItemTextFluentHelper(servicePath, "MaintenanceItemText");
    }

    @Override
    @Nonnull
    public
        MaintenanceItemTextByKeyFluentHelper
        getMaintenanceItemTextByKey( final String maintenanceItem, final String language )
    {
        return new MaintenanceItemTextByKeyFluentHelper(servicePath, "MaintenanceItemText", maintenanceItem, language);
    }

    @Override
    @Nonnull
    public MaintenanceItemTextUpdateFluentHelper updateMaintenanceItemText(
        @Nonnull final MaintenanceItemText maintenanceItemText )
    {
        return new MaintenanceItemTextUpdateFluentHelper(servicePath, maintenanceItemText, "MaintenanceItemText");
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemFluentHelper getAllMaintItemObjectListItem()
    {
        return new MaintItemObjectListItemFluentHelper(servicePath, "MaintItemObjectListItem");
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemByKeyFluentHelper getMaintItemObjectListItemByKey(
        final String maintenanceItem,
        final Long maintenanceItemObjectList,
        final Integer maintenanceObjectListItem )
    {
        return new MaintItemObjectListItemByKeyFluentHelper(
            servicePath,
            "MaintItemObjectListItem",
            maintenanceItem,
            maintenanceItemObjectList,
            maintenanceObjectListItem);
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemUpdateFluentHelper updateMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return new MaintItemObjectListItemUpdateFluentHelper(
            servicePath,
            maintItemObjectListItem,
            "MaintItemObjectListItem");
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemDeleteFluentHelper deleteMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return new MaintItemObjectListItemDeleteFluentHelper(
            servicePath,
            maintItemObjectListItem,
            "MaintItemObjectListItem");
    }

    @Override
    @Nonnull
    public MaintenancePlanCallObjectFluentHelper getAllMaintenancePlanCallObject()
    {
        return new MaintenancePlanCallObjectFluentHelper(servicePath, "MaintenancePlanCallObject");
    }

    @Override
    @Nonnull
    public MaintenancePlanCallObjectByKeyFluentHelper getMaintenancePlanCallObjectByKey(
        final String maintenancePlan,
        final Integer maintenancePlanCallNumber,
        final String maintenanceItem )
    {
        return new MaintenancePlanCallObjectByKeyFluentHelper(
            servicePath,
            "MaintenancePlanCallObject",
            maintenancePlan,
            maintenancePlanCallNumber,
            maintenanceItem);
    }

}
