/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.CompleteMaintNotificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.SetMaintNotifToInProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.batch.DefaultMaintenanceNotificationServiceBatch;

/**
 * <p>
 *
 * This service contains maintenance notification header details, item, item cause, item activity, and partner function.
 * The information is sent in the request as a payload.
 *
 * The request payload contains all information required to create or update a maintenance notification. All the
 * information in the payload is used to create or update a maintenance notification including appropriate checks for
 * restricted values and authorizations. Once the maintenance notification has been created, the notification number is
 * sent in the response with the data included.
 *
 * If the input in the request is not as expected when you create or update a maintenance notification, the system
 * displays appropriate error or warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f4/30cbb1950c4880810e27a8308db301/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTNOTIFICATION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTNOTIFICATION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Processing Integration(SAP_COM_0397)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Notification</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaintenanceNotificationService" )
@Deprecated
public class DefaultMaintenanceNotificationService implements MaintenanceNotificationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaintenanceNotificationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaintenanceNotificationService()
    {
        servicePath = MaintenanceNotificationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaintenanceNotificationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaintenanceNotificationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaintenanceNotificationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaintenanceNotificationServiceBatch batch()
    {
        return new DefaultMaintenanceNotificationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaintenanceNotificationFluentHelper getAllMaintenanceNotification()
    {
        return new MaintenanceNotificationFluentHelper(servicePath, "MaintenanceNotification");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationByKeyFluentHelper getMaintenanceNotificationByKey(
        final String maintenanceNotification )
    {
        return new MaintenanceNotificationByKeyFluentHelper(
            servicePath,
            "MaintenanceNotification",
            maintenanceNotification);
    }

    @Override
    @Nonnull
    public MaintenanceNotificationCreateFluentHelper createMaintenanceNotification(
        @Nonnull final MaintenanceNotification maintenanceNotification )
    {
        return new MaintenanceNotificationCreateFluentHelper(
            servicePath,
            maintenanceNotification,
            "MaintenanceNotification");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationUpdateFluentHelper updateMaintenanceNotification(
        @Nonnull final MaintenanceNotification maintenanceNotification )
    {
        return new MaintenanceNotificationUpdateFluentHelper(
            servicePath,
            maintenanceNotification,
            "MaintenanceNotification");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationItemFluentHelper getAllMaintenanceNotificationItem()
    {
        return new MaintenanceNotificationItemFluentHelper(servicePath, "MaintenanceNotificationItem");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationItemByKeyFluentHelper getMaintenanceNotificationItemByKey(
        final String maintenanceNotification,
        final String maintenanceNotificationItem )
    {
        return new MaintenanceNotificationItemByKeyFluentHelper(
            servicePath,
            "MaintenanceNotificationItem",
            maintenanceNotification,
            maintenanceNotificationItem);
    }

    @Override
    @Nonnull
    public MaintenanceNotificationItemCreateFluentHelper createMaintenanceNotificationItem(
        @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem )
    {
        return new MaintenanceNotificationItemCreateFluentHelper(
            servicePath,
            maintenanceNotificationItem,
            "MaintenanceNotificationItem");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationItemUpdateFluentHelper updateMaintenanceNotificationItem(
        @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem )
    {
        return new MaintenanceNotificationItemUpdateFluentHelper(
            servicePath,
            maintenanceNotificationItem,
            "MaintenanceNotificationItem");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationPartnerFluentHelper getAllMaintenanceNotificationPartner()
    {
        return new MaintenanceNotificationPartnerFluentHelper(servicePath, "MaintenanceNotificationPartner");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationPartnerByKeyFluentHelper getMaintenanceNotificationPartnerByKey(
        final String maintenanceNotification,
        final String partnerFunction,
        final String notificationPartnerObjectNmbr )
    {
        return new MaintenanceNotificationPartnerByKeyFluentHelper(
            servicePath,
            "MaintenanceNotificationPartner",
            maintenanceNotification,
            partnerFunction,
            notificationPartnerObjectNmbr);
    }

    @Override
    @Nonnull
    public MaintenanceNotificationPartnerCreateFluentHelper createMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner )
    {
        return new MaintenanceNotificationPartnerCreateFluentHelper(
            servicePath,
            maintenanceNotificationPartner,
            "MaintenanceNotificationPartner");
    }

    @Override
    @Nonnull
    public MaintenanceNotificationPartnerUpdateFluentHelper updateMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner )
    {
        return new MaintenanceNotificationPartnerUpdateFluentHelper(
            servicePath,
            maintenanceNotificationPartner,
            "MaintenanceNotificationPartner");
    }

    @Override
    @Nonnull
    public MaintNotificationItemActivityFluentHelper getAllMaintNotificationItemActivity()
    {
        return new MaintNotificationItemActivityFluentHelper(servicePath, "MaintNotificationItemActivity");
    }

    @Override
    @Nonnull
    public MaintNotificationItemActivityByKeyFluentHelper getMaintNotificationItemActivityByKey(
        final String maintNotificationActivity,
        final String maintenanceNotification,
        final String maintenanceNotificationItem )
    {
        return new MaintNotificationItemActivityByKeyFluentHelper(
            servicePath,
            "MaintNotificationItemActivity",
            maintNotificationActivity,
            maintenanceNotification,
            maintenanceNotificationItem);
    }

    @Override
    @Nonnull
    public MaintNotificationItemActivityCreateFluentHelper createMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity )
    {
        return new MaintNotificationItemActivityCreateFluentHelper(
            servicePath,
            maintNotificationItemActivity,
            "MaintNotificationItemActivity");
    }

    @Override
    @Nonnull
    public MaintNotificationItemActivityUpdateFluentHelper updateMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity )
    {
        return new MaintNotificationItemActivityUpdateFluentHelper(
            servicePath,
            maintNotificationItemActivity,
            "MaintNotificationItemActivity");
    }

    @Override
    @Nonnull
    public MaintNotificationItemCauseFluentHelper getAllMaintNotificationItemCause()
    {
        return new MaintNotificationItemCauseFluentHelper(servicePath, "MaintNotificationItemCause");
    }

    @Override
    @Nonnull
    public MaintNotificationItemCauseByKeyFluentHelper getMaintNotificationItemCauseByKey(
        final String maintenanceNotification,
        final String maintenanceNotificationItem,
        final String maintenanceNotificationCause )
    {
        return new MaintNotificationItemCauseByKeyFluentHelper(
            servicePath,
            "MaintNotificationItemCause",
            maintenanceNotification,
            maintenanceNotificationItem,
            maintenanceNotificationCause);
    }

    @Override
    @Nonnull
    public MaintNotificationItemCauseCreateFluentHelper createMaintNotificationItemCause(
        @Nonnull final MaintNotificationItemCause maintNotificationItemCause )
    {
        return new MaintNotificationItemCauseCreateFluentHelper(
            servicePath,
            maintNotificationItemCause,
            "MaintNotificationItemCause");
    }

    @Override
    @Nonnull
    public MaintNotificationItemCauseUpdateFluentHelper updateMaintNotificationItemCause(
        @Nonnull final MaintNotificationItemCause maintNotificationItemCause )
    {
        return new MaintNotificationItemCauseUpdateFluentHelper(
            servicePath,
            maintNotificationItemCause,
            "MaintNotificationItemCause");
    }

    @Override
    @Nonnull
    public CompleteMaintNotificationFluentHelper completeMaintNotification(
        @Nonnull final String maintenanceNotification,
        @Nullable final LocalDateTime notificationReferenceDate,
        @Nullable final LocalTime notificationReferenceTime )
    {
        return new CompleteMaintNotificationFluentHelper(
            servicePath,
            maintenanceNotification,
            notificationReferenceDate,
            notificationReferenceTime);
    }

    @Override
    @Nonnull
    public CompleteMaintNotificationFluentHelper completeMaintNotification(
        @Nonnull final String maintenanceNotification,
        @Nullable final LocalDateTime notificationReferenceDate,
        @Nullable final LocalTime notificationReferenceTime,
        @Nullable final ZonedDateTime maintNotifReferenceDateTime )
    {
        return new CompleteMaintNotificationFluentHelper(
            servicePath,
            maintenanceNotification,
            notificationReferenceDate,
            notificationReferenceTime,
            maintNotifReferenceDateTime);
    }

    @Override
    @Nonnull
    public SetMaintNotifToInProcessFluentHelper setMaintNotifToInProcess(
        @Nonnull final String maintenanceNotification )
    {
        return new SetMaintNotifToInProcessFluentHelper(servicePath, maintenanceNotification);
    }

}
