/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.CancelMaintOrderConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.batch.DefaultMaintenanceOrderOperationConfirmationServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound service enables you to create new maintenance order confirmations and cancel confirmations
 * that are already posted. You can display and use this data, for example, in an external application. The API is based
 * on the OData V2 protocol..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/7d/6c7de7b9234747978552d4ca44466b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTORDERCONFIRMATION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTORDERCONFIRMATION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Plant Maintenance Execution Integration(SAP_COM_0398)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service
 * Management(49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation(4GA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>MaintenanceOrderConfirmation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaintenanceOrderOperationConfirmationService" )
@Deprecated
public class DefaultMaintenanceOrderOperationConfirmationService implements MaintenanceOrderOperationConfirmationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaintenanceOrderOperationConfirmationService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultMaintenanceOrderOperationConfirmationService()
    {
        servicePath = MaintenanceOrderOperationConfirmationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaintenanceOrderOperationConfirmationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaintenanceOrderOperationConfirmationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaintenanceOrderOperationConfirmationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaintenanceOrderOperationConfirmationServiceBatch batch()
    {
        return new DefaultMaintenanceOrderOperationConfirmationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaintOrderConfirmationFluentHelper getAllMaintOrderConfirmation()
    {
        return new MaintOrderConfirmationFluentHelper(servicePath, "MaintOrderConfirmation");
    }

    @Override
    @Nonnull
    public
        MaintOrderConfirmationByKeyFluentHelper
        getMaintOrderConfirmationByKey( final String maintOrderConf, final String maintOrderConfCntrValue )
    {
        return new MaintOrderConfirmationByKeyFluentHelper(
            servicePath,
            "MaintOrderConfirmation",
            maintOrderConf,
            maintOrderConfCntrValue);
    }

    @Override
    @Nonnull
    public MaintOrderConfirmationCreateFluentHelper createMaintOrderConfirmation(
        @Nonnull final MaintOrderConfirmation maintOrderConfirmation )
    {
        return new MaintOrderConfirmationCreateFluentHelper(
            servicePath,
            maintOrderConfirmation,
            "MaintOrderConfirmation");
    }

    @Override
    @Nonnull
    public LongTextFluentHelper getAllLongText()
    {
        return new LongTextFluentHelper(servicePath, "LongText");
    }

    @Override
    @Nonnull
    public
        LongTextByKeyFluentHelper
        getLongTextByKey( final String maintOrderConf, final String maintOrderConfCntrValue )
    {
        return new LongTextByKeyFluentHelper(servicePath, "LongText", maintOrderConf, maintOrderConfCntrValue);
    }

    @Override
    @Nonnull
    public LongTextCreateFluentHelper createLongText( @Nonnull final LongText longText )
    {
        return new LongTextCreateFluentHelper(servicePath, longText, "LongText");
    }

    @Override
    @Nonnull
    public CancelMaintOrderConfirmationFluentHelper cancelMaintOrderConfirmation(
        @Nonnull final String maintOrderConf,
        @Nonnull final String maintOrderConfCntrValue )
    {
        return new CancelMaintOrderConfirmationFluentHelper(servicePath, maintOrderConf, maintOrderConfCntrValue);
    }

}
