/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ActvtMaintOrderOpPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ActvtMaintOrderPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ApproveMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.AssignMaintNotificationToOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.DactvtMaintOrderOpPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.DactvtMaintOrderPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHistByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHistFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.RejectMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ReleaseMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdOpsStsDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsMainWorkCmpltFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsTechCompletedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderOpStsDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderStatusClosedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderStsRdyForSchedgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ScheduleMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdStsToMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToMainWorkCompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToTechCompletedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderOpToDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderOpsToDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToClosedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToLockedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToUnlockedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderToDoNotExecuteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderToReadyForSchedgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SubmitMaintOrderForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.batch.DefaultMaintenanceOrderServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, updated and delete maintenance order data. It contains order header,
 * operation, component, object list item, operation relationship, long text and settlement rule nodes. The service is
 * based on the OData V2 protocol, and can be consumed in external systems, Fiori applications and on other user
 * interfaces.
 *
 * If there are any issues when retrieving the maintenance order data, the system displays appropriate warning or error
 * messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d3/f02cfccf00407ab9776ea2ec2030d3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEORDER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEORDER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Processing Integration(SAP_COM_0397)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaintenanceOrderService" )
@Deprecated
public class DefaultMaintenanceOrderService implements MaintenanceOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaintenanceOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaintenanceOrderService()
    {
        servicePath = MaintenanceOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaintenanceOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaintenanceOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaintenanceOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaintenanceOrderServiceBatch batch()
    {
        return new DefaultMaintenanceOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaintenanceOrderFluentHelper getAllMaintenanceOrder()
    {
        return new MaintenanceOrderFluentHelper(servicePath, "MaintenanceOrder");
    }

    @Override
    @Nonnull
    public MaintenanceOrderByKeyFluentHelper getMaintenanceOrderByKey( final String maintenanceOrder )
    {
        return new MaintenanceOrderByKeyFluentHelper(servicePath, "MaintenanceOrder", maintenanceOrder);
    }

    @Override
    @Nonnull
    public MaintenanceOrderCreateFluentHelper createMaintenanceOrder( @Nonnull final MaintenanceOrder maintenanceOrder )
    {
        return new MaintenanceOrderCreateFluentHelper(servicePath, maintenanceOrder, "MaintenanceOrder");
    }

    @Override
    @Nonnull
    public MaintenanceOrderUpdateFluentHelper updateMaintenanceOrder( @Nonnull final MaintenanceOrder maintenanceOrder )
    {
        return new MaintenanceOrderUpdateFluentHelper(servicePath, maintenanceOrder, "MaintenanceOrder");
    }

    @Override
    @Nonnull
    public MaintenanceOrderLongTextFluentHelper getAllMaintenanceOrderLongText()
    {
        return new MaintenanceOrderLongTextFluentHelper(servicePath, "MaintenanceOrderLongText");
    }

    @Override
    @Nonnull
    public MaintenanceOrderLongTextByKeyFluentHelper getMaintenanceOrderLongTextByKey(
        final String maintenanceOrder,
        final String textObjectType,
        final String language )
    {
        return new MaintenanceOrderLongTextByKeyFluentHelper(
            servicePath,
            "MaintenanceOrderLongText",
            maintenanceOrder,
            textObjectType,
            language);
    }

    @Override
    @Nonnull
    public MaintenanceOrderLongTextUpdateFluentHelper updateMaintenanceOrderLongText(
        @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText )
    {
        return new MaintenanceOrderLongTextUpdateFluentHelper(
            servicePath,
            maintenanceOrderLongText,
            "MaintenanceOrderLongText");
    }

    @Override
    @Nonnull
    public MaintenanceOrderLongTextDeleteFluentHelper deleteMaintenanceOrderLongText(
        @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText )
    {
        return new MaintenanceOrderLongTextDeleteFluentHelper(
            servicePath,
            maintenanceOrderLongText,
            "MaintenanceOrderLongText");
    }

    @Override
    @Nonnull
    public MaintenanceOrderOperationFluentHelper getAllMaintenanceOrderOperation()
    {
        return new MaintenanceOrderOperationFluentHelper(servicePath, "MaintenanceOrderOperation");
    }

    @Override
    @Nonnull
    public MaintenanceOrderOperationByKeyFluentHelper getMaintenanceOrderOperationByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation )
    {
        return new MaintenanceOrderOperationByKeyFluentHelper(
            servicePath,
            "MaintenanceOrderOperation",
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation);
    }

    @Override
    @Nonnull
    public MaintenanceOrderOperationCreateFluentHelper createMaintenanceOrderOperation(
        @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation )
    {
        return new MaintenanceOrderOperationCreateFluentHelper(
            servicePath,
            maintenanceOrderOperation,
            "MaintenanceOrderOperation");
    }

    @Override
    @Nonnull
    public MaintenanceOrderOperationUpdateFluentHelper updateMaintenanceOrderOperation(
        @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation )
    {
        return new MaintenanceOrderOperationUpdateFluentHelper(
            servicePath,
            maintenanceOrderOperation,
            "MaintenanceOrderOperation");
    }

    @Override
    @Nonnull
    public MaintenanceOrderOperationDeleteFluentHelper deleteMaintenanceOrderOperation(
        @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation )
    {
        return new MaintenanceOrderOperationDeleteFluentHelper(
            servicePath,
            maintenanceOrderOperation,
            "MaintenanceOrderOperation");
    }

    @Override
    @Nonnull
    public MaintenanceOrderPartnerFluentHelper getAllMaintenanceOrderPartner()
    {
        return new MaintenanceOrderPartnerFluentHelper(servicePath, "MaintenanceOrderPartner");
    }

    @Override
    @Nonnull
    public MaintenanceOrderPartnerByKeyFluentHelper getMaintenanceOrderPartnerByKey(
        final String maintenanceOrder,
        final String partnerFunction,
        final String maintenanceOrderPartner )
    {
        return new MaintenanceOrderPartnerByKeyFluentHelper(
            servicePath,
            "MaintenanceOrderPartner",
            maintenanceOrder,
            partnerFunction,
            maintenanceOrderPartner);
    }

    @Override
    @Nonnull
    public MaintenanceOrderPartnerDeleteFluentHelper deleteMaintenanceOrderPartner(
        @Nonnull final MaintenanceOrderPartner maintenanceOrderPartner )
    {
        return new MaintenanceOrderPartnerDeleteFluentHelper(
            servicePath,
            maintenanceOrderPartner,
            "MaintenanceOrderPartner");
    }

    @Override
    @Nonnull
    public MaintnanceOrderPhaseControlFluentHelper getAllMaintnanceOrderPhaseControl()
    {
        return new MaintnanceOrderPhaseControlFluentHelper(servicePath, "MaintenanceOrderPhaseControl");
    }

    @Override
    @Nonnull
    public
        MaintnanceOrderPhaseControlByKeyFluentHelper
        getMaintnanceOrderPhaseControlByKey( final String maintenanceOrder, final String maintenancePhaseControl )
    {
        return new MaintnanceOrderPhaseControlByKeyFluentHelper(
            servicePath,
            "MaintenanceOrderPhaseControl",
            maintenanceOrder,
            maintenancePhaseControl);
    }

    @Override
    @Nonnull
    public MaintOrderActlPlndCostItmByKeyFluentHelper getMaintOrderActlPlndCostItmByKey(
        final String p_GLAccountHierarchy,
        final String sourceLedger,
        final String ledger,
        final String companyCode,
        final String fiscalYear,
        final String accountingDocument,
        final String financialPlanningReqTransSqnc,
        final String financialPlanningDataPacket,
        final String actualPlanJournalEntryItem )
    {
        return new MaintOrderActlPlndCostItmByKeyFluentHelper(
            servicePath,
            "MaintOrderActlPlndCostItmSet",
            p_GLAccountHierarchy,
            sourceLedger,
            ledger,
            companyCode,
            fiscalYear,
            accountingDocument,
            financialPlanningReqTransSqnc,
            financialPlanningDataPacket,
            actualPlanJournalEntryItem);
    }

    @Override
    @Nonnull
    public MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper getMaintOrderActlPlndCostItm_TypeParametersByKey(
        final String p_GLAccountHierarchy )
    {
        return new MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper(
            servicePath,
            "MaintOrderActlPlndCostItm",
            p_GLAccountHierarchy);
    }

    @Override
    @Nonnull
    public MaintOrderObjectListItemFluentHelper getAllMaintOrderObjectListItem()
    {
        return new MaintOrderObjectListItemFluentHelper(servicePath, "MaintOrderObjectListItem");
    }

    @Override
    @Nonnull
    public MaintOrderObjectListItemByKeyFluentHelper getMaintOrderObjectListItemByKey(
        final String maintenanceOrder,
        final Long maintenanceOrderObjectList,
        final Integer maintenanceObjectListItem )
    {
        return new MaintOrderObjectListItemByKeyFluentHelper(
            servicePath,
            "MaintOrderObjectListItem",
            maintenanceOrder,
            maintenanceOrderObjectList,
            maintenanceObjectListItem);
    }

    @Override
    @Nonnull
    public MaintOrderObjectListItemUpdateFluentHelper updateMaintOrderObjectListItem(
        @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem )
    {
        return new MaintOrderObjectListItemUpdateFluentHelper(
            servicePath,
            maintOrderObjectListItem,
            "MaintOrderObjectListItem");
    }

    @Override
    @Nonnull
    public MaintOrderObjectListItemDeleteFluentHelper deleteMaintOrderObjectListItem(
        @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem )
    {
        return new MaintOrderObjectListItemDeleteFluentHelper(
            servicePath,
            maintOrderObjectListItem,
            "MaintOrderObjectListItem");
    }

    @Override
    @Nonnull
    public MaintOrderOpCompLongTextFluentHelper getAllMaintOrderOpCompLongText()
    {
        return new MaintOrderOpCompLongTextFluentHelper(servicePath, "MaintOrderOpCompLongText");
    }

    @Override
    @Nonnull
    public MaintOrderOpCompLongTextByKeyFluentHelper getMaintOrderOpCompLongTextByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String maintenanceOrderComponent,
        final String textObjectType,
        final String language )
    {
        return new MaintOrderOpCompLongTextByKeyFluentHelper(
            servicePath,
            "MaintOrderOpCompLongText",
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            maintenanceOrderComponent,
            textObjectType,
            language);
    }

    @Override
    @Nonnull
    public MaintOrderOpCompLongTextUpdateFluentHelper updateMaintOrderOpCompLongText(
        @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText )
    {
        return new MaintOrderOpCompLongTextUpdateFluentHelper(
            servicePath,
            maintOrderOpCompLongText,
            "MaintOrderOpCompLongText");
    }

    @Override
    @Nonnull
    public MaintOrderOpCompLongTextDeleteFluentHelper deleteMaintOrderOpCompLongText(
        @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText )
    {
        return new MaintOrderOpCompLongTextDeleteFluentHelper(
            servicePath,
            maintOrderOpCompLongText,
            "MaintOrderOpCompLongText");
    }

    @Override
    @Nonnull
    public MaintOrderOpComponentFluentHelper getAllMaintOrderOpComponent()
    {
        return new MaintOrderOpComponentFluentHelper(servicePath, "MaintOrderOpComponent");
    }

    @Override
    @Nonnull
    public MaintOrderOpComponentByKeyFluentHelper getMaintOrderOpComponentByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String maintenanceOrderComponent )
    {
        return new MaintOrderOpComponentByKeyFluentHelper(
            servicePath,
            "MaintOrderOpComponent",
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            maintenanceOrderComponent);
    }

    @Override
    @Nonnull
    public MaintOrderOpComponentCreateFluentHelper createMaintOrderOpComponent(
        @Nonnull final MaintOrderOpComponent maintOrderOpComponent )
    {
        return new MaintOrderOpComponentCreateFluentHelper(servicePath, maintOrderOpComponent, "MaintOrderOpComponent");
    }

    @Override
    @Nonnull
    public MaintOrderOpComponentUpdateFluentHelper updateMaintOrderOpComponent(
        @Nonnull final MaintOrderOpComponent maintOrderOpComponent )
    {
        return new MaintOrderOpComponentUpdateFluentHelper(servicePath, maintOrderOpComponent, "MaintOrderOpComponent");
    }

    @Override
    @Nonnull
    public MaintOrderOpComponentDeleteFluentHelper deleteMaintOrderOpComponent(
        @Nonnull final MaintOrderOpComponent maintOrderOpComponent )
    {
        return new MaintOrderOpComponentDeleteFluentHelper(servicePath, maintOrderOpComponent, "MaintOrderOpComponent");
    }

    @Override
    @Nonnull
    public MaintOrderOpLongTextFluentHelper getAllMaintOrderOpLongText()
    {
        return new MaintOrderOpLongTextFluentHelper(servicePath, "MaintOrderOpLongText");
    }

    @Override
    @Nonnull
    public MaintOrderOpLongTextByKeyFluentHelper getMaintOrderOpLongTextByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String textObjectType,
        final String language )
    {
        return new MaintOrderOpLongTextByKeyFluentHelper(
            servicePath,
            "MaintOrderOpLongText",
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            textObjectType,
            language);
    }

    @Override
    @Nonnull
    public MaintOrderOpLongTextUpdateFluentHelper updateMaintOrderOpLongText(
        @Nonnull final MaintOrderOpLongText maintOrderOpLongText )
    {
        return new MaintOrderOpLongTextUpdateFluentHelper(servicePath, maintOrderOpLongText, "MaintOrderOpLongText");
    }

    @Override
    @Nonnull
    public MaintOrderOpLongTextDeleteFluentHelper deleteMaintOrderOpLongText(
        @Nonnull final MaintOrderOpLongText maintOrderOpLongText )
    {
        return new MaintOrderOpLongTextDeleteFluentHelper(servicePath, maintOrderOpLongText, "MaintOrderOpLongText");
    }

    @Override
    @Nonnull
    public MaintOrderOpPhaseControlFluentHelper getAllMaintOrderOpPhaseControl()
    {
        return new MaintOrderOpPhaseControlFluentHelper(servicePath, "MaintOrderOpPhaseControl");
    }

    @Override
    @Nonnull
    public MaintOrderOpPhaseControlByKeyFluentHelper getMaintOrderOpPhaseControlByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String maintenancePhaseControl )
    {
        return new MaintOrderOpPhaseControlByKeyFluentHelper(
            servicePath,
            "MaintOrderOpPhaseControl",
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            maintenancePhaseControl);
    }

    @Override
    @Nonnull
    public MaintOrderOpProdnRsceToolFluentHelper getAllMaintOrderOpProdnRsceTool()
    {
        return new MaintOrderOpProdnRsceToolFluentHelper(servicePath, "MaintOrderOpProdnRsceTool");
    }

    @Override
    @Nonnull
    public MaintOrderOpProdnRsceToolByKeyFluentHelper getMaintOrderOpProdnRsceToolByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String prodnRsceToolItemNumber )
    {
        return new MaintOrderOpProdnRsceToolByKeyFluentHelper(
            servicePath,
            "MaintOrderOpProdnRsceTool",
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            prodnRsceToolItemNumber);
    }

    @Override
    @Nonnull
    public MaintOrderOpProdnRsceToolUpdateFluentHelper updateMaintOrderOpProdnRsceTool(
        @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool )
    {
        return new MaintOrderOpProdnRsceToolUpdateFluentHelper(
            servicePath,
            maintOrderOpProdnRsceTool,
            "MaintOrderOpProdnRsceTool");
    }

    @Override
    @Nonnull
    public MaintOrderOpProdnRsceToolDeleteFluentHelper deleteMaintOrderOpProdnRsceTool(
        @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool )
    {
        return new MaintOrderOpProdnRsceToolDeleteFluentHelper(
            servicePath,
            maintOrderOpProdnRsceTool,
            "MaintOrderOpProdnRsceTool");
    }

    @Override
    @Nonnull
    public MaintOrderOpRelationshipFluentHelper getAllMaintOrderOpRelationship()
    {
        return new MaintOrderOpRelationshipFluentHelper(servicePath, "MaintOrderOpRelationship");
    }

    @Override
    @Nonnull
    public MaintOrderOpRelationshipByKeyFluentHelper getMaintOrderOpRelationshipByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final Boolean maintOrdOperationIsSuccessor,
        final String relatedMaintenanceOrder,
        final String relatedMaintOrderOperation,
        final String orderOpRelationshipIntType )
    {
        return new MaintOrderOpRelationshipByKeyFluentHelper(
            servicePath,
            "MaintOrderOpRelationship",
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            maintOrdOperationIsSuccessor,
            relatedMaintenanceOrder,
            relatedMaintOrderOperation,
            orderOpRelationshipIntType);
    }

    @Override
    @Nonnull
    public MaintOrderOpRelationshipUpdateFluentHelper updateMaintOrderOpRelationship(
        @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship )
    {
        return new MaintOrderOpRelationshipUpdateFluentHelper(
            servicePath,
            maintOrderOpRelationship,
            "MaintOrderOpRelationship");
    }

    @Override
    @Nonnull
    public MaintOrderOpRelationshipDeleteFluentHelper deleteMaintOrderOpRelationship(
        @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship )
    {
        return new MaintOrderOpRelationshipDeleteFluentHelper(
            servicePath,
            maintOrderOpRelationship,
            "MaintOrderOpRelationship");
    }

    @Override
    @Nonnull
    public MaintOrderSettlmtDistrRuleFluentHelper getAllMaintOrderSettlmtDistrRule()
    {
        return new MaintOrderSettlmtDistrRuleFluentHelper(servicePath, "MaintOrderSettlmtDistrRule");
    }

    @Override
    @Nonnull
    public
        MaintOrderSettlmtDistrRuleByKeyFluentHelper
        getMaintOrderSettlmtDistrRuleByKey( final String maintenanceOrder, final String settlmtDistrRuleSequence )
    {
        return new MaintOrderSettlmtDistrRuleByKeyFluentHelper(
            servicePath,
            "MaintOrderSettlmtDistrRule",
            maintenanceOrder,
            settlmtDistrRuleSequence);
    }

    @Override
    @Nonnull
    public MaintOrderSettlmtDistrRuleUpdateFluentHelper updateMaintOrderSettlmtDistrRule(
        @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule )
    {
        return new MaintOrderSettlmtDistrRuleUpdateFluentHelper(
            servicePath,
            maintOrderSettlmtDistrRule,
            "MaintOrderSettlmtDistrRule");
    }

    @Override
    @Nonnull
    public MaintOrderSettlmtDistrRuleDeleteFluentHelper deleteMaintOrderSettlmtDistrRule(
        @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule )
    {
        return new MaintOrderSettlmtDistrRuleDeleteFluentHelper(
            servicePath,
            maintOrderSettlmtDistrRule,
            "MaintOrderSettlmtDistrRule");
    }

    @Override
    @Nonnull
    public MaintOrdSettlmtDistrRuleHistFluentHelper getAllMaintOrdSettlmtDistrRuleHist()
    {
        return new MaintOrdSettlmtDistrRuleHistFluentHelper(servicePath, "MaintOrdSettlmtDistrRuleHist");
    }

    @Override
    @Nonnull
    public MaintOrdSettlmtDistrRuleHistByKeyFluentHelper getMaintOrdSettlmtDistrRuleHistByKey(
        final String maintenanceOrder,
        final String settlmtDistrRuleSequence,
        final String ledger )
    {
        return new MaintOrdSettlmtDistrRuleHistByKeyFluentHelper(
            servicePath,
            "MaintOrdSettlmtDistrRuleHist",
            maintenanceOrder,
            settlmtDistrRuleSequence,
            ledger);
    }

    @Override
    @Nonnull
    public ApproveMaintenanceOrderFluentHelper approveMaintenanceOrder( @Nonnull final String maintenanceOrder )
    {
        return new ApproveMaintenanceOrderFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public AssignMaintNotificationToOrderFluentHelper assignMaintNotificationToOrder(
        @Nonnull final String maintenanceOrder,
        @Nullable final String maintenanceNotification )
    {
        return new AssignMaintNotificationToOrderFluentHelper(servicePath, maintenanceOrder, maintenanceNotification);
    }

    @Override
    @Nonnull
    public AssignMaintNotificationToOrderFluentHelper assignMaintNotificationToOrder(
        @Nonnull final String maintenanceOrder,
        @Nullable final String maintenanceNotification,
        @Nullable final Boolean notificationIsHeaderNotif )
    {
        return new AssignMaintNotificationToOrderFluentHelper(
            servicePath,
            maintenanceOrder,
            maintenanceNotification,
            notificationIsHeaderNotif);
    }

    @Override
    @Nonnull
    public RejectMaintenanceOrderFluentHelper rejectMaintenanceOrder( @Nonnull final String maintenanceOrder )
    {
        return new RejectMaintenanceOrderFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public ReleaseMaintenanceOrderFluentHelper releaseMaintenanceOrder( @Nonnull final String maintenanceOrder )
    {
        return new ReleaseMaintenanceOrderFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public ResetMaintOrderStatusClosedFluentHelper resetMaintOrderStatusClosed( @Nonnull final String maintenanceOrder )
    {
        return new ResetMaintOrderStatusClosedFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public ResetMaintOrderStsRdyForSchedgFluentHelper resetMaintOrderStsRdyForSchedg(
        @Nonnull final String maintenanceOrder )
    {
        return new ResetMaintOrderStsRdyForSchedgFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public ResetMaintOrdOpsStsDispatchedFluentHelper resetMaintOrdOpsStsDispatched(
        @Nonnull final String maintenanceOrder )
    {
        return new ResetMaintOrdOpsStsDispatchedFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public ResetMaintOrdStsMainWorkCmpltFluentHelper resetMaintOrdStsMainWorkCmplt(
        @Nonnull final String maintenanceOrder )
    {
        return new ResetMaintOrdStsMainWorkCmpltFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public ResetMaintOrdStsMrkdForDeltnFluentHelper resetMaintOrdStsMrkdForDeltn(
        @Nonnull final String maintenanceOrder,
        @Nullable final Boolean assgdMaintNotifIsToBeResetDel )
    {
        return new ResetMaintOrdStsMrkdForDeltnFluentHelper(
            servicePath,
            maintenanceOrder,
            assgdMaintNotifIsToBeResetDel);
    }

    @Override
    @Nonnull
    public ResetMaintOrdStsTechCompletedFluentHelper resetMaintOrdStsTechCompleted(
        @Nonnull final String maintenanceOrder,
        @Nullable final Boolean assgdMaintNotifIsToBePutInProc )
    {
        return new ResetMaintOrdStsTechCompletedFluentHelper(
            servicePath,
            maintenanceOrder,
            assgdMaintNotifIsToBePutInProc);
    }

    @Override
    @Nonnull
    public ScheduleMaintenanceOrderFluentHelper scheduleMaintenanceOrder( @Nonnull final String maintenanceOrder )
    {
        return new ScheduleMaintenanceOrderFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public SetMaintOrderOpsToDispatchedFluentHelper setMaintOrderOpsToDispatched(
        @Nonnull final String maintenanceOrder )
    {
        return new SetMaintOrderOpsToDispatchedFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public SetMaintOrderStatusToClosedFluentHelper setMaintOrderStatusToClosed(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed )
    {
        return new SetMaintOrderStatusToClosedFluentHelper(
            servicePath,
            maintenanceOrder,
            maintOrderReferenceDateTime,
            assignedMaintNotifIsToBeClosed);
    }

    @Override
    @Nonnull
    public SetMaintOrderStatusToLockedFluentHelper setMaintOrderStatusToLocked( @Nonnull final String maintenanceOrder )
    {
        return new SetMaintOrderStatusToLockedFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public SetMaintOrderStatusToUnlockedFluentHelper setMaintOrderStatusToUnlocked(
        @Nonnull final String maintenanceOrder )
    {
        return new SetMaintOrderStatusToUnlockedFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public SetMaintOrderToDoNotExecuteFluentHelper setMaintOrderToDoNotExecute(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean assgdMaintNotifIsToBeRsetAlloc )
    {
        return new SetMaintOrderToDoNotExecuteFluentHelper(
            servicePath,
            maintenanceOrder,
            maintOrderReferenceDateTime,
            assignedMaintNotifIsToBeClosed,
            assgdMaintNotifIsToBeRsetAlloc);
    }

    @Override
    @Nonnull
    public SetMaintOrderToDoNotExecuteFluentHelper setMaintOrderToDoNotExecute(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean assgdMaintNotifIsToBeRsetAlloc,
        @Nullable final String maintOrdCancellationAction )
    {
        return new SetMaintOrderToDoNotExecuteFluentHelper(
            servicePath,
            maintenanceOrder,
            maintOrderReferenceDateTime,
            assignedMaintNotifIsToBeClosed,
            assgdMaintNotifIsToBeRsetAlloc,
            maintOrdCancellationAction);
    }

    @Override
    @Nonnull
    public SetMaintOrderToReadyForSchedgFluentHelper setMaintOrderToReadyForSchedg(
        @Nonnull final String maintenanceOrder )
    {
        return new SetMaintOrderToReadyForSchedgFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public SetMaintOrdStsToMrkdForDeltnFluentHelper setMaintOrdStsToMrkdForDeltn(
        @Nonnull final String maintenanceOrder,
        @Nullable final Boolean assgdMaintNotifIsToBeSetDel )
    {
        return new SetMaintOrdStsToMrkdForDeltnFluentHelper(servicePath, maintenanceOrder, assgdMaintNotifIsToBeSetDel);
    }

    @Override
    @Nonnull
    public SetMaintOrdToMainWorkCompleteFluentHelper setMaintOrdToMainWorkComplete(
        @Nonnull final String maintenanceOrder )
    {
        return new SetMaintOrdToMainWorkCompleteFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public SetMaintOrdToMainWorkCompleteFluentHelper setMaintOrdToMainWorkComplete(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime mainWorkCompletedDateTime,
        @Nullable final Boolean mainWrkCmpltdDateTimeIsUsed )
    {
        return new SetMaintOrdToMainWorkCompleteFluentHelper(
            servicePath,
            maintenanceOrder,
            mainWorkCompletedDateTime,
            mainWrkCmpltdDateTimeIsUsed);
    }

    @Override
    @Nonnull
    public SetMaintOrdToTechCompletedFluentHelper setMaintOrdToTechCompleted(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed )
    {
        return new SetMaintOrdToTechCompletedFluentHelper(
            servicePath,
            maintenanceOrder,
            maintOrderReferenceDateTime,
            assignedMaintNotifIsToBeClosed);
    }

    @Override
    @Nonnull
    public SetMaintOrdToTechCompletedFluentHelper setMaintOrdToTechCompleted(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean mainWrkCmpltdDateTimeIsUsed )
    {
        return new SetMaintOrdToTechCompletedFluentHelper(
            servicePath,
            maintenanceOrder,
            maintOrderReferenceDateTime,
            assignedMaintNotifIsToBeClosed,
            mainWrkCmpltdDateTimeIsUsed);
    }

    @Override
    @Nonnull
    public SubmitMaintOrderForApprovalFluentHelper submitMaintOrderForApproval( @Nonnull final String maintenanceOrder )
    {
        return new SubmitMaintOrderForApprovalFluentHelper(servicePath, maintenanceOrder);
    }

    @Override
    @Nonnull
    public ResetMaintOrderOpStsDispatchedFluentHelper resetMaintOrderOpStsDispatched(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation )
    {
        return new ResetMaintOrderOpStsDispatchedFluentHelper(
            servicePath,
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation);
    }

    @Override
    @Nonnull
    public SetMaintOrderOpToDispatchedFluentHelper setMaintOrderOpToDispatched(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation )
    {
        return new SetMaintOrderOpToDispatchedFluentHelper(
            servicePath,
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation);
    }

    @Override
    @Nonnull
    public ActvtMaintOrderPhaseControlFluentHelper actvtMaintOrderPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenancePhaseControl )
    {
        return new ActvtMaintOrderPhaseControlFluentHelper(servicePath, maintenanceOrder, maintenancePhaseControl);
    }

    @Override
    @Nonnull
    public DactvtMaintOrderPhaseControlFluentHelper dactvtMaintOrderPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenancePhaseControl )
    {
        return new DactvtMaintOrderPhaseControlFluentHelper(servicePath, maintenanceOrder, maintenancePhaseControl);
    }

    @Override
    @Nonnull
    public ActvtMaintOrderOpPhaseControlFluentHelper actvtMaintOrderOpPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation,
        @Nonnull final String maintenancePhaseControl )
    {
        return new ActvtMaintOrderOpPhaseControlFluentHelper(
            servicePath,
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            maintenancePhaseControl);
    }

    @Override
    @Nonnull
    public DactvtMaintOrderOpPhaseControlFluentHelper dactvtMaintOrderOpPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation,
        @Nonnull final String maintenancePhaseControl )
    {
        return new DactvtMaintOrderOpPhaseControlFluentHelper(
            servicePath,
            maintenanceOrder,
            maintenanceOrderOperation,
            maintenanceOrderSubOperation,
            maintenancePhaseControl);
    }

}
