/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.AssignMaintItemToMaintPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassCharByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassCharFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanScheduleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.ResetMaintPlanStsMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.RestartMaintPlnScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMainPlanStsToMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMaintPlanStatusToActiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMaintPlanStatusToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.StartMaintPlnScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.StartScheduleInCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.batch.DefaultMaintenancePlanServiceBatch;

/**
 * <p>
 *
 * This API allows you to read, create, and update maintenance plans. It contains maintenance plans, schedules,
 * maintenance items, maintenance cycles and classification details. 
 *
 * The request contains all the information that is necessary to read, create, and update maintenance plans. If the
 * input in the request is not as expected, the system displays appropriate error or warning messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b5/f4fb481598452bb72c8169c2eedb03/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEPLAN?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEPLAN</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Planning Integration(SAP_COM_0396)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4X5'>Recurring Services(4X5)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Plan</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaintenancePlanService" )
@Deprecated
public class DefaultMaintenancePlanService implements MaintenancePlanService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaintenancePlanService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaintenancePlanService()
    {
        servicePath = MaintenancePlanService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaintenancePlanService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaintenancePlanService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaintenancePlanService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaintenancePlanServiceBatch batch()
    {
        return new DefaultMaintenancePlanServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaintenanceItemFluentHelper getAllMaintenanceItem()
    {
        return new MaintenanceItemFluentHelper(servicePath, "MaintenanceItem");
    }

    @Override
    @Nonnull
    public MaintenanceItemByKeyFluentHelper getMaintenanceItemByKey( final String maintenanceItem )
    {
        return new MaintenanceItemByKeyFluentHelper(servicePath, "MaintenanceItem", maintenanceItem);
    }

    @Override
    @Nonnull
    public MaintenanceItemCreateFluentHelper createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return new MaintenanceItemCreateFluentHelper(servicePath, maintenanceItem, "MaintenanceItem");
    }

    @Override
    @Nonnull
    public MaintenanceItemUpdateFluentHelper updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return new MaintenanceItemUpdateFluentHelper(servicePath, maintenanceItem, "MaintenanceItem");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseFluentHelper getAllMaintenanceItemCause()
    {
        return new MaintenanceItemCauseFluentHelper(servicePath, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public
        MaintenanceItemCauseByKeyFluentHelper
        getMaintenanceItemCauseByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems )
    {
        return new MaintenanceItemCauseByKeyFluentHelper(
            servicePath,
            "MaintenanceItemCause",
            maintenanceItem,
            nmbrOfMaintComplianceItems);
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseCreateFluentHelper createMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return new MaintenanceItemCauseCreateFluentHelper(servicePath, maintenanceItemCause, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseUpdateFluentHelper updateMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return new MaintenanceItemCauseUpdateFluentHelper(servicePath, maintenanceItemCause, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseDeleteFluentHelper deleteMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return new MaintenanceItemCauseDeleteFluentHelper(servicePath, maintenanceItemCause, "MaintenanceItemCause");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextFluentHelper getAllMaintenanceItemCauseText()
    {
        return new MaintenanceItemCauseTextFluentHelper(servicePath, "MaintenanceItemCauseText");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextByKeyFluentHelper getMaintenanceItemCauseTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language )
    {
        return new MaintenanceItemCauseTextByKeyFluentHelper(
            servicePath,
            "MaintenanceItemCauseText",
            maintenanceItem,
            nmbrOfMaintComplianceItems,
            language);
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextUpdateFluentHelper updateMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return new MaintenanceItemCauseTextUpdateFluentHelper(
            servicePath,
            maintenanceItemCauseText,
            "MaintenanceItemCauseText");
    }

    @Override
    @Nonnull
    public MaintenanceItemCauseTextDeleteFluentHelper deleteMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return new MaintenanceItemCauseTextDeleteFluentHelper(
            servicePath,
            maintenanceItemCauseText,
            "MaintenanceItemCauseText");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonFluentHelper getAllMaintenanceItemReason()
    {
        return new MaintenanceItemReasonFluentHelper(servicePath, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public
        MaintenanceItemReasonByKeyFluentHelper
        getMaintenanceItemReasonByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems )
    {
        return new MaintenanceItemReasonByKeyFluentHelper(
            servicePath,
            "MaintenanceItemReason",
            maintenanceItem,
            nmbrOfMaintComplianceItems);
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonCreateFluentHelper createMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return new MaintenanceItemReasonCreateFluentHelper(servicePath, maintenanceItemReason, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonUpdateFluentHelper updateMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return new MaintenanceItemReasonUpdateFluentHelper(servicePath, maintenanceItemReason, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonDeleteFluentHelper deleteMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return new MaintenanceItemReasonDeleteFluentHelper(servicePath, maintenanceItemReason, "MaintenanceItemReason");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextFluentHelper getAllMaintenanceItemReasonText()
    {
        return new MaintenanceItemReasonTextFluentHelper(servicePath, "MaintenanceItemReasonText");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextByKeyFluentHelper getMaintenanceItemReasonTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language )
    {
        return new MaintenanceItemReasonTextByKeyFluentHelper(
            servicePath,
            "MaintenanceItemReasonText",
            maintenanceItem,
            nmbrOfMaintComplianceItems,
            language);
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextUpdateFluentHelper updateMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return new MaintenanceItemReasonTextUpdateFluentHelper(
            servicePath,
            maintenanceItemReasonText,
            "MaintenanceItemReasonText");
    }

    @Override
    @Nonnull
    public MaintenanceItemReasonTextDeleteFluentHelper deleteMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return new MaintenanceItemReasonTextDeleteFluentHelper(
            servicePath,
            maintenanceItemReasonText,
            "MaintenanceItemReasonText");
    }

    @Override
    @Nonnull
    public MaintenanceItemTextFluentHelper getAllMaintenanceItemText()
    {
        return new MaintenanceItemTextFluentHelper(servicePath, "MaintenanceItemText");
    }

    @Override
    @Nonnull
    public
        MaintenanceItemTextByKeyFluentHelper
        getMaintenanceItemTextByKey( final String maintenanceItem, final String language )
    {
        return new MaintenanceItemTextByKeyFluentHelper(servicePath, "MaintenanceItemText", maintenanceItem, language);
    }

    @Override
    @Nonnull
    public MaintenanceItemTextUpdateFluentHelper updateMaintenanceItemText(
        @Nonnull final MaintenanceItemText maintenanceItemText )
    {
        return new MaintenanceItemTextUpdateFluentHelper(servicePath, maintenanceItemText, "MaintenanceItemText");
    }

    @Override
    @Nonnull
    public MaintenancePlanFluentHelper getAllMaintenancePlan()
    {
        return new MaintenancePlanFluentHelper(servicePath, "MaintenancePlan");
    }

    @Override
    @Nonnull
    public MaintenancePlanByKeyFluentHelper getMaintenancePlanByKey( final String maintenancePlan )
    {
        return new MaintenancePlanByKeyFluentHelper(servicePath, "MaintenancePlan", maintenancePlan);
    }

    @Override
    @Nonnull
    public MaintenancePlanCreateFluentHelper createMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan )
    {
        return new MaintenancePlanCreateFluentHelper(servicePath, maintenancePlan, "MaintenancePlan");
    }

    @Override
    @Nonnull
    public MaintenancePlanUpdateFluentHelper updateMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan )
    {
        return new MaintenancePlanUpdateFluentHelper(servicePath, maintenancePlan, "MaintenancePlan");
    }

    @Override
    @Nonnull
    public MaintenancePlanCycleFluentHelper getAllMaintenancePlanCycle()
    {
        return new MaintenancePlanCycleFluentHelper(servicePath, "MaintenancePlanCycle");
    }

    @Override
    @Nonnull
    public
        MaintenancePlanCycleByKeyFluentHelper
        getMaintenancePlanCycleByKey( final String maintenancePlan, final String maintenancePlanCycle )
    {
        return new MaintenancePlanCycleByKeyFluentHelper(
            servicePath,
            "MaintenancePlanCycle",
            maintenancePlan,
            maintenancePlanCycle);
    }

    @Override
    @Nonnull
    public MaintenancePlanCycleUpdateFluentHelper updateMaintenancePlanCycle(
        @Nonnull final MaintenancePlanCycle maintenancePlanCycle )
    {
        return new MaintenancePlanCycleUpdateFluentHelper(servicePath, maintenancePlanCycle, "MaintenancePlanCycle");
    }

    @Override
    @Nonnull
    public MaintenancePlanScheduleFluentHelper getAllMaintenancePlanSchedule()
    {
        return new MaintenancePlanScheduleFluentHelper(servicePath, "MaintenancePlanSchedule");
    }

    @Override
    @Nonnull
    public MaintenancePlanScheduleByKeyFluentHelper getMaintenancePlanScheduleByKey(
        final String maintenancePlan,
        final Integer maintenancePlanCallNumber,
        final String maintenancePackage )
    {
        return new MaintenancePlanScheduleByKeyFluentHelper(
            servicePath,
            "MaintenancePlanSchedule",
            maintenancePlan,
            maintenancePlanCallNumber,
            maintenancePackage);
    }

    @Override
    @Nonnull
    public MaintenancePlanTextFluentHelper getAllMaintenancePlanText()
    {
        return new MaintenancePlanTextFluentHelper(servicePath, "MaintenancePlanText");
    }

    @Override
    @Nonnull
    public
        MaintenancePlanTextByKeyFluentHelper
        getMaintenancePlanTextByKey( final String maintenancePlan, final String language )
    {
        return new MaintenancePlanTextByKeyFluentHelper(servicePath, "MaintenancePlanText", maintenancePlan, language);
    }

    @Override
    @Nonnull
    public MaintenancePlanTextUpdateFluentHelper updateMaintenancePlanText(
        @Nonnull final MaintenancePlanText maintenancePlanText )
    {
        return new MaintenancePlanTextUpdateFluentHelper(servicePath, maintenancePlanText, "MaintenancePlanText");
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemFluentHelper getAllMaintItemObjectListItem()
    {
        return new MaintItemObjectListItemFluentHelper(servicePath, "MaintItemObjectListItem");
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemByKeyFluentHelper getMaintItemObjectListItemByKey(
        final String maintenanceItem,
        final Long maintenanceItemObjectList,
        final Integer maintenanceObjectListItem )
    {
        return new MaintItemObjectListItemByKeyFluentHelper(
            servicePath,
            "MaintItemObjectListItem",
            maintenanceItem,
            maintenanceItemObjectList,
            maintenanceObjectListItem);
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemUpdateFluentHelper updateMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return new MaintItemObjectListItemUpdateFluentHelper(
            servicePath,
            maintItemObjectListItem,
            "MaintItemObjectListItem");
    }

    @Override
    @Nonnull
    public MaintItemObjectListItemDeleteFluentHelper deleteMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return new MaintItemObjectListItemDeleteFluentHelper(
            servicePath,
            maintItemObjectListItem,
            "MaintItemObjectListItem");
    }

    @Override
    @Nonnull
    public MaintenancePlanCallObjectFluentHelper getAllMaintenancePlanCallObject()
    {
        return new MaintenancePlanCallObjectFluentHelper(servicePath, "MaintenancePlanCallObject");
    }

    @Override
    @Nonnull
    public MaintenancePlanCallObjectByKeyFluentHelper getMaintenancePlanCallObjectByKey(
        final String maintenancePlan,
        final Integer maintenancePlanCallNumber,
        final String maintenanceItem )
    {
        return new MaintenancePlanCallObjectByKeyFluentHelper(
            servicePath,
            "MaintenancePlanCallObject",
            maintenancePlan,
            maintenancePlanCallNumber,
            maintenanceItem);
    }

    @Override
    @Nonnull
    public MaintPlanClfnCharValueFluentHelper getAllMaintPlanClfnCharValue()
    {
        return new MaintPlanClfnCharValueFluentHelper(servicePath, "MaintPlanClfnCharValue");
    }

    @Override
    @Nonnull
    public MaintPlanClfnCharValueByKeyFluentHelper getMaintPlanClfnCharValueByKey(
        final String maintenancePlan,
        final String classType,
        final String clfnCharcValuePositionNumber,
        final String charcInternalID )
    {
        return new MaintPlanClfnCharValueByKeyFluentHelper(
            servicePath,
            "MaintPlanClfnCharValue",
            maintenancePlan,
            classType,
            clfnCharcValuePositionNumber,
            charcInternalID);
    }

    @Override
    @Nonnull
    public MaintPlanClfnClassFluentHelper getAllMaintPlanClfnClass()
    {
        return new MaintPlanClfnClassFluentHelper(servicePath, "MaintPlanClfnClass");
    }

    @Override
    @Nonnull
    public
        MaintPlanClfnClassByKeyFluentHelper
        getMaintPlanClfnClassByKey( final String maintenancePlan, final String classInternalID, final String classType )
    {
        return new MaintPlanClfnClassByKeyFluentHelper(
            servicePath,
            "MaintPlanClfnClass",
            maintenancePlan,
            classInternalID,
            classType);
    }

    @Override
    @Nonnull
    public MaintPlanClfnClassCharFluentHelper getAllMaintPlanClfnClassChar()
    {
        return new MaintPlanClfnClassCharFluentHelper(servicePath, "MaintPlanClfnClassChar");
    }

    @Override
    @Nonnull
    public MaintPlanClfnClassCharByKeyFluentHelper getMaintPlanClfnClassCharByKey(
        final String maintenancePlan,
        final String classInternalID,
        final String charcInternalID )
    {
        return new MaintPlanClfnClassCharByKeyFluentHelper(
            servicePath,
            "MaintPlanClfnClassChar",
            maintenancePlan,
            classInternalID,
            charcInternalID);
    }

    @Override
    @Nonnull
    public MaintenancePlanStrategyCycleFluentHelper getAllMaintenancePlanStrategyCycle()
    {
        return new MaintenancePlanStrategyCycleFluentHelper(servicePath, "MaintenancePlanStrategyCycle");
    }

    @Override
    @Nonnull
    public
        MaintenancePlanStrategyCycleByKeyFluentHelper
        getMaintenancePlanStrategyCycleByKey( final String maintenancePlan, final String maintenancePlanCycle )
    {
        return new MaintenancePlanStrategyCycleByKeyFluentHelper(
            servicePath,
            "MaintenancePlanStrategyCycle",
            maintenancePlan,
            maintenancePlanCycle);
    }

    @Override
    @Nonnull
    public
        AssignMaintItemToMaintPlanFluentHelper
        assignMaintItemToMaintPlan( @Nonnull final String maintenancePlan, @Nonnull final String maintenanceitem )
    {
        return new AssignMaintItemToMaintPlanFluentHelper(servicePath, maintenancePlan, maintenanceitem);
    }

    @Override
    @Nonnull
    public ResetMaintPlanStsMrkdForDeltnFluentHelper resetMaintPlanStsMrkdForDeltn(
        @Nonnull final String maintenancePlan )
    {
        return new ResetMaintPlanStsMrkdForDeltnFluentHelper(servicePath, maintenancePlan);
    }

    @Override
    @Nonnull
    public RestartMaintPlnScheduleFluentHelper restartMaintPlnSchedule(
        @Nonnull final String maintenancePlan,
        @Nullable final LocalDateTime schedulingStartDate,
        @Nullable final LocalTime schedulingStartTime,
        @Nullable final String maintPlanStartCntrReadingValue,
        @Nullable final Boolean maintPlanSchedFutrCallsAreKept )
    {
        return new RestartMaintPlnScheduleFluentHelper(
            servicePath,
            maintenancePlan,
            schedulingStartDate,
            schedulingStartTime,
            maintPlanStartCntrReadingValue,
            maintPlanSchedFutrCallsAreKept);
    }

    @Override
    @Nonnull
    public SetMainPlanStsToMrkdForDeltnFluentHelper setMainPlanStsToMrkdForDeltn(
        @Nonnull final String maintenancePlan )
    {
        return new SetMainPlanStsToMrkdForDeltnFluentHelper(servicePath, maintenancePlan);
    }

    @Override
    @Nonnull
    public SetMaintPlanStatusToActiveFluentHelper setMaintPlanStatusToActive( @Nonnull final String maintenancePlan )
    {
        return new SetMaintPlanStatusToActiveFluentHelper(servicePath, maintenancePlan);
    }

    @Override
    @Nonnull
    public SetMaintPlanStatusToInactiveFluentHelper setMaintPlanStatusToInactive(
        @Nonnull final String maintenancePlan )
    {
        return new SetMaintPlanStatusToInactiveFluentHelper(servicePath, maintenancePlan);
    }

    @Override
    @Nonnull
    public StartMaintPlnScheduleFluentHelper startMaintPlnSchedule(
        @Nonnull final String maintenancePlan,
        @Nullable final LocalDateTime schedulingStartDate,
        @Nullable final LocalTime schedulingStartTime,
        @Nullable final String maintPlanStartCntrReadingValue,
        @Nullable final LocalDateTime maintPlnSchedgCallObjUpToDte )
    {
        return new StartMaintPlnScheduleFluentHelper(
            servicePath,
            maintenancePlan,
            schedulingStartDate,
            schedulingStartTime,
            maintPlanStartCntrReadingValue,
            maintPlnSchedgCallObjUpToDte);
    }

    @Override
    @Nonnull
    public StartScheduleInCycleFluentHelper startScheduleInCycle(
        @Nonnull final String maintenancePlan,
        @Nullable final String maintenancePackage,
        @Nullable final Integer maintPlanCycleOffsetValue,
        @Nullable final String maintenanceTaskPerformanceUnit,
        @Nullable final Boolean maintPlanSchedFutrCallsAreKept,
        @Nullable final LocalDateTime completionDate,
        @Nullable final LocalTime completionTime,
        @Nullable final String maintPlnCallCompltnCntrRdngVal )
    {
        return new StartScheduleInCycleFluentHelper(
            servicePath,
            maintenancePlan,
            maintenancePackage,
            maintPlanCycleOffsetValue,
            maintenanceTaskPerformanceUnit,
            maintPlanSchedFutrCallsAreKept,
            completionDate,
            completionTime,
            maintPlnCallCompltnCntrRdngVal);
    }

}
