/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.Post_manual_accrualsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.batch.DefaultManualContractAccrualServiceBatch;

/**
 * <p>
 *
 * This service enables you to post manual contract accruals that are relevant for revenue recognition processing. The
 * cost or revenue adjustments are not changed by the Revenue Recognition Run. The adjustments are posted to extra
 * accounts. When the stage of the project can be considered as completed, they are canceled by the next closing run.
 * The service will group entries with the same WBS Element, Fiscal Period, Fiscal Year, and Ledger and only posts one
 * document in the system..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/89/5ee34567e04e438d9b2a2d718408a8/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_EBRR_MANUAL_ACCRUALS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_EBRR_MANUAL_ACCRUALS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - EBRR Manual Accruals Integration(SAP_COM_0705)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1IL'>Event-Based Revenue Recognition - Project-Based
 * Services(1IL)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1P0'>Event-Based Revenue Recognition -
 * Project-Based Services - IFRS(1P0)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/33O'>Event-Based Revenue
 * Recognition - Project-Based Services - US GAAP(33O)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4GQ'>Event-Based Revenue Recognition - Project-Based Sales(4GQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4GR'>Event-Based Revenue Recognition - Project-Based Sales -
 * IFRS(4GR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GS'>Event-Based Revenue Recognition - Project-Based
 * Sales - US GAAP(4GS)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Journal Entry</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultManualContractAccrualService" )
@Deprecated
public class DefaultManualContractAccrualService implements ManualContractAccrualService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ManualContractAccrualService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultManualContractAccrualService()
    {
        servicePath = ManualContractAccrualService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultManualContractAccrualService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultManualContractAccrualService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultManualContractAccrualService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultManualContractAccrualServiceBatch batch()
    {
        return new DefaultManualContractAccrualServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public Post_manual_accrualsFluentHelper post_manual_accruals( @Nonnull final String accrualDataJSON )
    {
        return new Post_manual_accrualsFluentHelper(servicePath, accrualDataJSON);
    }

}
