/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.batch.DefaultMasterInspectionCharacteristicServiceBatch;

/**
 * <p>
 *
 * A master inspection characteristic is a master data record that describes the quality inspection criteria for
 * materials. This service enables you to retrieve, for example, the settings and the control indicators defined for a
 * master inspection characteristic..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/71/644958b4ae9144e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MASTERINSPCHARACTERISTIC_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MASTERINSPCHARACTERISTIC_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Specification</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMasterInspectionCharacteristicService" )
@Deprecated
public class DefaultMasterInspectionCharacteristicService implements MasterInspectionCharacteristicService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MasterInspectionCharacteristicService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMasterInspectionCharacteristicService()
    {
        servicePath = MasterInspectionCharacteristicService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMasterInspectionCharacteristicService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMasterInspectionCharacteristicService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMasterInspectionCharacteristicService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMasterInspectionCharacteristicServiceBatch batch()
    {
        return new DefaultMasterInspectionCharacteristicServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public InspectionSpecificationFluentHelper getAllInspectionSpecification()
    {
        return new InspectionSpecificationFluentHelper(servicePath, "A_InspectionSpecification");
    }

    @Override
    @Nonnull
    public InspectionSpecificationByKeyFluentHelper getInspectionSpecificationByKey(
        final String inspectionSpecification,
        final String inspectionSpecificationVersion,
        final String inspectionSpecificationPlant )
    {
        return new InspectionSpecificationByKeyFluentHelper(
            servicePath,
            "A_InspectionSpecification",
            inspectionSpecification,
            inspectionSpecificationVersion,
            inspectionSpecificationPlant);
    }

    @Override
    @Nonnull
    public InspectionSpecificationTextFluentHelper getAllInspectionSpecificationText()
    {
        return new InspectionSpecificationTextFluentHelper(servicePath, "A_InspectionSpecificationText");
    }

    @Override
    @Nonnull
    public InspectionSpecificationTextByKeyFluentHelper getInspectionSpecificationTextByKey(
        final String inspectionSpecification,
        final String inspectionSpecificationVersion,
        final String inspectionSpecificationPlant,
        final String language )
    {
        return new InspectionSpecificationTextByKeyFluentHelper(
            servicePath,
            "A_InspectionSpecificationText",
            inspectionSpecification,
            inspectionSpecificationVersion,
            inspectionSpecificationPlant,
            language);
    }

}
