/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAllocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAllocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.batch.DefaultMasterRecipeServiceBatch;

/**
 * <p>
 *
 * Master recipes are used for planning the manufacture of products. It is used as a reference for process orders and in
 * calculating the costs of products.
 *
 * Master recipe is a description of the operations or phases (steps in a process) that must be carried out in a certain
 * order to manufacture a product. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4d/9ed891a8c547c493e70dbfdcbea7bb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MASTER_RECIPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MASTER_RECIPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.2</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Master Data Integration(SAP_COM_0519)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Master Recipe</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMasterRecipeService" )
@Deprecated
public class DefaultMasterRecipeService implements MasterRecipeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MasterRecipeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMasterRecipeService()
    {
        servicePath = MasterRecipeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMasterRecipeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMasterRecipeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMasterRecipeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMasterRecipeServiceBatch batch()
    {
        return new DefaultMasterRecipeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MasterRecipeHeaderFluentHelper getAllMasterRecipeHeader()
    {
        return new MasterRecipeHeaderFluentHelper(servicePath, "MasterRecipeHeader");
    }

    @Override
    @Nonnull
    public MasterRecipeHeaderByKeyFluentHelper getMasterRecipeHeaderByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeInternalVersion )
    {
        return new MasterRecipeHeaderByKeyFluentHelper(
            servicePath,
            "MasterRecipeHeader",
            masterRecipeGroup,
            masterRecipe,
            masterRecipeInternalVersion);
    }

    @Override
    @Nonnull
    public MasterRecipeHeaderCreateFluentHelper createMasterRecipeHeader(
        @Nonnull final MasterRecipeHeader masterRecipeHeader )
    {
        return new MasterRecipeHeaderCreateFluentHelper(servicePath, masterRecipeHeader, "MasterRecipeHeader");
    }

    @Override
    @Nonnull
    public MasterRecipeHeaderUpdateFluentHelper updateMasterRecipeHeader(
        @Nonnull final MasterRecipeHeader masterRecipeHeader )
    {
        return new MasterRecipeHeaderUpdateFluentHelper(servicePath, masterRecipeHeader, "MasterRecipeHeader");
    }

    @Override
    @Nonnull
    public MasterRecipeMatlAssgmtFluentHelper getAllMasterRecipeMatlAssgmt()
    {
        return new MasterRecipeMatlAssgmtFluentHelper(servicePath, "MasterRecipeMatlAssgmt");
    }

    @Override
    @Nonnull
    public MasterRecipeMatlAssgmtByKeyFluentHelper getMasterRecipeMatlAssgmtByKey(
        final String product,
        final String plant,
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeMaterialAssignment,
        final String mstrRcpMatlAssgmtIntVersion )
    {
        return new MasterRecipeMatlAssgmtByKeyFluentHelper(
            servicePath,
            "MasterRecipeMatlAssgmt",
            product,
            plant,
            masterRecipeGroup,
            masterRecipe,
            masterRecipeMaterialAssignment,
            mstrRcpMatlAssgmtIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipeOpCompAllocFluentHelper getAllMasterRecipeOpCompAlloc()
    {
        return new MasterRecipeOpCompAllocFluentHelper(servicePath, "MasterRecipeOpCompAlloc");
    }

    @Override
    @Nonnull
    public MasterRecipeOpCompAllocByKeyFluentHelper getMasterRecipeOpCompAllocByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOpBOMItemInternalID,
        final String mstrRcpOpBOMItemIntVersion )
    {
        return new MasterRecipeOpCompAllocByKeyFluentHelper(
            servicePath,
            "MasterRecipeOpCompAlloc",
            masterRecipeGroup,
            masterRecipe,
            masterRecipeOperationIntID,
            mstrRcpOpBOMItemInternalID,
            mstrRcpOpBOMItemIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipeOperationFluentHelper getAllMasterRecipeOperation()
    {
        return new MasterRecipeOperationFluentHelper(servicePath, "MasterRecipeOperation");
    }

    @Override
    @Nonnull
    public MasterRecipeOperationByKeyFluentHelper getMasterRecipeOperationByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOperationIntVersion )
    {
        return new MasterRecipeOperationByKeyFluentHelper(
            servicePath,
            "MasterRecipeOperation",
            masterRecipeGroup,
            masterRecipe,
            masterRecipeOperationIntID,
            mstrRcpOperationIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipeOperationCreateFluentHelper createMasterRecipeOperation(
        @Nonnull final MasterRecipeOperation masterRecipeOperation )
    {
        return new MasterRecipeOperationCreateFluentHelper(servicePath, masterRecipeOperation, "MasterRecipeOperation");
    }

    @Override
    @Nonnull
    public MasterRecipeOperationUpdateFluentHelper updateMasterRecipeOperation(
        @Nonnull final MasterRecipeOperation masterRecipeOperation )
    {
        return new MasterRecipeOperationUpdateFluentHelper(servicePath, masterRecipeOperation, "MasterRecipeOperation");
    }

    @Override
    @Nonnull
    public MasterRecipeOpSecdryRsceFluentHelper getAllMasterRecipeOpSecdryRsce()
    {
        return new MasterRecipeOpSecdryRsceFluentHelper(servicePath, "MasterRecipeOpSecdryRsce");
    }

    @Override
    @Nonnull
    public MasterRecipeOpSecdryRsceByKeyFluentHelper getMasterRecipeOpSecdryRsceByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOperationIntVersion )
    {
        return new MasterRecipeOpSecdryRsceByKeyFluentHelper(
            servicePath,
            "MasterRecipeOpSecdryRsce",
            masterRecipeGroup,
            masterRecipe,
            masterRecipeOperationIntID,
            mstrRcpOperationIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipeOpSecdryRsceCreateFluentHelper createMasterRecipeOpSecdryRsce(
        @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce )
    {
        return new MasterRecipeOpSecdryRsceCreateFluentHelper(
            servicePath,
            masterRecipeOpSecdryRsce,
            "MasterRecipeOpSecdryRsce");
    }

    @Override
    @Nonnull
    public MasterRecipeOpSecdryRsceUpdateFluentHelper updateMasterRecipeOpSecdryRsce(
        @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce )
    {
        return new MasterRecipeOpSecdryRsceUpdateFluentHelper(
            servicePath,
            masterRecipeOpSecdryRsce,
            "MasterRecipeOpSecdryRsce");
    }

    @Override
    @Nonnull
    public MasterRecipePhaseFluentHelper getAllMasterRecipePhase()
    {
        return new MasterRecipePhaseFluentHelper(servicePath, "MasterRecipePhase");
    }

    @Override
    @Nonnull
    public MasterRecipePhaseByKeyFluentHelper getMasterRecipePhaseByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpSuperiorOpIntVersion,
        final String mstrRcpOperationIntVersion )
    {
        return new MasterRecipePhaseByKeyFluentHelper(
            servicePath,
            "MasterRecipePhase",
            masterRecipeGroup,
            masterRecipe,
            masterRecipeOperationIntID,
            mstrRcpSuperiorOpIntVersion,
            mstrRcpOperationIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipePhaseCreateFluentHelper createMasterRecipePhase(
        @Nonnull final MasterRecipePhase masterRecipePhase )
    {
        return new MasterRecipePhaseCreateFluentHelper(servicePath, masterRecipePhase, "MasterRecipePhase");
    }

    @Override
    @Nonnull
    public MasterRecipePhaseUpdateFluentHelper updateMasterRecipePhase(
        @Nonnull final MasterRecipePhase masterRecipePhase )
    {
        return new MasterRecipePhaseUpdateFluentHelper(servicePath, masterRecipePhase, "MasterRecipePhase");
    }

    @Override
    @Nonnull
    public MasterRecipePhseCompAllocFluentHelper getAllMasterRecipePhseCompAlloc()
    {
        return new MasterRecipePhseCompAllocFluentHelper(servicePath, "MasterRecipePhseCompAlloc");
    }

    @Override
    @Nonnull
    public MasterRecipePhseCompAllocByKeyFluentHelper getMasterRecipePhseCompAllocByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOpBOMItemInternalID,
        final String mstrRcpOpBOMItemIntVersion )
    {
        return new MasterRecipePhseCompAllocByKeyFluentHelper(
            servicePath,
            "MasterRecipePhseCompAlloc",
            masterRecipeGroup,
            masterRecipe,
            masterRecipeOperationIntID,
            mstrRcpOpBOMItemInternalID,
            mstrRcpOpBOMItemIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipePhseCompAllocCreateFluentHelper createMasterRecipePhseCompAlloc(
        @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc )
    {
        return new MasterRecipePhseCompAllocCreateFluentHelper(
            servicePath,
            masterRecipePhseCompAlloc,
            "MasterRecipePhseCompAlloc");
    }

    @Override
    @Nonnull
    public MasterRecipePhseCompAllocUpdateFluentHelper updateMasterRecipePhseCompAlloc(
        @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc )
    {
        return new MasterRecipePhseCompAllocUpdateFluentHelper(
            servicePath,
            masterRecipePhseCompAlloc,
            "MasterRecipePhseCompAlloc");
    }

    @Override
    @Nonnull
    public MasterRecipePhseSecdryRsceFluentHelper getAllMasterRecipePhseSecdryRsce()
    {
        return new MasterRecipePhseSecdryRsceFluentHelper(servicePath, "MasterRecipePhseSecdryRsce");
    }

    @Override
    @Nonnull
    public MasterRecipePhseSecdryRsceByKeyFluentHelper getMasterRecipePhseSecdryRsceByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOperationIntVersion )
    {
        return new MasterRecipePhseSecdryRsceByKeyFluentHelper(
            servicePath,
            "MasterRecipePhseSecdryRsce",
            masterRecipeGroup,
            masterRecipe,
            masterRecipeOperationIntID,
            mstrRcpOperationIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipePhseSecdryRsceCreateFluentHelper createMasterRecipePhseSecdryRsce(
        @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce )
    {
        return new MasterRecipePhseSecdryRsceCreateFluentHelper(
            servicePath,
            masterRecipePhseSecdryRsce,
            "MasterRecipePhseSecdryRsce");
    }

    @Override
    @Nonnull
    public MasterRecipePhseSecdryRsceUpdateFluentHelper updateMasterRecipePhseSecdryRsce(
        @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce )
    {
        return new MasterRecipePhseSecdryRsceUpdateFluentHelper(
            servicePath,
            masterRecipePhseSecdryRsce,
            "MasterRecipePhseSecdryRsce");
    }

    @Override
    @Nonnull
    public MasterRecipePhseRelshpFluentHelper getAllMasterRecipePhseRelshp()
    {
        return new MasterRecipePhseRelshpFluentHelper(servicePath, "MasterRecipePhseRelshp");
    }

    @Override
    @Nonnull
    public MasterRecipePhseRelshpByKeyFluentHelper getMasterRecipePhseRelshpByKey(
        final String prdcssrMasterRecipeGroup,
        final String prdcssrMasterRecipe,
        final String prdcssrMstrRcpOpInternalID,
        final String succssrMasterRecipeGroup,
        final String succssrMasterRecipe,
        final String succssrMstrRcpOpInternalID,
        final String masterRecipeRelationshipType,
        final Boolean maxTimeIntvlIsUsedForSchedg,
        final String mstrRcpRelationshipIntVersion )
    {
        return new MasterRecipePhseRelshpByKeyFluentHelper(
            servicePath,
            "MasterRecipePhseRelshp",
            prdcssrMasterRecipeGroup,
            prdcssrMasterRecipe,
            prdcssrMstrRcpOpInternalID,
            succssrMasterRecipeGroup,
            succssrMasterRecipe,
            succssrMstrRcpOpInternalID,
            masterRecipeRelationshipType,
            maxTimeIntvlIsUsedForSchedg,
            mstrRcpRelationshipIntVersion);
    }

    @Override
    @Nonnull
    public MasterRecipePhseRelshpCreateFluentHelper createMasterRecipePhseRelshp(
        @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp )
    {
        return new MasterRecipePhseRelshpCreateFluentHelper(
            servicePath,
            masterRecipePhseRelshp,
            "MasterRecipePhseRelshp");
    }

    @Override
    @Nonnull
    public MasterRecipePhseRelshpUpdateFluentHelper updateMasterRecipePhseRelshp(
        @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp )
    {
        return new MasterRecipePhseRelshpUpdateFluentHelper(
            servicePath,
            masterRecipePhseRelshp,
            "MasterRecipePhseRelshp");
    }

}
