/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.CancelItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.batch.DefaultMaterialDocumentServiceBatch;

/**
 * <p>
 *
 * This service enables you to retrieve and create material documents, for example, to post a goods receipt for a
 * purchase order or to document the transfer of materials between two storage locations. Additionally, the service
 * allows you to cancel existing material documents or single items. It can be consumed by external systems and user
 * interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d4/c919581bc30a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MATERIAL_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MATERIAL_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Material Document Integration(SAP_COM_0108)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMC'>Core Inventory Management(BMC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMC'>Core Inventory Management(OMC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Material Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaterialDocumentService" )
@Deprecated
public class DefaultMaterialDocumentService implements MaterialDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaterialDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaterialDocumentService()
    {
        servicePath = MaterialDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaterialDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaterialDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaterialDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaterialDocumentServiceBatch batch()
    {
        return new DefaultMaterialDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaterialDocumentHeaderFluentHelper getAllMaterialDocumentHeader()
    {
        return new MaterialDocumentHeaderFluentHelper(servicePath, "A_MaterialDocumentHeader");
    }

    @Override
    @Nonnull
    public
        MaterialDocumentHeaderByKeyFluentHelper
        getMaterialDocumentHeaderByKey( final String materialDocumentYear, final String materialDocument )
    {
        return new MaterialDocumentHeaderByKeyFluentHelper(
            servicePath,
            "A_MaterialDocumentHeader",
            materialDocumentYear,
            materialDocument);
    }

    @Override
    @Nonnull
    public MaterialDocumentHeaderCreateFluentHelper createMaterialDocumentHeader(
        @Nonnull final MaterialDocumentHeader materialDocumentHeader )
    {
        return new MaterialDocumentHeaderCreateFluentHelper(
            servicePath,
            materialDocumentHeader,
            "A_MaterialDocumentHeader");
    }

    @Override
    @Nonnull
    public MaterialDocumentItemFluentHelper getAllMaterialDocumentItem()
    {
        return new MaterialDocumentItemFluentHelper(servicePath, "A_MaterialDocumentItem");
    }

    @Override
    @Nonnull
    public MaterialDocumentItemByKeyFluentHelper getMaterialDocumentItemByKey(
        final String materialDocumentYear,
        final String materialDocument,
        final String materialDocumentItem )
    {
        return new MaterialDocumentItemByKeyFluentHelper(
            servicePath,
            "A_MaterialDocumentItem",
            materialDocumentYear,
            materialDocument,
            materialDocumentItem);
    }

    @Override
    @Nonnull
    public SerialNumberMaterialDocumentFluentHelper getAllSerialNumberMaterialDocument()
    {
        return new SerialNumberMaterialDocumentFluentHelper(servicePath, "A_SerialNumberMaterialDocument");
    }

    @Override
    @Nonnull
    public SerialNumberMaterialDocumentByKeyFluentHelper getSerialNumberMaterialDocumentByKey(
        final String material,
        final String serialNumber,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear )
    {
        return new SerialNumberMaterialDocumentByKeyFluentHelper(
            servicePath,
            "A_SerialNumberMaterialDocument",
            material,
            serialNumber,
            materialDocument,
            materialDocumentItem,
            materialDocumentYear);
    }

    @Override
    @Nonnull
    public CancelFluentHelper cancel(
        @Nonnull final String materialDocumentYear,
        @Nonnull final String materialDocument,
        @Nullable final LocalDateTime postingDate )
    {
        return new CancelFluentHelper(servicePath, materialDocumentYear, materialDocument, postingDate);
    }

    @Override
    @Nonnull
    public CancelItemFluentHelper cancelItem(
        @Nonnull final String materialDocumentYear,
        @Nonnull final String materialDocument,
        @Nonnull final String materialDocumentItem,
        @Nullable final LocalDateTime postingDate )
    {
        return new CancelItemFluentHelper(
            servicePath,
            materialDocumentYear,
            materialDocument,
            materialDocumentItem,
            postingDate);
    }

}
