/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.batch.DefaultMaterialPlanningDataServiceBatch;

/**
 * <p>
 * The service contains entities for material master data, supply and demand information, and information about the
 * coverage of materials. You can read master data for one or more materials. You can read supply and demand information
 * over a certain time period, or you can aggregate the quantities on category group level. You can read material
 * coverage information.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ca/111d6ed0004ac088b68f1360cf24fc/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MRP_MATERIALS_SRV_01?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MRP_MATERIALS_SRV_01</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Material Supply And Demand View</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaterialPlanningDataService" )
@Deprecated
public class DefaultMaterialPlanningDataService implements MaterialPlanningDataService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaterialPlanningDataService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaterialPlanningDataService()
    {
        servicePath = MaterialPlanningDataService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaterialPlanningDataService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaterialPlanningDataService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaterialPlanningDataService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaterialPlanningDataServiceBatch batch()
    {
        return new DefaultMaterialPlanningDataServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaterialCoverageFluentHelper getAllMaterialCoverage()
    {
        return new MaterialCoverageFluentHelper(servicePath, "MaterialCoverages");
    }

    @Override
    @Nonnull
    public MaterialCoverageByKeyFluentHelper getMaterialCoverageByKey(
        final String material,
        final String materialShortageProfile,
        final String materialShortageProfileCount,
        final String mRPArea,
        final String mRPPlanningSegmentNumber,
        final String mRPPlanningSegmentType,
        final String mRPPlant )
    {
        return new MaterialCoverageByKeyFluentHelper(
            servicePath,
            "MaterialCoverages",
            material,
            materialShortageProfile,
            materialShortageProfileCount,
            mRPArea,
            mRPPlanningSegmentNumber,
            mRPPlanningSegmentType,
            mRPPlant);
    }

    @Override
    @Nonnull
    public SupplyDemandItemFluentHelper getAllSupplyDemandItem()
    {
        return new SupplyDemandItemFluentHelper(servicePath, "SupplyDemandItems");
    }

    @Override
    @Nonnull
    public MRPMaterialFluentHelper getAllMRPMaterial()
    {
        return new MRPMaterialFluentHelper(servicePath, "A_MRPMaterial");
    }

    @Override
    @Nonnull
    public
        MRPMaterialByKeyFluentHelper
        getMRPMaterialByKey( final String material, final String mRPPlant, final String mRPArea )
    {
        return new MRPMaterialByKeyFluentHelper(servicePath, "A_MRPMaterial", material, mRPPlant, mRPArea);
    }

}
