/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.InventoryPriceChangeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.batch.DefaultMaterialPriceServiceBatch;

/**
 * <p>
 * This service enables you to change the existing prices of your materials by importing new prices into the material
 * master. If stock exists for the material, a revaluation posting is generated. The revaluation posting indicates the
 * material ledger document number and year.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/93/18a0fe2606406dbaa49246c3d93bde/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MATERIAL_VALUATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MATERIAL_VALUATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Material Price Changes and Inventory Values Integration(SAP_COM_0147)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1ZT'>Managing Material Price Changes and Inventory
 * Values(1ZT)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/OZT'>Managing Material Price Changes and Inventory
 * Values(OZT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaterialPriceService" )
@Deprecated
public class DefaultMaterialPriceService implements MaterialPriceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaterialPriceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaterialPriceService()
    {
        servicePath = MaterialPriceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaterialPriceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaterialPriceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaterialPriceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaterialPriceServiceBatch batch()
    {
        return new DefaultMaterialPriceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public InventoryPriceChangeFluentHelper inventoryPriceChange(
        @Nonnull final String currency,
        @Nonnull final String currencyRole,
        @Nonnull final String material,
        @Nonnull final BigDecimal inventoryPrice,
        @Nonnull final LocalDateTime postingDate,
        @Nonnull final BigDecimal materialPriceUnitQty,
        @Nonnull final String valuationArea,
        @Nonnull final String inventoryValuationType )
    {
        return new InventoryPriceChangeFluentHelper(
            servicePath,
            currency,
            currencyRole,
            material,
            inventoryPrice,
            postingDate,
            materialPriceUnitQty,
            valuationArea,
            inventoryValuationType);
    }

}
