/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStockByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctModByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctModFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.batch.DefaultMaterialStockDisplayServiceBatch;

/**
 * <p>
 *
 * This service enables you to retrieve material stock information using the OData protocol with filter data provided in
 * the payload. It can be consumed by external warehouse applications..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f6/8f51a4dc2e46779877a10a301d9138/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MATERIAL_STOCK_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MATERIAL_STOCK_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Material Stock Integration(SAP_COM_0164)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMC'>Core Inventory Management(BMC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMC'>Core Inventory Management(OMC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Material Stock</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultMaterialStockDisplayService" )
@Deprecated
public class DefaultMaterialStockDisplayService implements MaterialStockDisplayService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link MaterialStockDisplayService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultMaterialStockDisplayService()
    {
        servicePath = MaterialStockDisplayService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultMaterialStockDisplayService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMaterialStockDisplayService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultMaterialStockDisplayService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultMaterialStockDisplayServiceBatch batch()
    {
        return new DefaultMaterialStockDisplayServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaterialStockFluentHelper getAllMaterialStock()
    {
        return new MaterialStockFluentHelper(servicePath, "A_MaterialStock");
    }

    @Override
    @Nonnull
    public MaterialStockByKeyFluentHelper getMaterialStockByKey( final String material )
    {
        return new MaterialStockByKeyFluentHelper(servicePath, "A_MaterialStock", material);
    }

    @Override
    @Nonnull
    public MatlStkInAcctModFluentHelper getAllMatlStkInAcctMod()
    {
        return new MatlStkInAcctModFluentHelper(servicePath, "A_MatlStkInAcctMod");
    }

    @Override
    @Nonnull
    public MatlStkInAcctModByKeyFluentHelper getMatlStkInAcctModByKey(
        final String material,
        final String plant,
        final String storageLocation,
        final String batch,
        final String supplier,
        final String customer,
        final String wBSElementInternalID,
        final String sDDocument,
        final String sDDocumentItem,
        final String inventorySpecialStockType,
        final String inventoryStockType )
    {
        return new MatlStkInAcctModByKeyFluentHelper(
            servicePath,
            "A_MatlStkInAcctMod",
            material,
            plant,
            storageLocation,
            batch,
            supplier,
            customer,
            wBSElementInternalID,
            sDDocument,
            sDDocumentItem,
            inventorySpecialStockType,
            inventoryStockType);
    }

}
