/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.DeleteBOMHdrWithChangeNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.DeleteBOMItemWithChangeNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.batch.DefaultOrderBillOfMaterialServiceBatch;

/**
 * <p>
 *
 * The service contains either no header, one header, or multiple headers for the specified order bill of material and
 * zero or more items for each header.
 *
 * The required information is sent in the request as a payload to create, update, or delete order bill of material and
 * items, make appropriate checks for restricted values. If there are any issues when the order bill of material is
 * created, updated, or deleted, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/02/d11a1c68bd451d91182e1e6ee5fb25/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_ORDER_BILL_OF_MATERIAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_ORDER_BILL_OF_MATERIAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultOrderBillOfMaterialService" )
@Deprecated
public class DefaultOrderBillOfMaterialService implements OrderBillOfMaterialService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link OrderBillOfMaterialService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultOrderBillOfMaterialService()
    {
        servicePath = OrderBillOfMaterialService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultOrderBillOfMaterialService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultOrderBillOfMaterialService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultOrderBillOfMaterialService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultOrderBillOfMaterialServiceBatch batch()
    {
        return new DefaultOrderBillOfMaterialServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BOMItemCategoryFluentHelper getAllBOMItemCategory()
    {
        return new BOMItemCategoryFluentHelper(servicePath, "A_BOMItemCategory");
    }

    @Override
    @Nonnull
    public BOMItemCategoryByKeyFluentHelper getBOMItemCategoryByKey( final String billOfMaterialItemCategory )
    {
        return new BOMItemCategoryByKeyFluentHelper(servicePath, "A_BOMItemCategory", billOfMaterialItemCategory);
    }

    @Override
    @Nonnull
    public BOMItemCategoryTextFluentHelper getAllBOMItemCategoryText()
    {
        return new BOMItemCategoryTextFluentHelper(servicePath, "A_BOMItemCategoryText");
    }

    @Override
    @Nonnull
    public
        BOMItemCategoryTextByKeyFluentHelper
        getBOMItemCategoryTextByKey( final String language, final String billOfMaterialItemCategory )
    {
        return new BOMItemCategoryTextByKeyFluentHelper(
            servicePath,
            "A_BOMItemCategoryText",
            language,
            billOfMaterialItemCategory);
    }

    @Override
    @Nonnull
    public SalesOrderBOMItemFluentHelper getAllSalesOrderBOMItem()
    {
        return new SalesOrderBOMItemFluentHelper(servicePath, "SalesOrderBOMItem");
    }

    @Override
    @Nonnull
    public SalesOrderBOMItemByKeyFluentHelper getSalesOrderBOMItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialItemNodeNumber,
        final String headerChangeDocument,
        final String material,
        final String plant )
    {
        return new SalesOrderBOMItemByKeyFluentHelper(
            servicePath,
            "SalesOrderBOMItem",
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialItemNodeNumber,
            headerChangeDocument,
            material,
            plant);
    }

    @Override
    @Nonnull
    public SalesOrderBOMItemCreateFluentHelper createSalesOrderBOMItem(
        @Nonnull final SalesOrderBOMItem salesOrderBOMItem )
    {
        return new SalesOrderBOMItemCreateFluentHelper(servicePath, salesOrderBOMItem, "SalesOrderBOMItem");
    }

    @Override
    @Nonnull
    public SalesOrderBOMItemUpdateFluentHelper updateSalesOrderBOMItem(
        @Nonnull final SalesOrderBOMItem salesOrderBOMItem )
    {
        return new SalesOrderBOMItemUpdateFluentHelper(servicePath, salesOrderBOMItem, "SalesOrderBOMItem");
    }

    @Override
    @Nonnull
    public SalesOrderBOMItemDeleteFluentHelper deleteSalesOrderBOMItem(
        @Nonnull final SalesOrderBOMItem salesOrderBOMItem )
    {
        return new SalesOrderBOMItemDeleteFluentHelper(servicePath, salesOrderBOMItem, "SalesOrderBOMItem");
    }

    @Override
    @Nonnull
    public SalesOrderBOMFluentHelper getAllSalesOrderBOM()
    {
        return new SalesOrderBOMFluentHelper(servicePath, "SalesOrderBOM");
    }

    @Override
    @Nonnull
    public SalesOrderBOMByKeyFluentHelper getSalesOrderBOMByKey(
        final String billOfMaterialCategory,
        final String billOfMaterial,
        final String billOfMaterialVariant,
        final String engineeringChangeDocument,
        final String material,
        final String plant )
    {
        return new SalesOrderBOMByKeyFluentHelper(
            servicePath,
            "SalesOrderBOM",
            billOfMaterialCategory,
            billOfMaterial,
            billOfMaterialVariant,
            engineeringChangeDocument,
            material,
            plant);
    }

    @Override
    @Nonnull
    public SalesOrderBOMCreateFluentHelper createSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM )
    {
        return new SalesOrderBOMCreateFluentHelper(servicePath, salesOrderBOM, "SalesOrderBOM");
    }

    @Override
    @Nonnull
    public SalesOrderBOMUpdateFluentHelper updateSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM )
    {
        return new SalesOrderBOMUpdateFluentHelper(servicePath, salesOrderBOM, "SalesOrderBOM");
    }

    @Override
    @Nonnull
    public SalesOrderBOMDeleteFluentHelper deleteSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM )
    {
        return new SalesOrderBOMDeleteFluentHelper(servicePath, salesOrderBOM, "SalesOrderBOM");
    }

    @Override
    @Nonnull
    public DeleteBOMItemWithChangeNumberFluentHelper deleteBOMItemWithChangeNumber(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit )
    {
        return new DeleteBOMItemWithChangeNumberFluentHelper(
            servicePath,
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialItemNodeNumber,
            headerChangeDocument,
            material,
            plant,
            engineeringChangeDocForEdit);
    }

    @Override
    @Nonnull
    public DeleteBOMHdrWithChangeNumberFluentHelper deleteBOMHdrWithChangeNumber(
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit )
    {
        return new DeleteBOMHdrWithChangeNumberFluentHelper(
            servicePath,
            billOfMaterialCategory,
            billOfMaterial,
            billOfMaterialVariant,
            engineeringChangeDocument,
            material,
            plant,
            engineeringChangeDocForEdit);
    }

}
